/*
 *	Windows Soar v1.0
 *	GUI code (c) 1993 Price Waterhouse,
 *	Soar 6.1 kernel (c) Carnegie Mellon University
 */

// Prodview.cpp
//

#include "stdafx.h"
#include "soar.h"
#include "prodview.h"
#include "machdoc.h"
#include "editdlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CProductionView

IMPLEMENT_DYNCREATE(CChunkView,CProductionView)

CChunkView::CChunkView()
	: CProductionView()
{
	m_Type=CMachineDoc::IDH_CHUNK;
}


IMPLEMENT_DYNCREATE(CProductionView,CFormView)

CProductionView::CProductionView()
	: CFormView(CProductionView::IDD)
{
	m_Type=CMachineDoc::IDH_PRODUCTION;
}

CProductionView::~CProductionView()
{
}


/*
 * Make sure the windows are updated properly
 */
void CProductionView::OnUpdate(CView *pView,LPARAM lHint,CObject *pHint)
{
	CMachineDoc* pDoc = (CMachineDoc *)GetDocument();

	if ((lHint&0xff)==m_Type) {
	  switch (lHint&0xff00) {
	    case CMachineDoc::IDH_ADD:
	      m_ProductionList.AddString(*(CString *)pHint);
	      break;
	    case CMachineDoc::IDH_REMOVE:
	      m_ProductionList.DeleteString(m_ProductionList.FindString(-1,*(CString *)pHint));
	      break;
	    case CMachineDoc::IDH_CLEAR:
	      m_ProductionList.ResetContent();
	      break;
	  }
	}
}

/*
 * Firsttime loading of the production into the windows
 */
void CProductionView::OnInitialUpdate()
{
	char buff[MISC_STRING_SIZE];
	CFormView::OnInitialUpdate();  
	CMachineDoc* pDoc = (CMachineDoc *)GetDocument();
	CPtrList *pList;

	switch (m_Type) {
	  case CMachineDoc::IDH_CHUNK:
		m_NameText.SetWindowText("Chunks");
		pList = &pDoc->m_ChunkList;
		break;
	  case CMachineDoc::IDH_PRODUCTION:
	    m_NameText.SetWindowText("Productions");
	    pList = &pDoc->m_ProductionList;
	    break;
	}
	                  
	m_ProductionList.ResetContent();
	for (POSITION pos=pList->GetHeadPosition();pos!=NULL;)
	  m_ProductionList.AddString(CString(symbol_to_string(((production *)pList->GetNext(pos))->name,TRUE,buff)));	  
}

void CProductionView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CProductionView)
	DDX_Control(pDX, IDC_NAME, m_NameText);
	DDX_Control(pDX, IDC_PTRACE, m_PtraceToggle);
	DDX_Control(pDX, IDC_PRODUCTION_RHS, m_RhsEdit);
	DDX_Control(pDX, IDC_PRODUCTION_NAME, m_NameEdit);
	DDX_Control(pDX, IDC_PRODUCTION_LHS, m_LhsEdit);
	DDX_Control(pDX, IDC_PROD_LIST, m_ProductionList);
	DDX_Control(pDX, IDC_MATCHES, m_MatchesButton);
	DDX_Control(pDX, IDC_LOAD, m_LoadButton);
	DDX_Control(pDX, IDC_EXCISE, m_ExciseButton);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CProductionView, CFormView)
	//{{AFX_MSG_MAP(CProductionView)
	ON_BN_CLICKED(IDC_EXCISE, OnClickedExcise)
	ON_BN_CLICKED(IDC_LOAD, OnClickedLoad)
	ON_BN_CLICKED(IDC_MATCHES, OnClickedMatches)
	ON_LBN_DBLCLK(IDC_PROD_LIST, OnDblclkProductionList)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProductionView message handlers

/*
 * Macros useful for the string I/O hack...
 */

#define OUTPUT_TO(buff) \
    int ___ptos=current_agent(using_output_string); \
    char* ___str=current_agent(output_string); \
    current_agent(using_output_string)=TRUE; \
    current_agent(output_string)=buff; 

#define OUTPUT_DONE() \
	current_agent(using_output_string)=___ptos; \
	current_agent(output_string)=___str;

#define INPUT_FROM(buff) \
    int ___ptos=current_agent(using_input_string); \
    char* ___str=current_agent(input_string); \
    current_agent(using_input_string)=TRUE; \
    current_agent(input_string)=buff; 

#define INPUT_DONE() \
	current_agent(using_input_string)=___ptos; \
	current_agent(input_string)=___str;


void unixtodos(char *cstr)
{
  CString nstr;

  ASSERT(cstr);
  for (int i=0;cstr[i]!=0;i++) {
    if (cstr[i]=='\n')
      nstr+="\r\n";
    else
      nstr+=cstr[i];
  }
  
  strcpy(cstr,nstr);
}

/*
 * get that production right outta my rete..
 */
void CProductionView::OnClickedExcise()
{   
	Symbol *sym;
	char buff[MISC_STRING_SIZE];
	m_ProductionList.GetText(m_ProductionList.GetCurSel(),buff);
	sym = find_sym_constant(buff);
	if (sym && sym->sc.production)
	  excise_production(sym->sc.production,TRUE);
	else
	  AfxMessageBox("No production with this name to excise.");
}

/*
 * Load the production that has been edited into the rete
 */
void CProductionView::OnClickedLoad()
{
	char buff[10240]; // For the entire production....
	CString cstr;
	Symbol *sym;

	if (m_NameEdit.GetModify()) {
	  if ((!m_LhsEdit.GetModify())&&
		  (!m_RhsEdit.GetModify())) 
	    switch (AfxMessageBox("Excise old production?",MB_YESNOCANCEL)) {
	      case IDYES:
	        sym = find_sym_constant(m_NameOrig);
			if (sym && sym->sc.production)
			  excise_production(sym->sc.production,TRUE);
			break;
		  case IDNO:
		    break;
		  case IDCANCEL:
		    return;
		}
	}

	INPUT_FROM(buff);
	
	m_NameEdit.GetWindowText(cstr);
	strcpy(buff,cstr);
	m_LhsEdit.GetWindowText(cstr);
	strcat(buff,cstr);
	strcat(buff,"-->");
	m_RhsEdit.GetWindowText(cstr);
	strcat(buff,cstr);
	strcat(buff,")");
	  
	current_agent(current_char)=' ';
	get_lexeme();
	if (parse_production()==NULL)
	  AfxMessageBox("Invalid production syntax!");
	
	INPUT_DONE();
}

/*
 * Print matches info on the production
 */
void CProductionView::OnClickedMatches()
{
	char buff[10240]={0};
	CEditDialog eDlg;
	Symbol *sym;
	
	m_ProductionList.GetText(m_ProductionList.GetCurSel(),buff);
	sym = find_sym_constant(buff);
	if ((sym==NULL) || (sym->sc.production==NULL))
	  return;

	OUTPUT_TO(buff);
	
	print_partial_match_information (sym->sc.production->p_node, 0);
	
	OUTPUT_DONE();
	
	unixtodos(buff);
	eDlg.m_EditString=buff;
	eDlg.DoModal();
}

/*
 * Aha! So he wants to see this new production, and possibly edit it
 */
void CProductionView::OnDblclkProductionList()
{
    char buff[10240]={0}; // This has _got_ to be big enough...
    CString cstr;
    Symbol *sym;
	production *pProd;
    condition *top, *bottom;
    
	m_ProductionList.GetText(m_ProductionList.GetCurSel(),buff);
	sym = find_sym_constant(buff);
	if ((sym==NULL) || (sym->sc.production==NULL))
	  return;
	else
	  pProd=sym->sc.production;
    
	OUTPUT_TO(buff);
    
    m_NameOrig=symbol_to_string(pProd->name,TRUE,buff);
    m_NameEdit.SetWindowText(m_NameOrig);
    buff[0]=0;
    
    p_node_to_conditions_and_nots(pProd->p_node, NIL, NIL, &top, &bottom, NIL);
    print_condition_list(top,1,FALSE);
    deallocate_condition_list(top);
    
	unixtodos(buff);
    m_LhsEdit.SetWindowText(CString(buff));
    buff[0]=0;
    
    print_action_list(pProd->action_list,2,FALSE);
	unixtodos(buff);
    m_RhsEdit.SetWindowText(CString(buff));
    buff[0]=0;
    
    if (pProd->type==USER_PRODUCTION_TYPE) {
      m_NameEdit.SetReadOnly(FALSE);
      m_LhsEdit.SetReadOnly(FALSE);
      m_RhsEdit.SetReadOnly(FALSE);
    } else {
      m_NameEdit.SetReadOnly(FALSE);
      m_LhsEdit.SetReadOnly(TRUE);
      m_RhsEdit.SetReadOnly(TRUE);
    }
    
	OUTPUT_DONE();
}

