/*
 *	Windows Soar v1.0
 *	GUI code (c) 1993 Price Waterhouse,
 *	Soar 6.1 kernel (c) Carnegie Mellon University
 */

// logview.cpp : implementation file
//

#include "stdafx.h"
#include "soar.h"
#include "logview.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLogView

IMPLEMENT_DYNCREATE(CLogView, CView)

CLogView::CLogView()
{
}

CLogView::~CLogView()
{
}


BEGIN_MESSAGE_MAP(CLogView, CView)
	//{{AFX_MSG_MAP(CLogView)
	ON_WM_HSCROLL()
	ON_WM_VSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLogView drawing

void CLogView::OnInitialUpdate()
{
	CView::OnInitialUpdate();
	CMachineDoc* pDoc = (CMachineDoc *)GetDocument();
	
	SetScrollRange(SB_HORZ,0,256);
	SetScrollRange(SB_VERT,0,pDoc->m_LogList.GetCount());
}


/*
 * If the hint is to update the log, update the log! 
 */
void CLogView::OnUpdate(CView *pView, LPARAM lHint, CObject *pObject)
{
	CMachineDoc* pDoc = (CMachineDoc *)GetDocument();
	
	if ((lHint&0xff)==CMachineDoc::IDH_LOG) {
	  SetScrollRange(SB_VERT,0,pDoc->m_LogList.GetCount());
	  SetScrollPos(SB_VERT,pDoc->m_LogList.GetCount());
	  Invalidate();
	}
}

            
void CLogView::OnDraw(CDC* pDC)
{
	CMachineDoc* pDoc = (CMachineDoc *)GetDocument();
	TEXTMETRIC tmet;
    int i=0,y;
    CRect rect;
    
	pDC->GetTextMetrics(&tmet);
    GetClientRect(&rect);
	y=GetScrollPos(SB_VERT) -  (rect.bottom/tmet.tmHeight);	
	y= y<0 ? 0 : y;

	for (POSITION pos = pDoc->m_LogList.GetHeadPosition();
	     (pos != NULL);i++) {
	  CString *pStr= &pDoc->m_LogList.GetNext(pos);
	  if (i>=y)
	    pDC->TextOut(0,tmet.tmHeight*(i-y),*pStr);
	}	  
}

/////////////////////////////////////////////////////////////////////////////
// CLogView message handlers


void CLogView::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	ASSERT(pScrollBar == GetScrollBarCtrl(SB_HORZ));    // may be null
	OnScroll(SB_HORZ, nSBCode, nPos);
}

void CLogView::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)
{
	ASSERT(pScrollBar == GetScrollBarCtrl(SB_VERT));    // may be null
	OnScroll(SB_VERT, nSBCode, nPos);
}

void CLogView::OnScroll(int nBar, UINT nSBCode, UINT nPos)
{
	ASSERT(nBar == SB_HORZ || nBar == SB_VERT);
	BOOL bHorz = (nBar == SB_HORZ);

	int zOrig, z;   // z = x or y depending on 'nBar'
	int zMin, zMax;
	zOrig = z = GetScrollPos(nBar);
	GetScrollRange(nBar, &zMin, &zMax);
	ASSERT(zMin == 0);
	if (zMax <= 0)
	{
		TRACE0("Warning: no scroll range - ignoring scroll message\n");
		ASSERT(z == 0);     // must be at top
		return;
	}

	switch (nSBCode)
	{
	case SB_TOP:
		z = 0;
		break;

	case SB_BOTTOM:
		z = zMax;
		break;
		
	case SB_LINEUP://x : y
		z -= bHorz ? 0 : 1;
		break;

	case SB_LINEDOWN:
		z += bHorz ? 0 : 1;
		break;

	case SB_PAGEUP:
		z -= bHorz ? 0 : 0;
		break;

	case SB_PAGEDOWN:
		z += bHorz ? 0 : 0;
		break;

	case SB_THUMBTRACK:
		z = nPos;
		break;

	default:        // ignore other notifications
		return;
	}

	if (z < 0)
		z = 0;
	else if (z > zMax)
		z = zMax;

	if (z != zOrig)
	{
		Invalidate();
		SetScrollPos(nBar, z);
		UpdateWindow();
	}
}




