;;; -*- Mode:Common-Lisp; Base:10 -*-



(defun xref (files)
	(foo (expand-wildcards files))
)

(defun spprint (lofl)
  (let ((slist (sort lofl #'(lambda (a b) (minusp (string-compare (princ-to-string a) (princ-to-string b)))) :key #'car)))
    (format t "~&~10A~30A~A" "prod #" "filename" "function name")
    (format t "~&~10A~30A~A" "------" "--------" "-------------")
    (mapc #'(lambda (spelem)
	      (format t "~&~10A~30A~A" (cadr spelem) 
				       (format nil "~A.~A" (fs:pathname-name (caddr spelem))
							   (fs:pathname-type (caddr spelem))
							   )
				       (car spelem))
	      )
	  slist
	  )
    )
)

(defun foo (cla)
  (spprint
    (let ((arglist cla) reflist)
      (do ((splist)
	   (inport)
	   (sexplist)
	   (spnum 0 0)
	   (fname)
	   )
	  ((null arglist))
	(setq fname (car arglist))
	(setq arglist (cdr arglist))
	(with-open-file (inport fname)
	  (setq sexplist nil)
	  (do ((temp))
	      ((eq temp 'EOF))
	    (setq temp (read inport nil 'EOF))
	    (cond	((not (eq temp 'EOF))
			 (setq sexplist
			       (cons temp sexplist))
			 )
			(t	nil)
			)
	    )
	  (setq sexplist (reverse sexplist))
	  (setq splist
		(mapcan '(lambda (sexp)
			   (cond	((atom sexp)	nil)
					((or	(eq (car sexp) 'sp)
						(eq (car sexp) 'SP)
						(eq (car sexp) 'p)
						(eq (car sexp) 'P)
						)
					 (setq spnum (1+ spnum))
					 `((	,(cadr sexp)
					    ,spnum
					    ,fname
					    ))
					 )
					(t		nil)
					)
			   )
			sexplist
			)
		)
	  (setq reflist (append reflist splist))
	  )
	)
      reflist
      )
    )
  nil
)



(defun expand-wildcards (file-list)
  (do ((expanded nil)
       (unexpanded file-list (cdr unexpanded))
       (filename)
      )
      ((null unexpanded) (reverse expanded))
    (setq filename (fs:merge-and-set-pathname-defaults (car unexpanded) nil nil :newest))
    (let ((files (fs:directory-list filename :noerror :sorted)))
      (dolist (file files)
	(when (pathnamep (car file))
	  (setq expanded (cons (car file) expanded))
	)
      )
    )
  )
)
