;;; -*- Mode:Common-Lisp; Package:USER; Base:10 -*-

(defun autorun (&optional (n nil nbound) (learn nil) (accept-file nil) (use-d t))
  (if learn
      (learn on trace)
      (learn never)
  )
  (user-select 'first)
  (when accept-file
    (open-accept-file accept-file)
    )
  (if (and nbound n)
      (if use-d
	  (eval `(d ,n))
	  (eval `(run ,n))
      )
      (run)
  )
  (when accept-file
    (close-accept-file)
    )
)


(defun setup-batch-run ()
  (soarload "x9:rw.soar;stop-runaway.soar")
  (load "x9:rw.soar.tools;time-stamp")
  (load "x9:rw.soar.tools;accept")
  (load "x19:guardian;screen-saver-off")
)

;;;Edited by rw                    17 Aug 88  10:37
(defun batch-run (case-file &optional (n nil) (learn nil) (accept-file nil) (use-d t))
  (init-soar)
  (let ((inhibit-fdefine-warnings t))
    (soarload case-file)
    )
  (setq last-time nil)
  (setq first-time nil)
  (gc-immediately :silent t)
  (time (autorun n learn accept-file use-d))
  (print-stats)
)
