;;; -*- Mode:Zetalisp; Package:USER; Base:10 -*-

(defun open-accept-file (filename)
  (putprop 'accept-file (open filename :direction :input) 'inputfile)
  (setq *accept-file* 'accept-file)
)

(defun close-accept-file ()
  (setq *accept-file* nil)
  (close (get 'accept-file 'inputfile))
)

(defun nlam-accept (z) ; Randy.Gobbel 18-Sep-86 12:34 
       (prog (port arg result)
	     (cond ((> (length z)
		       1)
		    (soarwarn "ACCEPT: wrong number of arguments" z)
		    (return nil)))
	     (setq port t)
	     (cond (*accept-file* (setq port ($ifile *accept-file*))
				  (cond ((null port)
					 (soarwarn 
					     "ACCEPT: file has been closed"
						   *accept-file*)
					 (return nil)))))
	     (cond ((eqp (length z)
			 1)
		    (setq arg ($varbind (car z)))
		    (cond ((not (symbolp arg))
			   (soarwarn "ACCEPT: illegal file name" arg)
			   (return nil)))
		    (setq port ($ifile arg))
		    (cond ((null port)
			   (soarwarn "ACCEPT: file not open for input" arg)
			   (return nil)))))
	     (stop-elapsed-time)
	     (dotimes (i 3) (tv:whoop))
	     (setq result (list (flat-value (read port 'end-of-file))))
	     (if (equal result '(end-of-file))
		 (progn
		   (soarprinc "<end of file -- reverting to terminal input>")
		   (close-accept-file)
		   (setq result (nlam-accept z))
		 )
		 (progn
		   (when *accept-file*
		     (soarprinc "<read '")
		     (soarprinc result)
		     (soarprinc "' from file>")
		   )
		 )
	     )
	     (start-elapsed-time)
	     (return result)))

