(in-package "PRODIGY4")
;; matches bindings and operators against the state.  


;; The instantiated-op structure has two slots. The OP slot points to
;; the operator structure, or operator schema.  The values slot points
;; to a sequence of prodigy objects that match VARS sequence of the
;; rule.  

;;; Well, these days it has a few more slots than that. The
;;; conditional slot records whether the operator is making use of a
;;; conditional effect, the precond stores the instantiated
;;; preconditions, and the binding-node-back-pointer connects the
;;; instantiated operator to its node.
(defstruct (instantiated-op (:print-function instantiated-op-print))
           op
	   values
	   (conditional nil)
	   precond
	   binding-node-back-pointer
	   (conspiracy 0)
	   (plist nil))            ; Added by Jim at Alicia's request 2/13/93

(defun instantiated-op-print (op stream z)
  (declare (type instantiated-op op)
	   (stream stream)
	   (ignore z))
  (let ((*standard-output* stream))
    (princ "#<")
    (princ (operator-name (instantiated-op-op op)))
    (map nil #'(lambda (x y)
		 (princ " [")
		 (princ x)
		 (princ " ")
		 (cond ((typep y 'prodigy-object)
			(princ (prodigy-object-name y)))
		       ((null y) (princ "()"))
		       ((listp y) (princ "(..)"))
		       (t (princ y)))
		 (princ "]"))
	 (operator-vars (instantiated-op-op op))
	 (instantiated-op-values op))
    (princ ">")))
   
  
;; The extended assertion is a typed, named structure which means it
;; will be an ordinary lisp LIST object.  The first cons will hold the
;; type, the second the parity and the third the assertion, but we
;; won't have to worry about this because we'll have the automatic
;; accessor functions that are built for us.
	
(defstruct (extended-assertion (:type list) :named)
           (parity nil)
	   (literal nil)) ;; this will always be of type assertion

#|(defun generate-applicable-ops (node)
  (generate-applicable-ops-the-2nd node nil))

(defun generate-applicable-ops-the-2nd (node applied-inst-ops)
  (cond ((null (nexus-parent node))  ;; are we at top of path
         nil)
	
	((and (binding-node-p node)
	      (applicable-op-p node)
	      (not (member (binding-node-instantiated-op node) applied-inst-ops)))
	 (cons
	  (binding-node-instantiated-op node)
	  (generate-applicable-ops-the-2nd (nexus-parent node)
					   applied-inst-ops)))
	((applied-op-node-p node)
	 (generate-applicable-ops-the-2nd (nexus-parent node)
					  (cons
					   (applied-op-node-instantiated-op node)
					   applied-inst-ops)))
	(t
	 (generate-applicable-ops-the-2nd (nexus-parent node)
					  applied-inst-ops))))
|#

(defun generate-applicable-ops (node)
  (cond ((and (binding-node-p node)
	      (not (inference-rule-a-or-b-node-p node))
	      (applicable-op-p node))
	 (list (binding-node-instantiated-op node)))
	((getf (problem-space-plist *current-problem-space*)
	       :permute-application-order)
	 (old-gen-apps-r node nil))
	(t
	 (gen-apps-r node nil))))

(defun old-gen-apps-r (node applied-inst-ops)
  (cond ((null (nexus-parent node)) nil)

	((and (binding-node-p node)
	     (not (inference-rule-a-or-b-node-p node))
	     (applicable-op-p node)
	     (not (member node applied-inst-ops)))
	 (list (binding-node-instantiated-op node)))

	#| ;; This used to be done, but isn't needed for completeness.
	 (cons (binding-node-instantiated-op node)
	       (old-gen-apps-r (nexus-parent node) (cons node applied-inst-ops))))
|#


	;;; If this op could be applied earlier in some other branch, leading
	;;; to the same application sequence, don't do it here.
	((and (typep node 'goal-node)
	      (null applied-inst-ops)
	      (something-should-be-applied-here-p (nexus-parent node)))
	 nil)

	((and (typep node 'applied-op-node)
	      (not (inference-rule-a-or-b-node-p node)))
	 (old-gen-apps-r (nexus-parent node)
		     (cons (instantiated-op-binding-node-back-pointer
			    (applied-op-node-instantiated-op node))
			   applied-inst-ops)))

	(t (old-gen-apps-r (nexus-parent node) applied-inst-ops))))

(defun gen-apps-r (node applied-inst-ops)
  (cond ((null (nexus-parent node)) nil)

	((and (binding-node-p node)
	      (not (inference-rule-a-or-b-node-p node))
	      (not (member node applied-inst-ops)))
	 (if (applicable-op-p node)
	     (list (binding-node-instantiated-op node))))

	;; If this op could be applied earlier in some other branch, leading
	;; to the same application sequence, don't do it here.
	((and (typep node 'goal-node)
	      (null applied-inst-ops)
	      (something-should-be-applied-here-p (nexus-parent node)))
	 nil)

	((and (typep node 'applied-op-node)
	      (not (inference-rule-a-or-b-node-p node)))
	 (gen-apps-r (nexus-parent node)
		     (cons (instantiated-op-binding-node-back-pointer
			    (applied-op-node-instantiated-op node))
			   applied-inst-ops)))

	(t (gen-apps-r (nexus-parent node) applied-inst-ops))))

(defun something-should-be-applied-here-p (node)

  ;; This is the parent of a goal node.
  (or (a-or-b-node-applicable-ops-left node)
      (some #'(lambda (child) (typep child 'applied-op-node))
	    (nexus-children node))))


#|

;; An operator schema is combined with a particular binding to form
;; and instantiated precond.  Applicable-op-p maps over each precond
;; looking for one of which good-instantiation is true. 

(defun applicable-op-p (binding-node)
  (declare (type binding-node binding-node))
  (some #'good-instantiation-p
	(binding-node-instantiated-preconds binding-node)))

;;

;; Good-instatiation-p maps over each extended assertion making sure
;; that it is true.  This is similar to checking each assertion in a
;; conjunct.  For this mechanism anything more complicated than a
;; conjuct in the precond of an operator would have to be converted
;; into a set (possible of size 1) of instantiated preconditions in
;; another part of the program.  (I believe that NoLimit works this
;; way.)  The alternative is to have a structure here more complicated
;; than a call to EVERY.

(defun good-instantiation-p (instantiated-precond)
  (declare (list operator-instantiation))
  (every #'true-extended-assertion-p instantiated-precond))

(defun true-extended-assertion-p (ext-assertion)
  (cond ((null ext-assertion) t)
	(t  (case (extended-assertion-parity ext-assertion)
	      (:true
	       (literal-state-p (extended-assertion-literal ext-assertion)))
	      (:false
	       (not (literal-state-p (extended-assertion-literal ext-assertion))))
	      (otherwise
	       (error "~&Invalid extended assertion ~S.~%" ext-assertion))))))
|#

;;; I will replace all these binding lists and the use of sublis for something
;;; that does less consing later.
(defun applicable-op-p (binding-node)
  (declare (type binding-node binding-node))
  ;; Don't bother with disjunction path here.
  (let* ((expr (binding-node-instantiated-preconds binding-node))
	 (instop (binding-node-instantiated-op binding-node))
	 (values (instantiated-op-values instop))
	 (op (instantiated-op-op instop)))
    (or (null expr)
	(check-applicable-r expr values op t
			    (mapcar #'(lambda (varspec val)
					(cons (first varspec) val))
				    (second (rule-precond-exp op)) values)))))

;;; I need the parity to work out where to find the bindings for the
;;; variables involved and for no other reason.
(defun check-applicable-r (expr values op parity bindings)
  (cond ((typep expr 'literal)
	 (literal-state-p expr))
	((eq (car expr) 'user::~)
	 (not (check-applicable-r (second expr) values op (not parity) bindings)))
	((eq (car expr) 'user::and)
	 (every #'(lambda (piece)
		    (check-applicable-r piece values op parity bindings))
		(cdr expr)))
	((eq (car expr) 'user::or)
	 (some #'(lambda (piece)
		   (check-applicable-r piece values op parity bindings))
	       (cdr expr)))
	((eq (car expr) 'user::exists)
	 (if parity
	     (check-applicable-exists expr values op bindings parity)
	     (check-applicable-forall expr values op bindings parity)))
	((eq (car expr) 'user::forall)
	 (if parity
	     (check-applicable-forall expr values op bindings parity)
	     (check-applicable-exists expr values op bindings parity)))
	(t
	 (let ((literal (instantiate-consed-literal (sublis bindings expr))))
	   (literal-state-p literal)))))

(defun check-applicable-exists (expr values op bindings parity)
  (check-applicable-r (third expr) values op parity bindings))
#|
(defun check-applicable-forall (expr values op bindings parity)
  "Cycle through possible values of the quantified variables"
  (do* ((generator (cdr (assoc (second expr)
			       (getf (rule-plist op) :quantifier-generators))))
	(data (if generator (funcall generator nil)))
	(choice (make-list (length data) :initial-element 0)
		(increment-choice choice data))
	(sat (satisfy-quant expr values op bindings choice data parity)
	     (satisfy-quant expr values op bindings choice data parity)))
       ((or (null choice)
	    (case (car expr)
	      (user::exists sat)
	      (user::forall (not sat))))
	(if (null choice)
	    (eq (car expr) 'user::forall)
	    (eq (car expr) 'user::exists)))))
|#

;; adding a hack so that it is much faster in a forall case such as:
;; (forall ((<x> path) (<b> path)) (~ (pred <a> <b>)))
(defun check-applicable-forall (exp values op bindings parity)
  (let ((expr (third exp)))
    (if (or (and parity (eq (car expr) 'user::~))
	    (and (not parity) (not (eq (car expr) 'user::~))))
	(let* ((real-expr (if parity (second expr) expr))
	       (forall-bindings (descend-match real-expr nil bindings))
	       (res (and forall-bindings
			 (notevery #'(lambda (x)
				       (not (runtime-check-type-and-function-forall x exp)))
				   forall-bindings))))
	  (if parity (not res) res))

	(old-check-applicable-forall exp values op bindings parity))))

(defun old-check-applicable-forall (expr values op bindings parity)
  "Cycle through possible values of the quantified variables"
  (do* ((generator (cdr (assoc (second expr)
			       (getf (rule-plist op) :quantifier-generators))))
	(data (if generator (funcall generator nil)))
	(choice (make-list (length data) :initial-element 0)
		(increment-choice choice data))
	(sat (satisfy-quant expr values op bindings choice data parity)
	     (satisfy-quant expr values op bindings choice data parity)))
       ((or (null choice)
	    (case (car expr)
	      (user::exists sat)
	      (user::forall (not sat))))
	(if (null choice)
	    (eq (car expr) 'user::forall)
	    (eq (car expr) 'user::exists)))))


(defun increment-choice (choice data)
  "Increment the last possible one and set later ones to zero."
  (do ((n (1- (length choice)) (1- n)))
      ((or (= n -1)
	   (< (elt choice n) (1- (length (elt data n)))))
       (unless (= n -1)
	 (incf (elt choice n))
	 (do ((m (1+ n) (1+ m)))
	     ((>= m (length choice)))
	   (setf (elt choice m) 0))
	 choice))))

(defun satisfy-quant (expr values op bindings choice data parity)
  "Add in the new bindings and see if the expression is applicable."
  (if choice
  (check-applicable-r (third expr) values op parity
		      (nconc (choice-bindings expr data choice)
			     bindings))))

(defun choice-bindings (expr data choice)
  (mapcar #'(lambda (varspec datum one-choice)
	      (cons (first varspec)
		    (elt datum one-choice)))
	  (second expr) data choice))
  
     
;; Named to avoid conflict with mei's slightly different version.
(defun dans-substitute-bindings (var-args vars vals)
  "Returns a copy of the var-args where every car in the list
structure that is a variable is replaced by its corresponding value
and every car that is a non variable symbol is replaced by its
associated prodigy object.  Thus *current-problem-space* must be set
correctly, as described in the implemenation notes."
  (if (and (not (prodigy-object-p (car vals)))
	   vals)
      (progn
	(format t "~&Fixing up: ~S.~%" vals)
	(setf vals (car vals))))

  (do-substitution var-args vars vals))

(defun do-substitution (var-args vars vals)
  "Substitute and copy routine.  Should have been written using the
labels macro"
  (declare (special *current-problem-space*))
  (flet ((find-correct-val (var)
	   (nth (position var vars) vals)))
    (cond ((null var-args)  ;; Bounce back, end of list
	   nil)
	  ((symbolp var-args) ;; found a symbol do correct replace
	   (if (strong-is-var-p var-args)
	       (find-correct-val var-args)
	       (or (object-name-to-object var-args *current-problem-space*)
		   (error "~&No object of name ~S." var-args))))
	  (t ;; CONStruct copy of list structure.
	   (cons (do-substitution (car var-args) vars vals)
		 (do-substitution (cdr var-args) vars vals))))))
  

;;=================================================================
;; UNINSTANTIATE OPERATOR
;; After an operator has been applied the assertions which were pre-
;; conditions of the operator must be altered so as not to be
;; preconditions of that operator (we are talking instantiated
;; operators here).  To do this we take a binding-node, iterate over
;; the lists in instantiated-preconds and delete the instantiated-op
;; structure from the goal-p or neg-goal-p slots.

#|
(defun delete-instantiated-op-from-literals (inst-op)
  (declare (type instantiated-op inst-op))
  (let ((binding-node (instantiated-op-binding-node-back-pointer inst-op)))
  (map nil #'(lambda (x) (remove-op-from-inst-preconds x inst-op))
	  (binding-node-instantiated-preconds binding-node))))

(defun remove-op-from-inst-preconds (inst-precond inst-op)
  (declare (type instantiated-op inst-op))
  (dolist (extended-assertion inst-precond)
      (case (extended-assertion-parity extended-assertion)
	(:TRUE
	 (delete-goal (extended-assertion-literal extended-assertion) inst-op)
	 )
	(:FALSE
	 (delete-neg-goal (extended-assertion-literal extended-assertion) inst-op)
	))))
|#

(defun delete-instantiated-op-from-literals (inst-op)
  (declare (type instantiated-op inst-op))

  (let ((binding-node (instantiated-op-binding-node-back-pointer inst-op)))
    (remove-op-from-goals
     (binding-node-instantiated-preconds binding-node)
     (binding-node-disjunction-path binding-node) inst-op t
     (mapcar #'(lambda (var val) (cons var val))
	     (rule-vars (instantiated-op-op inst-op))
	     (instantiated-op-values inst-op)))))

(defun remove-op-from-goals (expr disj instop parity bindings)
  (declare (type instantiated-op instop))

  (cond ((typep expr 'literal)
	 (if parity (delete-goal expr instop)
	     (delete-neg-goal expr instop)))
	((eq (car expr) (if parity 'user::or 'user::and))
	 (remove-op-from-goals (elt expr (car disj)) (cdr disj)
			       instop parity bindings))
	((eq (car expr) (if parity 'user::and 'user::or))
	 (mapc #'(lambda (bit disj-bit)
		   (remove-op-from-goals bit disj-bit instop parity
					 bindings))
	       (cdr expr) disj))
	((eq (car expr) 'user::~)
	 (remove-op-from-goals (second expr) disj instop (not parity)
			       bindings))
	((eq (car expr) (if parity 'user::forall 'user::exists))
	 (remove-forall-from-goals expr disj instop parity bindings))
	((member (car expr) '(user::exists user::forall))
	 (remove-op-from-goals (third expr) disj instop parity bindings))
	(t
	 (let ((lit (instantiate-consed-literal (sublis bindings expr))))
	   (if parity (delete-goal lit instop)
	       (delete-neg-goal lit instop))))))
#|
(defun remove-forall-from-goals (expr disj instop parity bindings)
  (do* ((gen (cdr (assoc (second expr)
			 (getf (rule-plist (instantiated-op-op instop))
			       :quantifier-generators))))
	(data (if gen (funcall gen nil)))
	(choice (make-list (length data) :initial-element 0)
		(increment-choice choice data)))
       ((null choice))
    (remove-op-from-goals (third expr) disj instop parity
			  (nconc (choice-bindings expr data choice)
				 bindings))))
|#
(defun remove-forall-from-goals (exp disj instop parity bindings)
  (let ((expr (third exp)))
    (if (or (and parity (eq (car expr) 'user::~))
	    (and (not parity) (not (eq (car expr) 'user::~))))
	(let* ((real-expr (if parity (second expr) expr))
	       (forall-bindings (descend-match real-expr nil bindings)))
	  (dolist (bind forall-bindings)
	    (if (runtime-check-type-and-function-forall bind exp)
		(remove-op-from-goals (third exp) disj instop parity bind))))
	(old-remove-forall-from-goals exp disj instop parity bindings))))

(defun old-remove-forall-from-goals (expr disj instop parity bindings)
  (do* ((gen (cdr (assoc (second expr)
			 (getf (rule-plist (instantiated-op-op instop))
			       :quantifier-generators))))
	(data (if gen (funcall gen nil)))
	(choice (make-list (length data) :initial-element 0)
		(increment-choice choice data)))
       ((null choice))
    (remove-op-from-goals (third expr) disj instop parity
			  (nconc (choice-bindings expr data choice)
				 bindings))))



;;;=============================================================
;;; BUILD INSTANTIATED PRECONDS
;;; When an instantiated operator is selected its precond is merged
;;; with its bindings and expanded into a set of lists of extended
;;; literals (or assertions).  The extended literal is a literal that
;;; carries with it the information about which sense of the literal
;;; the operator wants (either in the state or not).

;;; BEGIN OLD STUFF
;;; The following code will instantiate the operator by building a list
;;; of lists of extended assertions.  An extended assertion is a list.
;;; The first element is :TRUE or :FALSE, indicating that the assertion
;;; must be in the state or not in the state respectively for the
;;; instantiation to be true.

;;; If the values slot of the instantiated-op structure is nil, then
;;; the operator has no variables, and so the operator "schema" fully
;;; describes all the instantiated operators derived from it.
;;; END OLD STUFF

;;; I'd like to do the following, but I can't quite because you have
;;; to pick a list of goals when you subgoal. Jim. Hmm, but maybe if I
;;; do it this way, I can be opportunistic if another disjunct fires..
;;; Re-writing this to deal with internal disjunction. I think the
;;; list-of-lists thing is a bad idea, because you duplicate lots of
;;; stuff and then you check it maybe lots of times, so I'm going with
;;; a scheme that mirrors the whole structure and then I'll change the
;;; function applicable-op-p to give me a list of literals as a
;;; justification, and maybe indicate which disjunct(s) fired, but
;;; probably not.

(defun build-instantiated-precond (binding abslevel)
  (declare (type instantiated-op binding))
  "Build the fully instantiated preconditions for this binding."
  (let* ((op (instantiated-op-op binding))
	 (rule-plist (rule-plist op))
	 (precond-exp (getf rule-plist :annotated-preconds))
	 (declarations (second (rule-precond-exp op)))
	 (values (instantiated-op-values binding))
	 (vars (rule-vars op))
	 (conditional
	  (cdr (assoc (instantiated-op-conditional binding)
		      (getf rule-plist :annotated-conditional-effects)))))
    ;; If there is a conditional, combine it with the preconditions.
    ;; The order they are combined is used when we consider subgoals,
    ;; so be careful if you change it.
    (or 
     (build-instantiated-rec
      (if conditional
	  (list (max (car conditional) (car precond-exp))
		'user::and conditional precond-exp)
	  precond-exp)
      values vars (list declarations) t abslevel)
     ;; This is wasteful, but otherwise I think there's more than
     ;; one place needs changed.
     (list 'user::and))))


;;; This function is modified to build a smaller precondition
;;; expression based on the abstraction level.
#|
(defun build-instantiated-rec (exp values vars)
  (declare (list exp values vars))
  
  (case (car exp)
    ((user::and user::or)
     (cons (car exp)
	       (mapcar #'(lambda (bit)
			   (build-instantiated-rec bit values vars))
		       (cdr exp))))
    (user::~
     (list 'user::~
	   (build-instantiated-rec (second exp) values vars)))
    ((user::exists user::forall)
     (list (first exp) (second exp)	; important not to alter second.
	   (build-instantiated-rec (third exp) values vars)))
    (t (or (try-to-instantiate exp values vars) exp))))
|#

;;; see annotate-preconds-rec to see how the representation of the
;;; preconditions with abstraction levels looks.
(defun build-instantiated-rec (exp values vars decs parity al)
  (declare (list exp values vars decs))
  (cond
    ((eq (second exp) (if parity 'user::and 'user::or))
     ;; For an and, we drop every clause that should not be at this
     ;; abstraction level. If there are no clauses left return nil.
     (let ((args (mapcan #'(lambda (bit)
			     (let ((piece
				    (build-instantiated-rec
				     bit values vars decs parity al)))
			       (if piece (list piece))))
			 (cddr exp))))
       (if args (cons (second exp) args))))
    ((eq (second exp) (if parity 'user::or 'user::and))
     ;; For an or, if any clause is below the current abstraction
     ;; level we drop the whole thing. This is pre-computed, but can
     ;; be wrong.
     (let ((args (catch 'drop-the-whole-thing
		   (mapcan #'(lambda (bit)
			       (let ((piece
				      (build-instantiated-rec
				       bit values vars decs parity al)))
				 (if piece (list piece)
				     (throw 'drop-the-whole-thing nil))))
			   (cddr exp)))))
       (if args (cons (second exp) args))))
    ((eq (second exp) 'user::~)
     (let ((negation (build-instantiated-rec (third exp) values vars
					     decs (not parity) al)))
       (if negation (list 'user::~ negation))))
    ((member (second exp) '(user::exists user::forall))
     ;; If the thing inside the existential disappears, drop it. This
     ;; means that currently I keep declarations for objects that may
     ;; have disappeared - this may cause a bug, I'm going to run it
     ;; to see.
     (let ((bit (build-instantiated-rec (fourth exp) values vars
					(cons (third exp) decs) parity al)))
       (if bit (list (second exp) (third exp) bit))))
    (t
     ;; Only attempt to instantiate a literal if its abstraction level
     ;; is at least as great as that of the current problem space.
     (if;; (>= (car exp) al)
      (>= (car (annotate-preconds-rec (cdr exp) (true-decs decs vars values)
				      parity)) al)
      (or (try-to-instantiate (cdr exp) values vars) (cdr exp))))))

(defun true-decs (decs vars values)
  "More accurate variable types based on the instantiation."
  (mapcar
   #'(lambda (dec)
       (mapcar
	#'(lambda (obj-type)
	    ;; We may or may not have values for objects, depending 
	    ;; on whether this one was quantified or not.
	    (let ((varpos (position (car obj-type) vars)))
	      (if (and varpos (prodigy-object-p (elt values varpos)))
		  (list (car obj-type)
			(type-name
			 (prodigy-object-type (elt values varpos))))
		  dec)))
	dec))
   decs))

;;; This function returns an instantiated literal if every variable
;;; mentioned in the variablised literal given as input actually has a
;;; value. Otherwise it returns nil.
(defun try-to-instantiate (pred values vars)
  (declare (special *current-problem-space*))
  (catch 'one-got-away
    (instantiate-literal
     (car pred)
     (mapcar #'(lambda (symbol)
		 (cond ((strong-is-var-p symbol)
			(let ((index (position symbol vars)))
			  (if (and index
				   (not (listp (elt values index))))
			      (elt values index)
			      (throw 'one-got-away nil))))
		       (t (make-real-object symbol *current-problem-space*))))
	     (cdr pred)))))

