;; **************************************************************************
;; macro operators based on the correctly operators of the domain.
;; observations:
;; 1. the number of variables and effects in macro operators don't
;;    really grow fast
;; 2. Only the effects from the last operator of the macro-operator
;;    should be subgoaled on;
;; or 2'.  Do not subgoal on the preconditions of the operator. 

(operator COMPOSITE ; goto-dr, open-dr, go-thru-dr, goto-obj, push-to-dr
  (params ...)
  (preconds
    ((<dx> DOOR)
     (<rx> ROOM)
     (<ry> ROOM)
     (<b> BOX)
    )
    (and (dr-to-rm <dx> <rx>)
         (inroom robot <rx>)
         (unlocked <door>)
         (dr-closed <door>)
	 (arm-empty)
	 (connects <dx> <rx> <ry>)
	 (inroom <b> <ry>)
	 (pushable <b>)
    ))
  (effects 
    ((<other> (or OBJECT DOOR)))
  ((<other>  (and (or OBJECT DOOR) (diff <other> <b>)))
   (<other2> (or OBJECT DOOR))
   (<other3> (and (or OBJECT DOOR) (diff <other3> robot))))
  ((del (next-to robot <other>))
   (del (next-to <b> <other2>))
   (del (next-to <other3> <b>))
   (add (next-to <b> <dx>))
   (add (next-to robot <dx>)))))
   (del (dr-closed <door>))
   (del (inroom robot <rx>))
   (add (inroom robot <ry>))
   (add (dr-open <door>))
   (add (next-to robot <b>))))

(operator COMPOSITE ; goto-dr, open-dr, go-thru-dr, goto-obj,
	            ; push-to-dr, push-thru-dr, 
  (params ...)
  (preconds
    ((<dx> DOOR)
     (<rx> ROOM)
     (<ry> ROOM)
     (<b> BOX)
    )
    (and (dr-to-rm <dx> <rx>)
         (inroom robot <rx>)
         (unlocked <door>)
         (dr-closed <door>)
	 (arm-empty)
	 (connects <dx> <rx> <ry>)
	 (inroom <b> <ry>)
	 (pushable <b>)
    ))
  (effects 
    ((<other> (or OBJECT DOOR)))
  ((<other>  (and (or OBJECT DOOR) (diff <other> <b>)))
   (<other2> (or OBJECT DOOR))
   (<other3> (and (or OBJECT DOOR) (diff <other3> robot))))
  ((del (next-to robot <other>))
   (del (next-to <b> <other2>))
   (del (next-to <other3> <b>))
   (del (dr-closed <door>))
   (add (next-to <b> <dx>))
   (add (next-to robot <dx>)))))
   (add (inroom <b> <rx>))
   (add (dr-open <door>))
   (add (next-to robot <b>))))

