#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#



; ======================================================================
; File:  toplevel.lisp		Version: 1-20 	     Created:  5/11/88
; Locked by: nobody                                 Modified:  7/7/88
;
; Purpose:   top-level user interface definitions for prodigy
; ======================================================================


;(provide 'prodigy-toplevel)
;(require 'prodigy-search-analysis)
;(require 'prodigy-command-interface)
;(in-package 'prodigy-toplevel)
;(export '())
;(import '())


(proclaim '(special *CURRENT-DOMAIN* *CURRENT-PROBLEM* *ACTIVE-FACILITIES* 
		*PREDICATES* *EXPL-NODE* *PROBLEM-GOAL*))


; ======================================================================
;                   Toplevel  Command  Interface  Variables
; ======================================================================


(defvar *TOPLEVEL-PROMPT* "Prodigy:")
(defvar *TOPLEVEL-PRESET*  #'(lambda () (the-environment-command)))
(defvar *TOPLEVEL-STOPCMDS* '(BYE))
(defvar *TOPLEVEL-EXIT*  #'(lambda ()) ); a no-op



; ======================================================================
;               SYNONYNM  TABLE  FOR  TOPLEVEL  FACILITY 
; ======================================================================

(defvar *TOPLEVEL-SYNONYMS* 
 (make-synonym-table
  '((ADVISE (AD ADV ADVI ADVIS ADVIC ADVICE TAKE-ADVICE))
    (ANALYZE (AN ANA ANAL ANALY ANALYZ))
    (APROPOS (AP APR APRO APROP APROPO))
    (BREADTH-FIRST (B BR BRE))
    (DISCARD (DI DIS DISCARD))
    (DFID (DF DFI DEPTH-FIRST-ITERATIVE-DEPENING))
    (DOMAIN (D DO DO DOM DOMA DOMAI DOMAINS LOAD-D LOAD-DOMAIN))
    (DSPF (DSPF DEFINE-STATIC-PREDICATE-FUNCTIONS))
    (ENVIRONMENT (E EN ENV ENVIR ENVIRO ENVIRON ENVIRONM ENVIRONME ENVIRONMEN))
    (EXPAND-ALL (EXP EXPA EXPAN EXPAND EXPAND-A EXPAND-AL EXP-ALL))
    (FORGET-RULES (FORGET F-RULES))
    (GOAL (G GOA))
    (HELP (? H HE HEL))
    (INFERENCE (INF INFE INFER INFERE INFEREN INFERENC INFERENCES))
    (INITIAL (INI INIT INITI INITIA))
    (CUTOFF (NODE-CUTOFF CUTOFF))
    (NOT-UNIQUE-COMMAND-WORD (A I IN O OP P PR Q QU QUI S SC SO SOL T))
    (OPERATOR (OPE OPER OPERA OPERAT OPERATO OPERATORS))
    (OPSEQUENCE (OPS OPSE OPSE OPSEQ OPSEQU OPSEQUE OPSEQUEN OPSEQUENC))
    (OPTRACE (OPT OPTR OPTRA OPTRAC))
    (PATH (PA PAT))
    (PICTURE (PI PIC PICT PICTU PICTUR))
    (PROBLEM (PRO PROB PROBS PROBL PROBLE PROBLEMS
		 LOAD-PROBLEM LOAD-PROB LOAD-P ))
    (PROBSETS (PROBSETS PROBSET PSET PSETS PS SET SETS))
    (PRTRACE (PRT PRTR PRINT-TRACE PRINT-T))
    (QUIET (QUIET-L QUIET-LOAD))
    (QUIT (QUIT EX EXI EXIT))
    (READ-RULES (R-R R-RULES READ-R READ-RU READ-RUL READ-RULE))
    (SCRULE (SCR SCRU SCRUL SCRULES))
    (SCTRACE (SCT SCTR SCTRA SCTRAC))
    (SHOW-RULES (SHOW S-RULES))
    (SOLUTION (SOLU SOLUT SOLUTI SOLUTIO))
    (SOLVE (SOLV RUN))
    (STATIC (ST STA STAT STATI))
    (TOGGLE-EBL (EBL T-EBL TOG-EBL))
    (EBL-TEXT (T-P T-PR T-PRI T-PRIN TOG-P TOG-PRINT EBL-T EBL-TE))
    (TEXT (TE TEX))
    (TIME (TI TIM TIME-B TIME-BOUND))
    (TREE (TR TRE))
    (WRITE-RULES (W-R W-RULES WRITE-R WRITE-RU WRITE-RUL WRITE-RULE))
)))

; ======================================================================
;                  HELP  TABLE  FOR  TOPLEVEL  FACILITY 
; ======================================================================


(defvar *TOPLEVEL-HELP* 
 (make-help-table
  '((HELP SUBMENUS (domain_selection problem_solving facilities
		    miscellaneous ebl-module))

;;	
;;  submenus display text and a list of commands when selected
;;


    (ALL COMMANDS (advise analyze apropos cutoff breadth-first depth-first 
		   dfid discard domain dspf 
		   environment
		   expand-all forget-rules help goal inference
		   initial operator opsequence optrace path picture
		   problem probsets prtrace quiet quit read-rules scrule sctrace 
		   show-rules
		   solution solve static time toggle-ebl ebl-text
                   text tree 
		   write-rules))
    (FACILITIES COMMANDS (analyze))
    (PROBLEM_SOLVING COMMANDS (breadth-first dfid picture text tree 
			       optrace sctrace solve
			       advise dspf cutoff prtrace time discard))
    (DOMAIN_SELECTION COMMANDS (environment path domain problem probsets quiet goal
				initial static inference  operator scrule))
    (MISCELLANEOUS COMMANDS (apropos help opsequence solution quit))
    (EBL-MODULE COMMANDS (expand-all forget-rules read-rules show-rules
			  toggle-ebl ebl-text write-rules))




    (HELP MENU-TEXT 
"  Help is used to list the four top level command categories.  If a 
  command is specified, it will give you information about that command.

  The top level categories are:")


   (ALL SUBMENU-TEXT " The prodigy commands are...")
    (FACILITIES SUBMENU-TEXT 
"  Facility commands are used to connect the user to other command 
  interfaces which deal with a particular aspect of the Prodigy planning
  architecture.")
   (PROBLEM_SOLVING SUBMENU-TEXT 
"  Problem solving commands are used to toggle graphic and textual output,
  and to record or ignore failure information during the problem solving 
  process.")
    (MISCELLANEOUS SUBMENU-TEXT 
"  Help and print commands.")
    (EBL-MODULE SUBMENU-TEXT
"  These commands manage the EBL system.  Additional information is available 
  on each command by typing 'help <command>'.")
    (DOMAIN_SELECTION SUBMENU-TEXT 
"  Domain selection commands are used to select a domain and problem, and 
  to view the domain specifications.")


;;
;; listing of individual command summaries. (terse-text).
;;


    (ADVISE TERSE-TEXT "- runs problem solver and allows user to select alts")
    (ANALYZE TERSE-TEXT "[node] - enters the search analysis facility at node") 
    (APROPOS TERSE-TEXT "[keyword] - shows associations for a given keyword")
    (BREADTH-FIRST TERSE-TEXT " - does a depth first search of the search tree.")
    (DFID TERSE-TEXT "- searches tree using depth-first iterative deepening.")
    (DISCARD TERSE-TEXT "- toggles discarding of failed search paths during problem solving")
    (TOGGLE-EBL  TERSE-TEXT "- toggles learning in EBL module on and off")    (DOMAIN TERSE-TEXT "[\"name\"]- changes the current domain")
    (DOMAIN_SELECTION TERSE-TEXT "- select a domain and view the domain rules")
    (DSPF TERSE-TEXT "- toggles defining static predicates as functions")
    (EBL-MODULE TERSE-TEXT "- manage EBL system")
    (ENVIRONMENT TERSE-TEXT 
		 "- display the current domain and active facilities")
    (EXPAND-ALL TERSE-TEXT
		"- toggles the expansion of nodes.  Normally disabled.")
    (FORGET-RULES TERSE-TEXT
	 "- forget learned rules.  See EBL manual for more information.")
    (FACILITIES TERSE-TEXT
		"- select modes of domain inspection and augmentation")
    (GOAL TERSE-TEXT "- shows the goal for the current problem")
    (HELP TERSE-TEXT "[exp] - provides general help, or help on [exp]")
    (INITIAL TERSE-TEXT " - prints non-static predicates from initial state")
    (INFERENCE TERSE-TEXT "[name] - prints the specified inference rule")
    (MISCELLANEOUS TERSE-TEXT "- perform a variety of functions")
    (CUTOFF TERSE-TEXT "[node] - set maximum number of nodes, default is n2500")
    (OPERATOR TERSE-TEXT "[name] - prints the specified operator")
    (OPSEQUENCE TERSE-TEXT "- prints the operators in the problem solution")
    (OPTRACE TERSE-TEXT "- toggles operator failure tracing")
    (PATH TERSE-TEXT "[\"name\"] - sets the directory where domains are found")
    (PICTURE  TERSE-TEXT "- toggles the domain graphics") 
    (PROBLEM TERSE-TEXT "[\"name\"] - changes the current problem")
    (PROBSETS TERSE-TEXT "[\"name\"] - changes the current problem set")
    (PROBLEM_SOLVING TERSE-TEXT  "- alter the output of a problem solving run")
    (PRTRACE TERSE-TEXT "[value] - set the node at which trace will begin, default is off")
    (QUIT TERSE-TEXT "- exits prodigy")
    (QUIET TERSE-TEXT "- toggles the tracing of a domain being loaded")
    (READ-RULES TERSE-TEXT "- reads in set of saved rules from a file")
    (SCRULE TERSE-TEXT "[name] - prints the specified control rule")
    (SCTRACE TERSE-TEXT "- toggles search control failure tracing")
    (SHOW-RULES TERSE-TEXT "- display active rules in the EBl system")
    (SOLUTION TERSE-TEXT "- prints the solution including inferences")
    (SOLVE TERSE-TEXT "- runs the current problem")
    (STATIC TERSE-TEXT "- shows static predicates defined as functions")

    (EBL-TEXT TERSE-TEXT "- toggles printing of EBL output")
    (TEXT TERSE-TEXT "- toggles the problem solving trace text")
    (TIME TERSE-TEXT "[number] - set maximum CPU seconds allowed for a problem, default 300")
;    (TREE TERSE-TEXT "- toggles the search tree graphics")
    (TREE TERSE-TEXT "- the tree command may now only be used from analyze.")
    (WRITE-RULES TERSE-TEXT "- saves a set of rules to a file")
)))




; ======================================================================
;                  COMMAND  TABLE  FOR  TOPLEVEL  FACILITY 
; ======================================================================

(defvar *TOPLEVEL-COMMANDS*
 (make-command-table
  '((ADVISE (the-advise-command))
    (ANALYZE (the-analyze-command (car args) "the top level interface"))
    (APROPOS (the-apropos-command (car args) *TOPLEVEL-HELP*))
    (BREADTH-FIRST (the-breadth-first-command))
    (DFID (the-dfid-command))
    (DSPF (toggle-dspf))
    (ENVIRONMENT (the-environment-command))
    (EXPAND-ALL (toggle-expand))
    (FORGET-RULES (the-forget-rules-command args))
    (DISCARD (the-discard-command))
    (DOMAIN (the-domain-command (car args)))
    (GOAL (the-goal-command))
    (HELP (the-help-command (car args) *TOPLEVEL-HELP*))
    (INFERENCE (the-inference-command (car args)))
    (INITIAL (the-initial-command))
    (CUTOFF (the-node-cutoff-command (car args)))
    (NOT-UNIQUE-COMMAND-WORD  (the-not-unique-command))
    (OPERATOR (the-operator-command (car args)))
    (OPSEQUENCE (the-opseq-command))
    (OPTRACE (the-optrace-command))
    (PATH (the-path-command (car args)))
    (PICTURE (the-picture-command))
    (PROBLEM (the-problem-command (car args)))
    (PROBSETS (the-problem-set-command (car args)))
    (PRTRACE (the-print-tracing-command (car args)))
    (QUIET (the-quiet-load-command))
    (QUIT (the-quit-command))
    (READ-RULES (the-read-rules-command (car args)))
    (SCRULE (the-scrule-command (car args)))
    (SCTRACE (the-sctrace-command))
    (SHOW-RULES (the-show-rules-command))
    (SOLUTION (the-solution-command))
    (SOLVE (the-solve-command))
    (STATIC (the-static-command))
    (TOGGLE-EBL (toggle-ebl))
    (EBL-TEXT (toggle-ebl-text))
    (TEXT (the-text-command))
    (TIME (the-time-bound-command (car args)))
    (TREE (the-tree-command-message))
    (WRITE-RULES (the-write-rules-command (car args)))

)))



; ======================================================================
;                 Toplevel  Command  Interpreter  Routine
; ======================================================================


(defun prodigy ()
  (prodigy-banner)
  (command-interpreter 
   *TOPLEVEL-PRESET* *TOPLEVEL-PROMPT* *TOPLEVEL-SYNONYMS* *TOPLEVEL-COMMANDS* 
   *TOPLEVEL-HELP* *TOPLEVEL-STOPCMDS* *TOPLEVEL-EXIT*))

  
(defun prodigy-banner ()
  (format t "~2%PRODIGY ~A   (The Prodigy Project, May 15, 1989)" (version))
  (format t "~%Mail questions and remarks to prodigy@CS.CMU.EDU")
  (format t "~3%Welcome to   P R O D I G Y ...")
  (terpri))


; ======================================================================
;                  END  OF FILE    toplevel.lisp 
; ======================================================================

