#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#


;; ========================================================================
;;                 Generic Prodigy  Graphics  Library
;; ========================================================================


(in-package "PG" :use '("LISP" "USER"))

(export '(pg-refresh-window    pg-create-window       pg-kill-window
	  pg-clear-window      pg-show-window         pg-hide-window
	  pg-window-height     pg-window-width        pg-draw-line 
	  pg-write-text        pg-text-width          pg-text-height
	  pg-with-window       pg-frame-rect          pg-invert-rect
	  pg-erase-rect        *pg-window*))


(proclaim '(special *pg-window*))

; ========================================================================
;                      Prodigy  Graphics  Functions...
; ========================================================================



(defun pg-create-window (x y w h)
  (declare (ignore x y w h))
  "this function draws a window on the 
   screen and returns a window structure")


(defun pg-kill-window (w)
  (declare (ignore w))
  "this function makes a window structure garbage collectable,
   by resetting any parameters, and setting values to nil")
   

(defun pg-refresh-window (w)
  (declare (ignore w))
  "this function redisplays a window, or flushes the output buffer")


(defun pg-clear-window (w)
  (declare (ignore w))
  "this function clears an entire window")


(defun pg-show-window (w)
  (declare (ignore w))
  "this function will make a window visible")


(defun pg-hide-window (w)
  (declare (ignore w))
  "makes a window invisible")


(defun pg-draw-line (w x1 y1 x2 y2)
  (declare (ignore w x1 y1 x2 y2))
  "draws a line from coordinate (x1,y1) to (x2,y2)")


(defun pg-write-text (w x y s)
  (declare (ignore w x y s))
  "write text in the specified window {w}. the 
   coordinate (x,y) specifies the bottom left 
   corner of the text to draw.")


(defun pg-text-width (w s)
  (declare (ignore w s))
  "return the width of a string in terms of the number of pixels")



(defun pg-text-height (w s)
  (declare (ignore w s))
  "return the height of a string in terms of pixels")


(defun pg-window-height (w)
  (declare (ignore w))
  "return the height of the window in pixels")


(defun pg-window-width (w)
  (declare (ignore w))
  "return the width of the window in pixels")



(defmacro pg-with-window (w &rest forms)
  `(progn (setq *pg-window* ,w)
	  ,@forms 
	  (pg-refresh-window *pg-window*)))
           
(defun pg-erase-rect (lft top rgt bot)
  (declare (ignore lft top rgt bot))
  "clear a rectangular area within the
   current window (i.e., *pg-window*)")

(defun pg-frame-rect (lft top rgt bot)
  (declare (ignore lft top rgt bot))
  "draw a rectangle within *pg-window*")


(defun pg-invert-rect (lft top rgt bot)
  (declare (ignore lft top rgt bot))
  "turn all on pixels to off, and all off pixels to on, within the 
   specified rectangular area of the current window (*pg-window*)")


;; ========================================================================


(pushnew :pg-system lisp::*features*)
(provide 'pg-system)

