#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#




(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types"))



(defun print-list (heading list)
    (terpri)
    (format t "~A~A" heading (car list))
    (print-rest-list (length (princ-to-string heading))
	             (cdr list)))


(defun print-rest-list (indent list)
    (cond ((null list) nil)
	  (t (terpri)
             (format t "~A~A" (make-string indent :initial-element #\space)
			      (car list))
	     (print-rest-list indent (cdr list)))))


; returns all the variables anywhere in an expression

(defun find-all-vars (l)
  (r-find-all-vars l nil))

(defun r-find-all-vars (l vars)
    (cond ((atom l) 
	   (cond ((and (is-variable l)
		       (not (member l vars)))
		  (cons l vars))
		 (t vars)))
	  ((g-loop (while l)
		   (do (setq vars (r-find-all-vars (pop l) vars)))
		   (result vars)))))


; NOTE: I have deleted remove-duplicates because it is already defined in
; common lisp.  However, you must call it as:
;                (remove-duplicates lis :test #'equal)
; in order to get exactly the same effect!

(defun subst-bindings (l bindings)
    (cond ((atom l)
	   (cond ((and (is-variable l)(assoc l bindings))
		  (cond ((and (is-variable (cadr (assoc l bindings)))
			      (assoc (cadr (assoc l bindings)) bindings))
			 (cadr (assoc (cadr (assoc l bindings)) bindings)))
			(t (cadr (assoc l bindings)))))
		 (t l)))
	  ((prog (changes old-l subresult)
		 (setq old-l l)
	  	 loop-flag
		 (setq subresult (subst-bindings (car old-l) bindings))
		 (or (eq subresult (car old-l))
		     (setq changes (cons subresult (cons (car old-l) 
							 changes))))
		 (setq old-l (cdr old-l))
		 (and (null old-l)
		      (cond (changes 
			      (return (subst-changes
					(setq changes (nreverse changes)) l)))
			    ((return l))))
		 (go loop-flag))))) 

 
;  changes is = (old1 new1 old2 new2) where old2 occurs later in the
;  list than new1

(defun subst-changes (changes l)
    (cond ((null changes) l)
	  ((eq (car changes) (car l))
	   (cons (cadr changes) (subst-changes (cddr changes) (cdr l))))
	  ((cons (car l) (subst-changes changes (cdr l))))))


(defun del-eq (e l)
    (cond ((null l) (error "no ele found by del-eq"))
	  ((eq e (car l)) (cdr l))
	  (t (cons (car l) (del-eq e (cdr l))))))


(defun has-vars (lit)
    (g-loop (init args (cond ((negated-p lit) (cdadr lit))
			      ((cdr lit))))
	     (while args)
	     (do (and (is-variable (car args))
		      (return t)))
	     (next args (cdr args))))

(defun has-unbound-vars (lit bindings)
    (g-loop (init args (cond ((negated-p lit) (cdadr lit))
			      ((cdr lit))))
            (while args)
	    (do (cond ((not (is-variable (car args))) nil)
	              ((and (assoc (car args) bindings)
		            (let ((val (cadr (assoc (car args) bindings))))
			       (cond ((not (is-variable val)) t)
				     ((assoc val bindings) 
				      (not (is-variable
					   (cadr (assoc val bindings))))))))
                       nil)
		      (t (return t))))
	    (next args (cdr args))))

(defun get-unbound-vars (vars bindings)
    (mapcan #'(lambda (var) (cond ((not (assoc var bindings)) (list var))
				   (t nil)))
	    vars))

;
; Compares two lisp objects and returns a non-null value if the first 
; is less than the second.  Less-than is defined between different types
; as follows: null < symbol < number < string < list.  A symbol is less
; than another symbol if the sybol-name of the first is less than the symbol
; name of the second.  Numbers use <, and strings use string<.  If the two
; objects are equal, it will return nil.
;
(defun alphalessp-f (f1 f2)
  (cond ((atom f1)                 ; tests for null, symbols, numbers or strings
	 (cond ((atom f2)
		(lessp-f f1 f2))
	       (t)))               ; an atom is less than a list
	((atom f2) nil)            ; f1 is a list
	((equal (car f1)(car f2))  ; need equal for strings here
	 (alphalessp-f (cdr f1)(cdr f2)))
	(t (alphalessp-f (car f1)(car f2)))))
;
; This functions is used by alphalessp-f to compare two objects.  Both 
; objects must be atoms.
;
(defun lessp-f (f1 f2)
  (cond ((null f1)
	 (cond ((null f2) nil)     ;f1 = f2
	       (t)))               ;f1 = nil, f2 <> nil
	((null f2) nil)            ;f1 <> nil, f2 = nil
	((symbolp f1)
	 (cond ((symbolp f2)
		(string< (symbol-name f1)
			 (symbol-name f2)))
	       (t)))               ; f2 is not a symbol
	((symbolp f2) nil)         ; f1 is not a symbol
	((numberp f1)
	 (cond ((numberp f2)
		(< f1 f2))
	       (t)))               ; f2 is not a number
	((numberp f2) nil)         ; f1 is not a number
	((stringp f1)
	 (cond ((stringp f2)
		(string< f1 f2))
	       (t)))               ; f2 is not a string
	((stringp f2) nil)         ; f1 is not a string
	))

    
(defun intersect (l1 l2)
    (do ((ret-val nil) (l1 l1 (cdr l1)))
	 ((null l1) ret-val)
	 (and (member (car l1) l2 :test #'equal)
	      (setq ret-val (cons (car l1) ret-val)))))

(defun intersectq (l1 l2)
    (do ((ret-val nil) (l1 l1 (cdr l1)))
	((null l1) ret-val)
	(and (member (car l1) l2)
	     (setq ret-val (cons (car l1) ret-val)))))

(defun intersectq-p (l1 l2)
    (g-loop (while l1)
	    (do (and (member (car l1) l2)
		     (return t)))
  	    (next l1 (cdr l1))))

(defun last-n (n l)
    (cond ((> n (length l)) l)
	  ((< n 1) nil)
	  (t  (nthcdr (- (length l) n) l))))

;  first n elements

(defun header (n l)
    (cond ((> n (length l)) l)
	  ((< n 0) nil)
	  (t (ldiff l (nthcdr n l)))))

(defun r-memq (e l)
    (cond ((atom l) (eq e l))
	  ((eq e l) t)
	  ((g-loop (while l)
		   (do (and (r-memq e (car l))
			    (return t)))
		   (next l (cdr l))))))


(defun make-n-new-vars (n)
    (cond ((eq n 0) nil)
	  (t (cons (intern (concatenate 'string "<" 
			       (princ-to-string (gensym "v"))
			       ">"))
		   (make-n-new-vars (1- n))))))

(defun make-n-new-vars (n)
  (declare (special *VAR-COUNTER*)
	   (fixnum *VAR-COUNTER*))
  (cond ((not (plusp n)) nil)
	(t (cons (intern (format nil "<V~D>" (incf *VAR-COUNTER*)))
		 (make-n-new-vars (1- n))))))

(defun make-binding-list (vars instans)
    (or (mapcan #'(lambda (var instan) (cond ((not (is-variable instan))
					      (list (list var instan)))
					     (t nil)))
		vars instans)
	(list (list nil nil))))

(defun subpair (old new lis)
    (cond ((or (null old) (null lis)) lis)
	  (t (subpair (cdr old) (cdr new) (subst (car new) (car old) lis)))))
	 
(defun del-equal (e l)
    (cond ((null l) (error "no ele found by del-equal"))
	  ((equal e (car l)) (cdr l))
	  (t (cons (car l) (del-equal e (cdr l))))))


(defun del-member-list (es l)
    (cond ((null es) l)
	  ((null l)(error "some ele not found by del-member-list"))
	  ((member (car l) es :test #'equal) 
	   (del-member-list (del-equal (car l) es) (cdr l)))
	  (t (cons (car l) (del-member-list es (cdr l))))))

(defun if-del-member-list (es l)
    (cond ((null es) l)
	  ((null l) nil)
	  ((member (car l) es :test #'equal) 
	   (if-del-member-list (del-equal (car l) es) (cdr l)))
	  (t (cons (car l) (if-del-member-list es (cdr l))))))

(defun if-del-memq-list (es l)
    (cond ((null es) l)
	  ((null l) nil)
	  ((member (car l) es :test #'eq) 
	   (if-del-memq-list (del-eq (car l) es) (cdr l)))
	  (t (cons (car l) (if-del-memq-list es (cdr l))))))

(defun del-memq-list (es l)
    (cond ((null es) l)
	  ((null l)(error "some ele not found by del-memq-list"))
	  ((member (car l) es) 
	   (del-member-list (del-eq (car l) es) (cdr l)))
	  (t (cons (car l) (del-memq-list es (cdr l))))))
