#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#


(defmacro g-map (&rest body)
   (let ((vars (g-map-vars body))
         (args (g-map-args body))
	 (test (g-map-test body))
	 (type (g-map-type body))
	 (exp (g-map-exp body)))
       (make-mapfn vars args test type exp (g-map-function test type))))

(defun g-map-vars (body)
   (mapcan #'(lambda (l)  
                (if (is-var-form l) (list (car l))))
           body))

(defun g-map-args (body)
   (mapcan #'(lambda (l)
                (if (is-var-form l) (list (caddr l))))
	   body))

(defun is-var-form (l)
   (and (eq (length l) 3) (eq (cadr l) 'in)))

(defun g-map-test (body)
   (let ((exp (keyword-exp '(when) body)))
      (if exp (cadr exp))))

(defun g-map-type (body)
   (let ((exp (keyword-exp '(save do splice filter) body)))
      (if exp (car exp))))

(defun g-map-exp (body)
   (let ((exp (keyword-exp '(save do splice filter) body)))
      (if exp (cadr exp))))

(defun keyword-exp (keywords body)
   (do ((exps body (cdr exps)))
       ((or (null exps) (member (caar exps) keywords))
        (car exps))))

(defun g-map-function (test type)
   (cond ((or (eq type 'splice) (eq type 'filter)) 'mapcan)
         ((null test) 'mapcar)
	 (t 'mapcan)))
         
(defun make-mapfn (vars args test type exp mapfn)
   (cons mapfn (cons (make-lambda-fn vars test type exp) args)))

(defun make-lambda-fn (vars test type exp)
  `#',(list 'lambda vars (make-test test (make-body test type exp))))

(defun make-body (test type exp)
   (cond ((eq type 'filter)
          (list 'let (list (list 'x exp)) '(if x (list x))))
         ((or (not (eq type 'save)) (null test))
	   exp)
	 (t (list 'list exp))))

(defun make-test (test body)
   (cond ((null test) body)
         ((null body) test)
	 (t (list 'if test body))))

