#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#



(proclaim
    '(special *STATE-NUM* *SUB-STATE-NUM* *CLOSED-PREDS* *FUNCTION-PREDS* 
	      *STATIC-PREDS* *PREDICATES*))


; --------- TYPE CHECKING FUNCTIONS ---------

; returns t if OP is an operator

(defmacro operator-p (op)
   (list 'get op '(quote operator)))

;  returns t if atm is a symbol and its first character is '<'

(defmacro is-variable (atm)
   `(and (symbolp ,atm)
	 (eql '#\< (char (symbol-name ,atm) 0))))

(defmacro is-literal (exp)
   `(and ,exp (or (not (member (car ,exp) '(and or forall exists ~)))
                  (and (eq (car ,exp) '~)
 		       (not (member (caadr ,exp) '(and or forall exists ~)))))))


; ---------- NODE ACCESS FUNCTIONS -------------

; A new node can be created with the call:
;
;    (setq node (make-node :parent 'parent :children 'children 
;                  :recur-parent 'recur-parent ... etc.))

(defstruct (node (:print-function (lambda (node stream level)
				     (declare (ignore level))
                                     (format stream "#<~S>" (node-name node)))))

  name parent 
  (children nil) 
  state 
  (depth 0 :type integer)
  current-goal current-op candidate-goals
  candidate-ops candidate-bindings last-goal last-op goal-stack
  alternatives reset-alt generating-alt applied-node left-clone
  right-clones failure-reason expanded time)


(defun node-eql (n1 n2)
  (and n1 n2 ; nodes not nil
       (eql (node-name n1) (node-name n2))))




;; ------ Node property macros ------

;;
;;  These macros assume that the argument is a node structure.
;; 

(defmacro node-recur-parent (node)
 `(get (node-name ,node) 'recur-parent))

(defmacro node-recur-children (node)
 `(get (node-name ,node) 'recur-children))

(defmacro node-succeeded (node)
 `(get (node-name ,node) 'succeeded))

(defmacro node-history-for-ebl (node)
 `(get (node-name ,node) 'history-for-ebl))

(defmacro node-match-count (node)
 `(get (node-name ,node) 'match-count))

(defmacro node-scr-rr-history (node)
 `(get (node-name ,node) 'scr-rr-history))

(defmacro node-scr-ug-history (node)
 `(get (node-name ,node) 'scr-ug-history))

(defmacro node-scr-go-history (node)
 `(get (node-name ,node) 'scr-go-history))

(defmacro node-scr-pr-history (node)
 `(get (node-name ,node) 'scr-pr-history))

(defmacro node-select-node-hst (node)
 `(get (node-name ,node) 'select-node-hst))

(defmacro node-select-goal-hst (node)
 `(get (node-name ,node) 'select-goal-hst))

(defmacro node-select-op-hst (node)
 `(get (node-name ,node) 'select-op-hst))

(defmacro node-select-bindings-hst (node)
 `(get (node-name ,node) 'select-bindings-hst))

(defmacro node-reject-node-hst (node)
 `(get (node-name ,node) 'reject-node-hst))

(defmacro node-reject-goal-hst (node)
 `(get (node-name ,node) 'reject-goal-hst))

(defmacro node-reject-op-hst (node)
 `(get (node-name ,node) 'reject-op-hst))

(defmacro node-reject-bindings-hst (node)
 `(get (node-name ,node) 'reject-bindings-hst))

(defmacro node-node-pref-hst (node)
 `(get (node-name ,node) 'node-pref-hst))

(defmacro node-op-pref-hst (node)
 `(get (node-name ,node) 'op-pref-hst))

(defmacro node-goal-pref-hst (node)
 `(get (node-name ,node) 'goal-pref-hst))

(defmacro node-bindings-pref-hst (node)
 `(get (node-name ,node) 'bindings-pref-hst))

(defmacro node-abstract-parent (node)
  "Used in the abstraction system, but needed for tree graphics."
  `(get (node-name ,node) 'abstract-parent))

(defmacro node-abstract-child (node)
  "Used in the abstraction system, but needed for tree graphics."
  `(get (node-name ,node) 'abstract-child))


; Set if the node expands one of the top-level goals.
(defmacro node-top-level-goals (node)
  "Used in the abstraction system, but needed for meta-fn."
  `(get (node-name ,node) 'top-level-goals))

; ---------- ACCESS FUNCTIONS FOR ALTERNATIVES -------------

; Each node keeps a list of alteratives, that is, a list of
; potential operator instantiations that reduce the goal on
; top of the node's goal stack.

;  An Alternative is a structure with the following fields:
;     	goal, op, unmatched-conds, failed-cond, and vars
;  where goal = the goal that the alt is supposed to satisfy 
;	 op = The name of an operator
;        unmatched-conds = any preconditions that are not satisfied
; 	 failed-cond = the  uninstantiated form of the unmatched-cond
;   			 that became the goal. Used by Steve.
; 	 vars = a list of values corresponding to each of the 
; 		      operator's variables.
;               (used to be called instantiated-vars)
; 	 post-cond = the postcondition of the operator 

; A new alternative can be created with the call:
;  (setq alt1 (make-alternative :goal 'goal1 :op 'op1 :unmatched-conds 
;                 'unmatched-conds1 :failed-cond 'failed-cond :vars 'vars1))

(defstruct (alternative (:conc-name alt-))
           goal op unmatched-conds failed-cond vars post-cond)


; -------------------- STATE ACCESS FUNCTIONS ------------------

; STATE is an structure with the following 6 properties:
;   true-assertions, closed-world, false-assertions, justification-table, 
;   num, name.
;  True-assertions, closed-world, and false-assertions are all lists
;  of predicates. Note that true-assertions includes the closed-world
;  predicates. Also, the name "False-assertions" is a bit misleading -
;  false-assertions contains a list of predicates known to be false
;  in the current state.
; 
;  The justification-table contains the inferences (justificands) that have
;  been made in the state and their corresponding justifications.  
; 
;  The name of the state, such as "S8-254 consists of two parts, the
;  num, 8, and a unique sub-state-num, 254. The state num is incremented
;  each time an operator is applied, and the sub-state-num is incremented
;  each time an operator or inference rule is applied. IE, after an operator,
;  the new state would be S9-255, but after an inference rule, S8-255.


(defstruct (state (:print-function (lambda (state stream level)
				      (declare (ignore level))
                                      (format stream
					"#<~A>" (state-name state)))))
           name num true-assertions false-assertions closed-world 
	   justification-table)


(defun make-new-state-nm ()    
    (setq *STATE-NUM* (1+ *STATE-NUM*))
    (setq *SUB-STATE-NUM* (1+ *SUB-STATE-NUM*))
    (create-state *STATE-NUM* *SUB-STATE-NUM*))

(defun create-state (state-no sub-state-no)
    (let ((name (intern (concatenate 'string "S" (princ-to-string state-no) 
                                 "-" (princ-to-string sub-state-no)))))
         (set name (make-state :name name :num state-no))))

	

(defun make-sub-state (old-state)
    (setq *SUB-STATE-NUM* (1+ *SUB-STATE-NUM*))
    (let ((state (create-state (state-num old-state) *SUB-STATE-NUM*)))
	(setf (state-justification-table state)
	      (state-justification-table old-state))
	(setf (state-false-assertions state) 
	      (state-false-assertions old-state))
	(setf (state-true-assertions state) (state-true-assertions old-state))
        (setf (state-closed-world state) (state-closed-world old-state))
	state))


(defmacro set-true-assertions (state value)
    `(setf (state-true-assertions ,state) ,value))

(defmacro set-closed-world (state value)
    `(setf (state-closed-world ,state) ,value))

(defmacro set-false-assertions (state value)
    `(setf (state-false-assertions ,state) ,value))

(defmacro set-justification-table (state value)	
    `(setf (state-justification-table ,state) ,value))

;  -------------------- OPERATORS -------------------------


; The following macros are access macros for the properties of
; operators.  The properties are stored on the symbol that is the
; operator's name.  They are conviniently names so that they may be
; converted to a structure if this is desired.

(defmacro op-preconds (op)
    `(get ,op 'preconds))

(defmacro op-effects (op)
  `(get ,op 'effects))

(defmacro op-params (op)
  `(get ,op 'params))

(defmacro op-lpreconds (op)
  `(get ,op 'lpreconds))

(defmacro op-vars (op)
  `(get ,op 'vars))

(defmacro op-conj-lists (op)
  `(get ,op 'conj-lists))

(defmacro op-wildcard-vars (op)
  `(get ,op 'wildcard-vars))

(defmacro op-all-vars-in-effects (op)
  `(get ,op 'all-vars-in-effects))

(defmacro op-all-vars (op)
  `(get ,op 'all-vars))

(defmacro op-del-list (op)
  `(get ,op 'del-list))

(defmacro op-add-list (op)
  `(get ,op 'add-list))

(defmacro op-dels-for-matching (op)
  `(get ,op 'dels-for-matching))

(defmacro op-operator (op)
  `(get ,op 'operator))

(defmacro op-inference-rule (inf)
  `(get ,inf 'inference-rule))

;  ----------------------- SC RULES -------------------------

(defmacro scr-rhs (scr)
  `(get ,scr 'rhs))

(defmacro scr-lhs (scr)
   `(get ,scr 'lhs))

(defmacro scr-effects (scr)
  `(get ,scr 'effects))

(defmacro scr-preconds (scr)
  `(get ,scr 'preconds))

(defmacro scr-params (scr)
  `(get ,scr 'params))

(defmacro scr-rule-type (scr)
  `(get ,scr 'rule-type))

(defmacro scr-match-time (scr)
  `(get ,scr 'match-time))

(defmacro scr-priority (scr)
   `(get ,scr 'priority))

(defmacro scr-goals (scr)
   `(get ,scr 'goals))

(defmacro scr-abs-level (scr)
   `(get ,scr 'abs-level))


; --------------- GENERAL RULES ------------------------
; This macros can be applied to either ops or scrs.
#|
(defmacro rule-vars (rule)
  `(get ,rule 'vars))

(defmacro rule-params (rule)
  `(get ,rule 'params))

(defmacro rule-preconds (rule)
  `(get ,rule 'preconds))
|#


;  ------------------- EXPRESSIONS ------------------------


; The syntax for expressions (which are matched against the current state)
; is as follows:
; exp =               (quantifier (vars) generator expression)
;  or		      (~ exp)	                     [note: ~ means NOT]
;  or		      (predicate var var ...))  
;  or  		      (and exp exp...)
;  or		      (or exp exp...)	
; 
; vars = 	      (x y z ....), all the unbound variables in the generator
; Generator =         (P var var ...)		     
;  [note: generators may get more complex in future versions of PRODIGY]


;  Notes: No free variables are allowed in an expression.
;  	  The terms "literal" and "atomic-formula" have their usual logical
;  	  meanings. 
;  	  Shouldn't have two variables with the same name in an exp, even
;	  though its permissible in logic.	



; -----------   Type Checking Functions for Expressions -------

(defmacro quantified-p (exp)
    `(member (car ,exp) '(exists forall)))

(defmacro negated-p (exp)
    `(eq (car ,exp) '~))

(defun negate (lit)
    (cond ((eq (car lit) '~)
	   (cadr lit))	
	  ((list '~ lit))))

(defmacro closed-predicate (exp)
    `(member (car ,exp) *CLOSED-PREDS*))

(defun closed-literal (exp)
    (cond ((negated-p exp)
	   (member (caadr exp) *CLOSED-PREDS*))
	  (t (member (car exp) *CLOSED-PREDS*))))
 
(defmacro function-p (exp)
   `(member (car ,exp) *FUNCTION-PREDS*))

(defmacro static-p (exp)
    `(member (car ,exp) *STATIC-PREDS*))

(defmacro atomic-formula-p (exp)
     `(and ,exp (not (member (car ,exp) '(and or forall exists ~)))))

; -------- ACCESS FUNCTIONS for Expressions -------------
;  These functions access parts of quantifed expressions

(defmacro get-quantifier (exp)
     `(car ,exp))

(defmacro get-vars-lst (exp)
     `(cadr ,exp))

(defmacro get-gen-exp (exp)
     `(caddr ,exp))

(defmacro get-exp (exp)
    `(cadddr ,exp))

; ------------- A utility function that removes a list of properties
; ------------- from a symbol

(defun remove-list-of-properties (symbol list-of-properties)
    (declare (symbol symbol))
    "Removes a list of properties from a symbol."

    (dolist (property list-of-properties)
        (remprop symbol property)))

;;; This macro will dupliate the cmu common lisp macro ignore-errors
;;; for allegro common lisp.
;;; The only reason for puting it in this file is so that it can be loaded
;;; with the rest of the macros.
#+:franz-inc
(defmacro ignore-errors (&rest forms)
  "Executes forms after establishing a handler for all error conditions that
   returns from this form nil and the condition signalled."
   `(multiple-value-bind (no-error-p return-value)
	(excl:errorset ,@forms nil)
	(if no-error-p return-value nil)))
