#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#



(proclaim 
    '(special *STATE* *ALLOW-REPEATED-STATES* *ALLOW-ACHIEVED-GOALS*))


(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types"))


;  returns reason for goal loop (the goal on the stack) or nil.

(defun check-for-goal-loop (new-goals goal-stack)
    (cond ((null new-goals) nil)
	  ((do-goal-loop-check (car new-goals) goal-stack))
	  ((check-for-goal-loop (cdr new-goals) goal-stack))))

(defun do-goal-loop-check (goal stack)
    (cond ((has-vars goal)
	   (g-loop (while stack)
	            (do (cond ((and (lit-match goal (car stack))
				    (lit-match (car stack) goal))
			       (return (car stack)))))
		    (next stack (cdr stack))))
	  ((member goal stack :test #'equal)
	   (car (member goal stack :test #'equal)))))


(defun check-for-repeat-world (parent state)
  (cond (*ALLOW-REPEATED-STATES* nil)
	(t (check-for-repeat parent (state-closed-world state)))))


(defun check-for-repeat (parent closed-world)
    (cond ((null parent) nil)
	  ((and (not (eq closed-world (node-state parent)))
		(equal (state-closed-world (node-state parent))
		       closed-world))
	   (node-state parent))
	  (t (check-for-repeat (node-parent parent) closed-world))))


(defun check-whether-goals-achieved (goals state)
    (cond (*ALLOW-ACHIEVED-GOALS* nil)
	  ((null goals) nil)
	  ((check-whether-goal-achieved (car goals) state))
	  (t (check-whether-goals-achieved (cdr goals) state))))


(defun check-whether-goal-achieved (goal state)
    (setq *STATE* state)
    (cond ((in-database goal '((nil nil)))
	   goal)))


