#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *TARGET-CONCEPT-SPECS*))

(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))

; TC's are checked last to first at a node

 (setq *TARGET-CONCEPT-SPECS* '(

   (goal-succeeds
       (selection-heuristic sel-goal-succeeds)
       (active yes)
       (evaluable nil)
       (signature (goal-succeeds <@!node> <@!goal> <@!op> <@!b>))
       (sig-hist-map (goal-succeeds node h-goal h-applic-op h-bindings))
       (savings-estimator goal-succeeds-sav-est)
       (rule-type goal-pref)
       (sc-rule-template
	   (rule-nm
		   (lhs (and (current-node <@!node>)
			     (candidate-goal <@!node> <@!goal>)
			     (goal-succeeds <@!node> <@!goal> <@!op> <@!b>)
			     (candidate-goal <@!node> <@!other-goal>)
			     (not-equal <@!goal> <@!other-goal>)))
		   (rhs (prefer goal <@!goal> <@!other-goal>)))))


    (bindings-succeed
       (selection-heuristic sel-bindings-succeed)
       (active yes)
       (evaluable nil)
       (signature (bindings-succeed <@!node> <@!goal> <@!op> <@!b>))
       (sig-hist-map (bindings-succeed node h-goal h-applic-op h-bindings))
       (savings-estimator bindings-succeed-sav-est)
       (rule-type bindings-pref)
       (sc-rule-template
	   (rule-nm
		   (lhs (and (current-node <@!node>)
			     (current-goal <@!node> <@!goal>)
			     (current-op <@!node> <@!op>)
			     (candidate-bindings <@!node> <@!b>)
			     (bindings-succeed <@!node> <@!goal> <@!op> <@!b>)
			     (candidate-bindings <@!node> <@!other-b>)
			     (not-equal <@!b> <@!other-b>)))
		   (rhs (prefer bindings <@!b> <@!other-b>)))))

   (op-succeeds
       (selection-heuristic sel-op-succeeds)
       (active yes)
       (evaluable t)
       (signature (op-succeeds <@!node> <@!goal> <@!op> <@!b>))
       (sig-hist-map (op-succeeds node h-goal h-applic-op h-bindings))
       (savings-estimator op-succeeds-sav-est)
       (rule-type op-pref)
       (sc-rule-template
	   (rule-nm
		   (lhs (and (current-node <@!node>)
			     (current-goal <@!node> <@!goal>)
			     (candidate-op <@!node> <@!op>)
			     (op-succeeds <@!node> <@!goal> <@!op> <@!b>)
			     (candidate-op <@!node> <@!other-op>)
			     (not-equal <@!op> <@!other-op>)))
		   (rhs (prefer operator <@!op> <@!other-op>)))))



			     
; not ACTIVEE, before you make this active, add length test for goals
; so it wont fire if just one goal is there.
;   (sole-goal
;      (active no)
;      (selection-heuristic sel-sole-goal)
;      (signature (sole-goal <@!node> <@!goal>))
;      (sig-hist-map (sole-goal node u-goal))
;      (savings-estimator NOTATCTIVE sole-goal-sav-est)
;      (rule-type goal-select)
;      (sc-rule-template
;	   (rule-nm
;		   (lhs (and (current-node <@!node>)
;			     (is-top-level-node <@!node>)
;			     (candidate-goal <@!node> <@!goal>)
;			     (sole-goal <@!node> <@!goal>)))
;		   (rhs (select goal <@!goal>)))))
; 


   (sole-op 
      (active yes)
      (selection-heuristic sel-sole-op)
      (signature (sole-op <@!node> <@!goal> <@!op>))
      (sig-hist-map (sole-op node h-goal u-op))
      (savings-estimator sole-op-sav-est)
      (rule-type op-select)
      (sc-rule-template
	   (rule-nm
		   (lhs (and (current-node <@!node>)
			     (current-goal <@!node> <@!goal>)
			     (candidate-op <@!node> <@!op>)
			     (sole-op <@!node> <@!goal> <@!op>)))
		   (rhs (select operator <@!op>)))))


  (interacts
       (selection-heuristic sel-interacts)
       (active yes)
       (evaluable t)
       (signature (interacts <@!node>))
       (sig-hist-map (interacts node))
       (savings-estimator interacts-sav-est)
       (rule-type node-pref)
       (sc-rule-template
    	   (rule-nm
		   (lhs (and (candidate-node <@!node>)
			     (candidate-node <@!node2>)
			     (not-equal <@!node> <@!node2>)
			     (interacts <@!node>)))
		   (rhs (prefer node <@!node> <@!node2>)))))

  (goal-interacts
       (active yes)
       (selection-heuristic sel-goal-interacts)
       (signature (goal-interacts <@!node> <@!goal>))
       (sig-hist-map (goal-interacts node h-goal))
       (savings-estimator goal-interacts-sav-est)
       (rule-type goal-pref)
       (sc-rule-template
	   (rule-nm
		   (lhs (and (current-node <@!node>)
			     (candidate-goal <@!node> <@!goal>)
			     (goal-interacts <@!node> <@!goal>)
			     (candidate-goal <@!node> <@!goal2>)
			     (not-equal <@!goal> <@!goal2>)))
		   (rhs (prefer goal <@!goal2> <@!goal>)))))

  (op-interacts
       (active yes)
       (selection-heuristic sel-op-interacts)
       (signature (op-interacts <@!node> <@!goal> <@!op>))
       (sig-hist-map (op-interacts node h-goal h-op))
       (savings-estimator op-interacts-sav-est)
       (rule-type op-pref)
       (sc-rule-template
	   (rule-nm
		   (lhs (and (current-node <@!node>)
			     (current-goal <@!node> <@!goal>)
			     (candidate-op <@!node> <@!op>)
			     (op-interacts
				  <@!node> <@!goal> <@!op>)
			     (candidate-op <@!node> <@!op2>)
			     (not-equal <@!op> <@!op2>)))
		   (rhs (prefer operator <@!op2> <@!op>)))))

  (bindings-interact
       (active yes)
       (selection-heuristic sel-bindings-interact)
       (signature (bindings-interact <@!node> <@!goal> <@!op> <@!bindings>))
       (sig-hist-map (bindings-interact node h-goal h-op h-bindings))
       (savings-estimator bindings-interact-sav-est)
       (rule-type bindings-pref)
       (sc-rule-template
	   (rule-nm
		   (lhs (and (current-node <@!node>)
			     (current-goal <@!node> <@!goal>)
			     (current-op <@!node> <@!op>)
			     (candidate-bindings <@!node> <@!bindings>)
			     (bindings-interact <@!node> <@!goal> <@!op> <@!bindings>)
			     (candidate-bindings <@!node> <@!bindings2>)
			     (not-equal <@!bindings> <@!bindings2>)))
		   (rhs (prefer bindings <@!bindings2> <@!bindings>)))))

  (fails
       (selection-heuristic sel-fails)
       (active yes)
       (evaluable t)
       (signature (fails <@!node>))
       (sig-hist-map (fails node))
       (savings-estimator fails-sav-est)
       (rule-type node-reject)
       (sc-rule-template
	   (rule-nm
		   (lhs (and (candidate-node <@!node>)
			     (fails <@!node>)))
		   (rhs (reject node <@!node>)))))
      
   (goal-fails 
       (active yes)
       (selection-heuristic sel-goal-fails)
       (signature (goal-fails <@!node> <@!goal>))
       (sig-hist-map (goal-fails node h-goal))
       (savings-estimator goal-fails-sav-est)
       (rule-type goal-reject)
       (sc-rule-template
	    (rule-nm
		   (lhs (and (current-node <@!node>)
			     (candidate-goal <@!node> <@!goal>)
			     (goal-fails <@!node> <@!goal>)))
		   (rhs (reject goal <@!goal>)))))

   (op-fails
       (active yes)
       (selection-heuristic sel-op-fails)
       (signature (op-fails <@!node> <@!goal> <@!op>))
       (sig-hist-map (op-fails node h-goal h-op))
       (savings-estimator op-fails-sav-est)
       (rule-type op-reject)
       (sc-rule-template
	    (rule-nm
		   (lhs (and (current-node <@!node>)
			     (current-goal <@!node> <@!goal>)
			     (candidate-op <@!node> <@!op>)
			     (op-fails <@!node> <@!goal> <@!op>)))
		   (rhs (reject operator <@!op>)))))
   

   (bindings-fail
       (active yes)
       (selection-heuristic sel-bindings-fail)
       (signature (bindings-fail <@!node> <@!goal> <@!op> <@!bindings>))
       (sig-hist-map (bindings-fail node h-goal h-op h-bindings))
       (savings-estimator bindings-fail-sav-est)
       (rule-type bindings-reject)
       (sc-rule-template
	    (rule-nm
		   (lhs (and (current-node <@!node>)
			     (current-op <@!node> <@!op>)
			     (current-goal <@!node> <@!goal>)
			     (candidate-bindings <@!node> <@!bindings>)
			     (bindings-fail <@!node> <@!goal> <@!op> <@!bindings>)))
		   (rhs (reject bindings <@!bindings>)))))
   

    
   ))

(setq *TARGET-CONCEPTS* nil)

(g-loop 
 (init tcs *TARGET-CONCEPT-SPECS* nm nil spec nil)
    (while (setq spec (pop tcs)))
    (do (setq nm (pop spec))
	(cond ((eq 'no (cadr (assoc 'active spec)))) ;  do nothing
	      ((push nm *TARGET-CONCEPTS*)
               (dolist (attribute spec)
	         (setf (get nm (car attribute))(cadr attribute)))))))


    



(defun interaction-tcs ()
				; cant have these others without node-interacts
             ;    (or (member 'op-interacts *TARGET-CONCEPTS*)
	     ;        (member 'goal-interacts *TARGET-CONCEPTS*))
    (member 'interacts *TARGET-CONCEPTS*))



