#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *EBL-PATH* *L-RESULTS* *LEARNING-MODE*
		    *STOP-ON-WARNING* *EBL-PRINTING* *MIN-MATCH-TIME*
                    *TP-FNS* *MAX-NODES-TO-ADD* *LOAD-EBL-TIME*
		    *TRIM-FACTOR*  *MACRO-LEARNING* *MAX-EXP-SIZE*
		    *EBL-FLAG* *TP-TIME-BOUND* *ACTIVATE-EBL*
		    *NUM-RUNS* *LEARNED-RULES-IN-SYS*
		    *LEARNED-RULES*))

(setq *EBL-PATH* (pathname "/usr/prodigy/system/ebl/"))

; optional, we like to have the system print-out as files are loaded
(setq *load-verbose* t)


(setq *EBL-FLAG* t)
(setq *ACTIVATE-EBL* nil) ; Ebl is initially off, must be toggled on to learn.
(setq *EBL-PRINTING* t)

(setq *EXPAND-ALL* nil)
(setq *STOP-ON-WARNING* nil) 
(setq *TP-FNS*  ; functions used by users in simplification rules for prover
                ; Stored as an assoc list with Num of vars taken + 1.
      '((complete-univ-quantified-var 3)
	(only-single-mention 2)
	(f-outside-scope 3)))

(setq *MAX-NODES-TO-ADD* 35) ; Maximum number of nodes that the system should
                             ; expand to verify an interaction.
(setq *MAX-EXP-SIZE* 30)
(setq *NUM-RUNS* 0)
(setq *MACRO-LEARNING* nil)

(setq *LEARNED-RULES-IN-SYS* nil)
(setq *LEARNED-RULES* nil)

; system dependent
(setq *TRIM-FACTOR* (* 1.2 internal-time-units-per-second))
(setq *TP-TIME-BOUND* (* 2 internal-time-units-per-second))
(setq *MIN-MATCH-TIME* 0)


(load-path *EBL-PATH* "ebl-data-types")
(load-path *EBL-PATH* "ebl-top-level")
(load-path *EBL-PATH* "planner-calls")
(load-path *EBL-PATH* "domain-check")
(load-path *EBL-PATH* "axioms-check")
(load-path *EBL-PATH* "ua")  
(load-path *EBL-PATH* "obs")  
(load-path *EBL-PATH* "ps-fns")
(load-path *EBL-PATH* "cmpl")
(load-path *EBL-PATH* "lookups")
(load-path *EBL-PATH* "pl-simp")
(load-path *EBL-PATH* "lmisc")
(load-path *EBL-PATH* "order")
(load-path *EBL-PATH* "hist")
(load-path *EBL-PATH* "ebs")
(load-path *EBL-PATH* "select")
(load-path *EBL-PATH* "tc-specs")
(load-path *EBL-PATH* "newtrack")
(load-path *EBL-PATH* "inter")
(load-path *EBL-PATH* "process")
(load-path *EBL-PATH* "schema-loader")
(load-path *EBL-PATH* "pl-tp")
(load-path *EBL-PATH* "gen-ex")
(load-path *EBL-PATH* "script")

(forget-rules 'all)
(reset-obs)
(setq *LOAD-EBL-TIME* (get-internal-run-time))

