#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special  *CURRENT-NODE* *PROVED*))

(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))




; Contains Selection heuristics

; Selection heuristics look at a node and return a list of hists,
; each hist is a symbol used to hang information off of regarding
; a target concept/training example pair.

; Hists may be marked with the flag 'dont-make-rule, in which 
; case the learning system will still learn and cache the result of EBS, 
; but no search control rule will be created. (I.e. the result is
; not useful by itself, but is a useful lemma for a higher level result).

; Assumes node has been "marked for target concepts" in hist.l

; selection heuristic for node-fails

(defun sel-fails (n)
  (if (and (not (upper-node-failure-proved-so-ignore-lower-failure n))
	   (not (node-alternatives n))
	   (node-node-level-failure n)
	   (or (not (node-added-after-restart n))
	       (and (worth-gi-learning)
		    (above-is-supporting-failure n))))
      (let ((h (make-hist n)))
	(cond ((node-reset-alt n)
	       (setf (get h 'dont-make-rule) 'is-reset)))
	(list h))))

(defun above-is-supporting-failure (n)
  (g-loop (while n)
	  (do (if (eq 'supporting-failure (node-gi-label n))
		  (return t)))
	  (next n (node-parent n))))
	  

(defun upper-node-failure-proved-so-ignore-lower-failure (n)
  (let ((upper-failed-node (upper-node-failed n)))
    (and upper-failed-node
	 (or (not (interaction-tcs))
	     (not (worth-gi-learning))
	     ; no need to prove failure for gi
	     (upper-node-interaction-proved-so-ignore-lower-interaction n)
	     (g-loop (init node n)
		     (while n)
		     (until (node-eql node upper-failed-node))
		     (do (cond ((eq 'supporting-failure (node-gi-label node))
				(return nil))))
		     (next node (node-parent node))
		     (result t))))))


;  currently we only deal with goal-failures at top-level nodes
;  since at lower level nodes only a single goal is selected.
;  (Therefore, at lower level nodes, only node-level failures, no
;  goal-level failures.)

; h-goal is the goal that failed

(defun sel-goal-fails (n)
  (if (and (is-top-level-node n)
	   (not (node-node-level-failure n)))
      (g-loop (init failed-goals (node-goal-level-failures n)
		    ret-val nil h nil)
	      (while failed-goals)
	      (do (exists-child-with-goal-failure n (car failed-goals))
		  (setq h (make-hist n))
		  (setf (get h 'h-goal) (car failed-goals) )
		  (push h ret-val))
	      (next failed-goals (cdr failed-goals))
	      (result ret-val))))


(defun exists-child-with-goal-failure (n g)
    (some #'(lambda (c) (equal g (alt-goal (node-generating-alt c))))
	  (node-children n)))

(defun is-special-node (n)
    (eq (eval 'N1) (leftmost-clone n)))

; h-op is the op that failed
; h-goal is the which h-op was used to try to achieve.

(defun sel-op-fails (n)
  (if (and (not (is-special-node n))
           (not (node-node-level-failure n)))  ;do nothing
      (g-loop (init ops (node-op-level-failures n)
		    ret-val nil h nil)
	      (while ops)
	      (do (setq h (make-hist n))
		  (setf (get h 'h-op) (car ops))
		  (setf (get h 'h-goal) (get-successful-goal n))
		  (push h ret-val))
	      (next ops (cdr ops))
	      (result ret-val))))

; h-bindings are the bindings that failed
; the-child-with-bindings is the child generated with those bindings
; h-op is the op for which the bindings were used.
; h-goal is the which h-op was used to try to achieve.
; h-add is the effect of h-op which unified with h-goal.
; h-applied-children is actually a flag used to indicate
;  that a particular op-add combination had at least one child that was applied

(defun sel-bindings-fail (n) 
  (if (and (not (is-special-node n))
	   (not (node-node-level-failure n))
	   (not (node-op-level-failure n))) ; this is too conservative! modify
      (g-loop (init children (node-bindings-level-failures n)
		    ret-val nil h nil c nil)
	      (while (setq c (pop children)))
	      (do (setq h (make-hist n))
		  (setf (get h 'the-child-with-bindings) c) ;  dont want to
		  ;; use h-child cause of possible confusion 
		  (setf (get h 'h-bindings) (alt-vars (node-generating-alt c)))
		  (setf (get h 'h-op) (alt-op (node-generating-alt c)))
		  (setf (get h 'h-add) (alt-post-cond (node-generating-alt c)))
		  ;; used by discrimination functions 
		  (setf (get h 'applied-children)
			(list (list (list (get h 'h-op) (get h 'h-add))
				    (if (node-applied-node c)
					(list c)))))
		  (setf (get h 'h-goal)
			(alt-goal (node-generating-alt c)))
		; don't bother if there is an OR in the
		; preconds, otherwise have to worry about
		; multiple children having subgoals for same bindings
		  (if (and (not (brother-has-identical-proof c))
			   (not (r-memq 'or (get (get h 'h-op) 'lpreconds))))
		      (push h ret-val)))
	      (result ret-val))))


; Returns T if a node has a sibling that fails for the same reason,
; (ie. a proof has already been created describing why the sibling failed.)
(defun brother-has-identical-proof (c)
    (let ((where-proved (cadr (cadr (assoc (list 'fails c) *PROVED*
					   :test #'equal)))))
	 (and (not (node-eql where-proved c))
	      (member where-proved
		     (node-children (node-parent c)))
              ; needed?
	      (equal (alt-failed-cond (node-generating-alt c))
		     (alt-failed-cond (node-generating-alt where-proved))))))

; after checking that there is a success-child, the node is a normal node,
; and there are goal-level failures, checks that there are no unexplored
; alts with goals other than the success-goal, and that all children
;  generated when attempting these other goals are proven failures
; (some  may have not been proved if added after planning).

; u-goal is the successful goal (it was eventually achieved and led to a 
; solution.

(defun sel-sole-goal (n)
  (if (node-success-child n)
      (let ((success-goal (get-successful-goal n)))
	(if (and (not (is-special-node n))
	         (node-goal-level-failures n)
       	         (every #'(lambda (alt) (equal (alt-goal alt) success-goal))
			(node-alternatives n))
	         (every #'(lambda (c)
			    (or (equal success-goal 
				       (alt-goal (node-generating-alt c)))
				(and (assoc (list 'fails c) *PROVED* :test #'equal)
				     (member (alt-goal (node-generating-alt c))
					     (node-goal-level-failures n)))))
			(node-children n)))
	    (let ((hist (make-hist n)))
	       (setf (get hist 'u-goal) (get-successful-goal n))
	       (list hist))))))

; after checking that there is a success-child, the node is a normal node,
; and there are op-level failures, checks that there are no unexplored
; alts with other ops other than the success-op, and that all children
; generated when trying these other ops are proven failures
; (some  may have not been proved if added after planning).

; u-goal is success-goal,
; u-op is the successful op.

(defun sel-sole-op (n)
  (if (node-success-child n)
      (let* ((success-goal (get-successful-goal n))
             (success-op  (alt-op (node-generating-alt
				   (node-success-child n)))))
	(if (and (not (is-special-node n))
	         (node-op-level-failures n)
		 (every #'(lambda (alt) (if (equal success-goal (alt-goal alt))
					    (eq success-op (alt-op alt))))
			(node-alternatives n))
		 (every #'(lambda (c) 
			    (or (not (equal success-goal 
					    (alt-goal
					     (node-generating-alt c))))
				(eq success-op
				    (alt-op (node-generating-alt c)))
				
				(and (assoc (list 'fails c) *PROVED*
					    :test #'equal)
                                     ; need this since restart nodes may be
                                     ; in *PROVED*, but op-failures unselected
				     (member (alt-op (node-generating-alt c))
					     (node-op-level-failures n)))))
			(node-children n)))
	    (let ((hist (make-hist n)))
	      (setf (get hist 'u-op)
		    (alt-op (node-generating-alt (node-success-child n))))
	      (setf (get hist 'h-goal) success-goal)
	      (list hist))))))

; selection heuristic for node-interacts Target concept.

; should only make rule if there's a brother success
; with no interaction...
; actually, for now no rule made at all, since node-preference rules
; are so inefficient, node-level interactions are thus only used
; as intermediate results.

(defun sel-interacts (n)
    (and (not (node-interaction-explained-at-higher-level n))
	 (node-node-level-gi n)
	 (worth-gi-learning)
	 (let ((hist (make-hist n)))
	      (g-loop (init brothers (node-children (node-parent n))
			  found-one nil)
	 	    (while brothers)
		    (do (and (node-succeeded (car brothers))
			     (not (node-eql n (car brothers)))
			     (eq (node-gi-label (car brothers)) 'no)
			     (setq found-one t)))
		    (until found-one)
		    (next brothers (cdr brothers))
		    (result (cond ((not found-one)
				   (setf (get hist 'dont-make-rule)
					 'no-good-bro-found))
				  (t (setf (get hist 'dont-make-rule)
					   'no-node-pref-yet)))))
	      (list hist))))
	       
; h-goal is the goal that results in an interaction.
	 
(defun sel-goal-interacts (n)
    (and (is-top-level-node n)
	 (worth-gi-learning)
	 (not (node-node-level-gi n))
	 (a-child-does-not-interact n) ; may want to take this out...
	 (g-loop (init gi-goals (node-goal-level-gis n)
		     ret-val nil h nil)
	       (while gi-goals)
	       (do (setq h (make-hist n))
		   (setf (get h 'h-goal) (car gi-goals))
		   (setf (get h 'make-rule) t)
		   (push h ret-val))
	       (next gi-goals (cdr gi-goals))
	       (result ret-val))))

; h-op is the op that results in an interaction.
; h-goal is the which h-op was used to try to achieve.	       

; op-level-gis = ((goal op)...)
; may want to take out a-child-does-not-interact test, but
; if so, must modify savings-est, which is looking for a good-guy

(defun sel-op-interacts (n)
  (if (and (not (node-interaction-explained-at-higher-level n))
           (worth-gi-learning)
           (not (is-special-node n))
	   (not (node-protection-violation n)) ;  both handled at
	   (not (node-prerequisite-violation n))) ;  node level
      (g-loop (init goal-op-pairs (node-op-level-gis n)
		    ret-val nil h nil)
	      (while goal-op-pairs)
	      (do (cond ((a-child-with-goal-does-not-interact 
			  n (caar goal-op-pairs)) ; may want to take out...
			 (setq h (make-hist n))
			 (setf (get h 'h-op) (cadar goal-op-pairs))
			 (setf (get h 'h-goal) (caar goal-op-pairs))
			 (push h ret-val))))
	      (next goal-op-pairs (cdr goal-op-pairs))
	      (result ret-val))))

; h-bindings are the bindings that resulted in an interaction.
; the-child-with-bindings is the child generated with those bindings
; h-op is the op for which the bindings were used.
; h-goal is the which h-op was used to try to achieve.
; h-add is the effect of h-op which unified with h-goal.
; h-applied-children is actually a flag used to indicate
;  that a particular op-add combination had at least one child that was applied

(defun sel-bindings-interact (n) 
  (if (and (not (node-interaction-explained-at-higher-level n))
	   (worth-gi-learning)
	   (not (node-reset-alt n))
	   (not (is-special-node n))
	   (not (node-protection-violation n)) ;  both handled at
	   (not (node-prerequisite-violation n))) ;  node level
      (g-loop (init children (node-bindings-level-gis n)
		    ret-val nil h nil c nil)
	      (while (setq c (pop children)))
	      (do (setq h (make-hist n))
		  (setf (get h 'the-child-with-bindings) c)
		  (setf (get h 'h-bindings)
			(alt-vars (node-generating-alt c)))
		  (setf (get h 'h-op) (alt-op (node-generating-alt c))) 
		  (setf (get h 'h-add) (alt-post-cond (node-generating-alt c)))
		  (setf (get h 'applied-children) ; used by lookups
			(list (list (list (get h 'h-op) (get h 'h-add))
				    (if (node-applied-node c)
					(list c)))))
		  (setf (get h 'h-goal) (alt-goal (node-generating-alt c)))
			;  don't bother if there is an or in the
			; preconds, otherwise have to worry about
			; multiple children having subgoals for same bindings
		  (if (and (not (r-memq 'or (get (get h 'h-op) 'lpreconds)))
                        ; may want to take this out...
			   (a-child-with-diff-bindings-does-not-interact n c))
  		      (push h ret-val)))
	      (result ret-val))))

(defun a-child-does-not-interact (n)
  (some #'(lambda (c) (eq 'no (node-gi-label c)))
	(node-children n)))

(defun a-child-with-goal-does-not-interact (n goal)
  (some #'(lambda (c) (and (eq 'no (node-gi-label c))
		           (equal goal (alt-goal (node-generating-alt c)))))
	(node-children n)))

; a child with same goal and op does not interact (the-child does interact).
(defun a-child-with-diff-bindings-does-not-interact (n the-child)
  (some #'(lambda (c) (and (eq 'no (node-gi-label c))
		           (equal (alt-goal (node-generating-alt the-child))
				  (alt-goal (node-generating-alt c)))
			   (equal (alt-op (node-generating-alt the-child))
				  (alt-op (node-generating-alt c)))))
	(node-children n)))


(defun on-first-succ-path (n bot)
    (cond ((node-eql bot n) t)
	  ((node-eql bot (eval 'N1)) nil)
	  ((null bot) nil)
	  ((on-first-succ-path n (node-parent bot)))))


(defun exists-a-child-with-goal-that-failed (n)
  (some #'(lambda (c) (and (not (node-succeeded c))
			   (not (node-added-after-restart c))
			   (not (equal (get-successful-goal n)
				       (alt-goal (node-generating-alt c))))))
	(node-children n)))
		
(defun exists-a-child-with-goal-and-op-that-failed (n)
  (some #'(lambda (c) (and (not (node-succeeded c))
			   (not (node-added-after-restart c))
			   (equal (get-successful-goal n)
			          (alt-goal (node-generating-alt c)))
			   (equal (alt-op (node-generating-alt c))
				  (alt-op (node-generating-alt
					   (node-success-child n))))))
	(node-children n)))


; h-goal is the success-goal (achieving that goal first led to a solution.
; h-applic-op is the successful operator
; h-bindings is the successful list of bindings with which the op was 
; eventually instantiated.

(defun sel-goal-succeeds (n)
  (if (and (node-success-child n)   
	   (not (node-straight-solution (eval 'N1)))
	   (not (node-applied-node (node-success-child n)));applied right away
	   (is-top-level-node n)
	   (on-first-succ-path n (node-first-succ-node (eval 'N1)))
	   (exists-a-child-with-goal-that-failed n))
      (let ((h (make-hist n))
	    (c (node-success-child n)))
	(setf (get h 'h-goal)
	      (alt-goal (node-generating-alt c)))
	(setf (get h 'h-applic-op)(alt-op (node-generating-alt c)))
	(setf (get h 'h-bindings)
	      (alt-vars (node-generating-alt
			 (node-success-child
			  (get-right-succ-clone n)))))
	(list h))))
		
; h-goal is the success-goal (achieving that goal first led to a solution.
; h-applic-op is the successful operator
; h-bindings is the successful list of bindings with which the op was 
; eventually instantiated.

(defun sel-bindings-succeed (n)
  (if (and (node-success-child n)
	   (not (node-applied-node (node-success-child n)));applied right awy
	   ;; WRONG, this is a temp FIX... should make rule when intermed
	   ;; clones have failures...
	   (node-eql n (leftmost-clone n))
	   (not (node-straight-solution (eval 'N1)))
	   (on-first-succ-path n (node-first-succ-node (eval 'N1)))
           (exists-a-child-with-goal-and-op-that-failed n))
      (let ((c (node-success-child n))
	    (h (make-hist n)))
	(setf (get h 'h-goal) (alt-goal (node-generating-alt c)))
	(setf (get h 'h-applic-op)(alt-op (node-generating-alt c)))
	(setf (get h 'h-bindings)
	      (alt-vars (node-generating-alt
			 (node-success-child
			  (get-right-succ-clone n)))))
	
	(list h))))
		

; h-child is the successful child.
; h-op is the successful operator at node n
; Each op-end is a pair (op node) where node is the place that op was actually 
; applied. List of op-ends is ordered with highest node last (important!)
; h-goal is the success-goal (achieving that goal first led to a solution.)
; h-applic-op and node are the last op and the place where its applied.
; h-bindings is the successful list of bindings with which the op was 
; eventually instantiated.


(defun sel-op-succeeds (n)    
  (if (and (node-success-child n) ; does not include last op
	   (not (node-straight-solution (eval 'N1)))
	   (on-first-succ-path n (node-first-succ-node (eval 'N1))))
      (g-loop (init op-ends (sel-get-succ-ops n) hists nil op-end nil
		    hist nil applic-node nil)
	      (while (setq op-end (pop op-ends)))
	      (do (setq hist (make-hist n))
		  (setf (get hist 'h-child) (node-success-child n))
		  (setf (get hist 'h-op)
			(alt-op (node-generating-alt (node-success-child n))))
		  (setf (get hist 'h-applic-op) (car op-end))
                  (setf applic-node (cadr op-end))
		  (setf (get hist 'h-applic-node) applic-node)
		  (setf (get hist 'h-bindings)
			(alt-vars (node-generating-alt
				   (node-success-child applic-node))))
		  (setf (get hist 'h-goal)
			(alt-goal (node-generating-alt
				   (node-success-child applic-node))))
		  (cond ((and (not (node-eql
				    n (leftmost-clone applic-node)))
			      (not-top-level-node n))
			 (setf (get hist 'dont-make-rule) 'intermed-result)))
		  ;;  dont learn about 1-long op-seqs
		  (cond ((and (node-eql applic-node n)
		              (not (node-applied-node n)))
		         (setf (get hist 'one-op-long) t)
		         (setf (get hist 'dont-make-rule) 'one-op-long)))
	          ;; insures not needed by other top-level goals
		  (if (and (not (eq 'intermed-result
				    (get hist 'dont-make-rule)))
                           ;; the following are too strong
			   (not (node-op-level-failures n))
			   (not (node-goal-level-failures n)))
		      (setf (get hist 'dont-make-rule) 'no-op-fails))
                  (if (worth-learning-from-succ-op-seq n hist applic-node)
		      (push hist hists)))
	      (result (cond ((has-top-level-other-goals n)
			     (cons (make-top-level-other-goals-hist n) hists))
			    (hists))))))

(defun worth-learning-from-succ-op-seq (n hist applic-node)
  (cond ((and (get hist 'one-op-long)
	      (or (node-eql (eval 'N2) n)
		  (not-top-level-node n)))
	 nil)
        ((and (no-failures-at-node (leftmost-clone applic-node))
	      ;; no failures at applic-node
	      (or (not (equal '((done)) (node-goal-stack applic-node)))
		  (node-eql (eval 'N2) (left-clone applic-node))
		  (no-failures-at-any-top-left-clone applic-node)))
	 nil)
	((and (eq (get hist 'dont-make-rule) 'no-op-fails) 
	      (not (node-applied-node n))
	      ;; above makes sure not needed by goal or bindings-succeeds 
	      (no-failures-at-node n)
	      ;; insures not needed by other top-level goals
	      (or (node-eql  (eval 'N2) n)
		  (not-top-level-node n)))
	 nil)
	(t t)))



(defun no-failures-at-node (n)
  (every #'(lambda (c) (or (node-succeeded c)
		           (node-added-after-restart c)))
       (node-children n)))

(defun no-failures-at-nodes (nodes)
  (every #'no-failures-at-node nodes))
  
(defun left-clones (n)
  (g-loop (init leftmost (leftmost-clone n) ret-val (list n))
	  (until (or (node-eql n leftmost) (null n)))
	  (next n (left-clone n))
	  (do (push n ret-val))
	  (result ret-val)))

; hack to put in hist for top-level goals...

(defun has-top-level-other-goals (n)
    (and (equal '((done)) (node-goal-stack n))
	 (node-applied-node (node-success-child n))
	 (node-goal-stack (node-success-child (node-success-child n)))
	 (clone-level-failures
	  (left-clone (node-success-child n))))) ; N1clone


;  see if goal ordering mattered. Look through all grandchildren
; for each N1 clones to see if they have different generating goals.
(defun clone-level-failures (n)
  (cond ((null n) nil)
        ((let* ((cs (node-children (car (node-children n))))
		(goal (alt-goal (node-generating-alt (car (reverse cs))))))
	   (some #'(lambda (c)
		     (and (not (node-added-after-restart c))
			  (not (equal goal 
				      (alt-goal (node-generating-alt c))))))
		 cs))
	 t)
	(t  (clone-level-failures (left-clone n)))))
       
    


; 		  c1
; 		 /  \
; what a hack.  n    c2
; 		      \
;		       c3		


(defun make-top-level-other-goals-hist (n)
    (prog (c3 op2 g2 h c2 op1 c1)
	  (setq h (make-hist n))
	  ;  also make sure its applied node before assuming
	  ; its intermediate. eg. macr applied, effects later stuff.
	  (cond ((node-applied-node n)
  	         (setf (get h 'dont-make-rule) 'intermed-result) )
		((no-failures-at-node n)
		 (setf (get h 'dont-make-rule)
		       'no-op-failed-at-top-level-applied-node)))
	  (setf (get h 'top-level-succ-with-mult-goals) t)
	  (setf (get h 'h-child)  (node-success-child (node-success-child n)))
	  (setq c2 (node-success-child (node-success-child n)))
	  (setq c1 (node-parent c2))
	  (setq c3 (node-success-child c2))
	  (setq op2 (alt-op (node-generating-alt c3)))
	  (setq g2 (alt-goal (node-generating-alt c3)))
	  (setf (get h 'h-applic-node) c2)
; the following code should be inserted here, instead of c2 in above line
;		(or (car (g-map (clone in (node-right-clones c2))
;			        (when (if clone (node-succeeded clone)))
;				(save clone)))
;		    c2)
	  (setf (get h 'new-h-applic-op) op2) 
	  (setq op1 (alt-op (node-generating-alt (node-success-child n))))
	  (setf (get h 'h-applic-op) op1) 
	  (setf (get h 'h-op) op1)
	  (setf (get h 'h-bindings)
	      (alt-vars (node-generating-alt (node-success-child n))))
	  (setf (get h 'new-h-bindings)
		(alt-vars (node-generating-alt
			     (car (g-map (clone in (node-right-clones c1))
					 (when (if clone ; may be nil
						    (node-succeeded clone)))
					 (save clone))))))
	  (setf (get h 'h-goal)
		(alt-goal (node-generating-alt (node-success-child n))))
	  (setf (get h 'new-h-goal) g2)
	  (return h)))
	  


; op-end is a pair (op node) where node is the place that op was actually 
; applied. Returns a list of  op-node with highest node last (important!)

(defun sel-get-succ-ops (n)
    (g-loop (init op-ends nil op nil)
 	  (do (setq n (get-right-succ-clone n))
	      (setq n (node-success-child n)))
	  (while n)
	  (do (setq op (alt-op (node-generating-alt n)))
	      (if (not (eq op '*FINISH*))
		  (push (list op (node-parent n)) op-ends)))
	  (result (nreverse op-ends))))

; rightmost clone that is a successful node
; This code is weird because right-clones include nils.
; (see data-types.l in the planner for right-clone documentation).

(defun get-right-succ-clone (n)
  (g-loop (init r-clones (node-right-clones n))
	  (while r-clones)
	  (until (and (car r-clones); may be nil...
		      (node-succeeded (car r-clones))
		      (on-success-child-path (car r-clones) n)))
	  (next r-clones (cdr r-clones))
	  (result (cond ((null r-clones) n)
			((get-right-succ-clone (car r-clones)))))))

(defun on-success-child-path (clone n)
  (g-loop (while n)
	  (do (if (node-eql n clone)(return t)))
	  (next n (node-success-child n))
	  (result nil)))


(defun worth-gi-learning ()
    (not (member (node-gi-label (eval 'N1)) 
                 '(yes maybe))))


(defun no-failures-at-any-top-left-clone (appl-node)
    (let ((n (leftmost-clone appl-node)))
	(and (no-failures-at-node n)
	     (or (node-eql (eval 'N2) n)
		 (no-failures-at-any-top-left-clone
		   (node-parent (node-parent n)))))))



