#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *EVALUABLE-SIGS* *SCHEMAS* *SCHEMA-TABLE*))

(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))


;  ---------------------------------------------------------------
; The following code is used for checking the syntax of pl expressions 
; Users of the EBL system do not need to use this unless they are writing
; their own architecture-level axioms.
; 

;  Note that once a syntactic error is caught in 
;  an expression, error checking stops, so you have to fix one error 
;  at a time. The code was stolen from LOAD-DOMAIN, and then modified.

(defun ps-syntax-check ()
    (g-map (f in *EVALUABLE-SIGS*)
	  (do (cond ((and (not (fboundp (car f)))
			  (not (is-open f)))
		     (format t
			   "~%ERROR: Function ~a is not implmented!" f)))))
    (g-loop (init err nil temp-schemas *SCHEMAS* s nil)
	  (while (setq s (pop temp-schemas)))
	  (do (setq err (ps-check-exp-syntax (caddr s)))
	      (and err
		   (format t "~2%Syntax error detected in schema: ~a~%~a : ~a"
			   s (car err) (cadr err))))
	  (until err)))



;  Returns nil if EXP is syntactically correct, otherwise returns
;  a list = (MSG-MSG SUB-EXP), where ERR-MSG is an error message,
;  and SUB-EXP is the sub-expression containing the error.

(defun ps-check-exp-syntax (exp)
    (cond ((member (car exp) '(forall exists let))
	   (cond ((not (or (equal 4 (length exp)) (equal 3 (length exp))))
		  (list "Expression is wrong length" exp))
		 ((ps-check-vars-lst exp))
		 ((ps-check-exp-syntax (get-gen-exp exp)))
		 (t (ps-check-exp-syntax (get-exp exp)))))
	  ((eq (car exp) '~)
	   (ps-check-exp-syntax (cadr exp)))
	  ((eq (car exp) 'and)
	   (cond ((< (length exp) 3)
		  (list "Not enough conjuncts in expression" exp))
		 (t (car (g-map (x in (cdr exp))
			       (filter (ps-check-exp-syntax x)))))))
	  ((eq (car exp) 'or)
	   (cond ((< (length exp) 3)
		  (list "Not enough disjuncts in expression" exp))
		 (t (car (g-map (x in (cdr exp))
			       (filter (ps-check-exp-syntax x)))))))
	  ((null exp) nil)
	  (t  (ps-check-atomic-formula exp))))

; Checks the variables-list of a quantified expression. Returns nil if OK.

(defun ps-check-vars-lst (exp)
    (cond ((not (listp (get-vars-lst exp)))
	   (format t "~%POTENTIAL syntax error~%Need list of variables in: ~a" exp) nil)
	  ((g-map (v in (get-vars-lst exp))
		 (when (not (is-variable v)))
		 (save v))
	   (list "The list of variables must contain only variables" exp))
	  (t nil)))


(defun ps-check-atomic-formula (exp)
    (cond ((listp (car exp))
	   (list "Not a correct atomic formula: " exp))
	  ((and (assoc (car exp) *EVALUABLE-SIGS*)
		(not (eq (length exp)
			 (length (assoc (car exp) *EVALUABLE-SIGS*)))))
	   (list "DOES NOT AGREE WITH SIGNATURE LENGTH" exp))
	  ((and (is-open exp)
		(g-map (rule in (cdr (assoc (car exp) *SCHEMA-TABLE*)))
		      (when (not (eq (length (car (get rule 'sig-form)))
				     (length exp))))
		      (save rule)))
	   (list "DOES NOT AGREE WITH DEFINED LENGTH" exp))))

