#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(proclaim '(special *CLOSED-PREDS* *STATIC-PREDS* *RULE-STACK*))

(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))

(defun getn (h)
    (get h 'node))


(defun def-node-fails-from-scr-rejection (h n)
    (node-reject-node-hst (getn h)))

(defun def-already-achieved1 (h n)
    (cond ((and (eq 'goal-already-achieved (car (get h 'failure-reason)))
	   	(equal (cadr (get h 'failure-reason))
		       (if (get h 'reset-alt) (alt-goal (get h 'reset-alt)))))
	   t)))

(defun def-already-achieved2 (h n)
    (cond ((eq 'goal-already-achieved (car (get h 'failure-reason)))
	   t)))

;  bro deletion should give better expl
(defun def-state-loop (h n)
    (and (eq (car (get h 'failure-reason)) 'repeat-world)
	 (or (not (node-goal-stack (getn h))) 	; im confused so I put this
	     (not (node-bro-deletion-node (getn h))))))

(defun def-goal-stack-loop (h n)
    (cond ((eq (car (get h 'failure-reason)) 'goal-repeat)
	   (setf (get h 'h-goal) 
		 (cadr (node-failure-reason (getn h)))) ; repeat goal
	   t)))
	
(defun def-reset-fails (h n)
    (cond ((get h 'reset-alt)
	   (setf (get h 'h-op)
		 (if (get h 'reset-alt) (alt-op (get h 'reset-alt))))
	   (setf (get h 'h-goal)
		 (if (get h 'reset-alt) (alt-goal (get h 'reset-alt))))
	   t)))



; this is single goal case - - should change name

(defun def-fails (h n)
  (cond ((and (not (get h 'reset-alt))
	      (not-top-level-node (getn h)))
	 (setf (get h 'h-goal) 
	       (or (node-last-goal (getn h))
		   (node-current-goal (getn h)))))
	(t nil)))

; select-goal-hst = ((rule-nm bindings sel-goal))

(defun def-fails-after-goal-selection (h n)
    (cond ((and (is-top-level-node (getn h))
		(node-select-goal-hst (getn h)))
	   (setf (get h 'h-goal)
		 (caddar (node-select-goal-hst (getn h))))
	   t)))

(defun def-fails-after-goal-rejection (h n)
    (cond ((and (not-top-level-node (getn h))
		(node-reject-goal-hst (getn h)))
	   (setf (get h 'h-goal) (caddar (node-reject-goal-hst (getn h))))
	   t)))

(defun def-top-level-fails (h n)
    (is-top-level-node (getn h)))


(defun def-goal-fails-due-to-goal-rejection (h n g)
  (prog ()
	(cond ((not-top-level-node (getn h)) (return))
	      ((not (node-reject-goal-hst (getn h))) (return))
	      ((eq (car *RULE-STACK*) 'def-top-level-fails)
	       (setf (get h 'h-goal)
		     (elt (alt-unmatched-conds (node-generating-alt (getn h)))
			  (which-elem g (get h 'generalized-goal-formulii))))))
	(return
	 (g-loop (init records (node-reject-goal-hst (getn h)) record nil
		       h-goal (get h 'h-goal))
		 (while (setq record (pop records)))
		 (do (cond ((equal h-goal
				   (caddr record))
			    (return t))))))))
	  
    

; each record = (rule bindings op)

; should use mult-vals, but...
(defun def-goal-fails-after-op-selection (h n g)
  (cond ((eq (car *RULE-STACK*) 'def-top-level-fails)
	 (setf (get h 'h-goal)
	       (elt (alt-unmatched-conds (node-generating-alt (getn h)))
		    (which-elem g (get h 'generalized-goal-formulii))))))
  (g-loop (init records (node-select-op-hst (getn h)) record nil
		h-goal (get h 'h-goal))
	  (while (setq record (pop records)))
	  (do (cond ((equal h-goal
			    (subst-bindings 
			     (get-nth-from-sig-for-ebs 3 (car record))
			     (cadr record)))
		     (setf (get h 'h-op) (caddr record))
		     (setf (get h 'op-select-record) record)
		     (return t))))))


(defun def-all-ops-failed (h n g)
  (cond ((eq (car *RULE-STACK*) 'def-top-level-fails)
	 (setf (get h 'h-goal)
	       (elt (alt-unmatched-conds (node-generating-alt (getn h)))
		    (which-elem g (get h 'generalized-goal-formulii))))))
  t)

; each record = (rule bindings op)
(defun def-op-fails-from-scr-rejection (h n g op)
    (let ((rej-hst (node-reject-op-hst (getn h))))
	 (and rej-hst
	      (g-loop (init rej-record nil)
		    (while (setq rej-record (pop rej-hst)))
		    (do (and (eq op (caddr rej-record))
			     ;  compare h-goal with goal when rule fired
			     (equal (get h 'h-goal)
				    (subst-bindings (get-nth-from-sig-for-ebs
						     3 (car rej-record))
					(cadr rej-record)))
			     (setf (get h 'op-reject-rule) (car rej-record))
			     (return t)))))))


; used when reset has no bvars, so we can take shortcut
;  it would be more efficient to go to the child history if possible
; I think this is oK, since it appears only necessary use one failed child

(defun def-cached-op-failed (h n g op)
  (and (is-variable op)(setq op (get h 'h-op)))
  (g-loop (init children (g-map (c in (get h 'children))
				(when (eq op (alt-op (node-generating-alt c))))
				(save c))
		child nil desc nil alt-forms nil alt-form nil r-alt-form nil)
	  (while (setq child (pop children)))
	  (do (and (was-proved-elsewhere `(fails ,child))
  	           (setq desc (te-to-desc (list 'fails child)))
		   (setq alt-forms (get-forms-from-exp 'alt-on-deck desc))
		   (not (get-forms-from-exp 'has-bound-vars desc))
		   (g-loop (while (setq alt-form (pop alt-forms)))
			   (do (setq r-alt-form
				     (singleton-realify alt-form h child
					(list (list alt-form alt-form))))
			       (and (equal (get h 'h-goal)
					   (caddr r-alt-form))
				    (eq op (cadddr r-alt-form))
				    (setf (get h 'alt-form) alt-form)
				    (return t))))
		   (setf (get h 'h-child) child)
		   (return t)))))
	      

(defun def-reset-op-fails-bro-deletion (h n g op)
    (and (not (eq op '*FINISH*)) 	; im confused so I put this in 
	 (node-bro-deletion-node (getn h))))

(defun def-reset-op-fails (h n g op)
    (get h 'reset-alt))

(defun def-op-fails (h n g op) t)


(defun def-not-relevent-failure (h n g add op)
	 (was-not-relevent h add (getn h)))

(defun def-unsuccessful (h n g add op)  
  (cond ((was-relevent h add (getn h))
	 (setf (get h 'applied-children)
	       (cons (list (list op add)
			   (g-map (c in (node-children (getn h)))
				  (when (node-applied-node c))
				  (save c)))
		     (get h 'applied-children))))))
	       
	       

(defun def-exp-or-application-failure (h exp b op add g dvars n)
    (and (not (eq t dvars))
	; all rhs-lhs vars are dvars
	 (null (ldiffq (get op 'all-rhs-lhs-vars) dvars))
	 (cadr (assoc (list op add) (get h 'applied-children)
		      :test #'equal))))

(defun def-exp-failure (h exp b op add g dvars n)
    (did-fail h exp op add (getn h)))

(defun def-lit-failure-not-same-bindings (h exp b op add g n)
  (and (eq (car (get h 'te)) 'bindings-fail)
       (not (was-subgoal-subnode h exp op add))))

(defun def-lit-inference-failure (h exp b op add g n)
    (cond ((and (negated-p exp)
                (not (closed-predicate (cadr exp)))
		(not (static-p (cadr exp))))
	   (put-mult-vals h 'def-lit-inference-failure 'fails 'h-child
	       (was-subgoal-subnode h exp op add))
	   t)	   
          ((and (not (negated-p exp))
		(not (closed-predicate exp))
		(not (static-p exp)))
	   (put-mult-vals h 'def-lit-inference-failure 'fails 'h-child
	       (was-subgoal-subnode h exp op add))
	   t)))

(defun def-lit-static-failure (h exp b op add g n)
	 (cond ((and (negated-p exp)
		     (static-p (cadr exp)))
		t)
	       ((and (not (negated-p exp))
		     (static-p exp))
	         t)))

 
; if all children are quick reset failures

(defun def-later-reset-subgoal-failure (h exp b op add g n)
    (and (g-loop (init children (was-subgoal-subnode h exp op add)
		     c nil)
	       (before-starting (and (null children) (return)))
	       (while (setq c (pop children)))
	       (do (cond ((not (was-proved-later-in-path (list 'fails c)))
			  (return))))
	       (result t))
	 (put-mult-vals h 'def-later-reset-subgoal-failure 'fails 'h-child
	     (was-subgoal-subnode h exp op add))
	 t))


(defun get-new-dvars (generator dvars)
    (g-map (v in generator)
	  (when (and (is-variable v)
		     (not (member v dvars))))
	  (save v)))

(defun def-lit-subgoal-failure (h exp b op add g n)
    (put-mult-vals h 'def-lit-subgoal-failure 'fails 'h-child
	(was-subgoal-subnode h exp op add))
    t)

(defun def-exists-and-failure (h vars gen exp bindings op add g dvars n)
    (and (not (eq dvars t))
	 (null (get-new-dvars (cdr gen) dvars))))

;  assuming both gen-exp and exp don't fail !
    
(defun def-null-or-failure (h exps b op add g dvars n)
    (null exps))

(defun def-or-failure (h exps b op add g dvars s)
    (not (null exps)))    

(defun def-application-fails (h add op r-bindings dvars g n)
    (cond ((eq (car (get h 'te)) 'bindings-fail)
	   (cond ((node-applied-node (get h 'the-child-with-bindings))
		  (put-mult-vals h 'def-application-fails 'fails 'h-child
		      (list (get h 'the-child-with-bindings)))
		  t)))
	  ((was-applicable h op add (getn h))
	   (put-mult-vals h 'def-application-fails 'fails 'h-child
	       (g-map (c in (get h 'children))
		     (when (and (node-applied-node c)
				(eq (alt-op (node-generating-alt c))
				    op)
				(eq add
				    (alt-post-cond 
					(node-generating-alt c)))))
		     (save c)))
	   t)))


(defun def-done-atomic-match (h b l1 l2)
    (and (null l1)(null l2)))

(defun def-atomic-match (h b l1 l2) t)


;--------------- SUCCEEDS STUFF --------------------------


(defun def-goal-succeeds (h n g op b)
    (setf (get h 'get-result-from-same-node) t))

(defun def-bindings-succeed (h n g op b)
    (setf (get h 'get-result-from-same-node) t))


(defun def-succeeds-with-post-goals (h n g op b)
    (and (get h 'top-level-succ-with-mult-goals)
	 (put-mult-vals h 'def-succeeds-with-post-goals 'member-add-list
	     'h-addition 
	     (list (let ((tmp1 
		       (node-generating-alt (node-success-child (getn h)))))
		     (if tmp1 (alt-post-cond tmp1)))))))

(defun def-directly-succeeds (h n g op b)
    (let ((c (get h 'h-child)))
	 (cond ((and (node-applied-node c)
		     (eq (get h 'h-applic-node) (getn h))
		     (eq (get h 'h-op) (alt-op (node-generating-alt c))))
		(put-mult-vals h 'def-directly-succeeds 'member-add-list
		    'h-addition (list (alt-post-cond (node-generating-alt c))))
		t))))

(defun def-subgoaling-succeeds (h n g op b)
    (not (node-applied-node (get h 'h-child))))

(defun def-precursor-succeeds (h n g op b)
    (put-mult-vals h 'def-precursor-succeeds 'member-add-list
	'h-addition (list (if (node-generating-alt (get h 'h-child)) (alt-post-cond (node-generating-alt (get h 'h-child))))))
    t)


; -------------------- UNIQUE ------------------------

;  sole-goal rules

(defun def-uniquely-succeeds-goal (h n u-g)
    (put-mult-vals h 'def-uniquely-succeeds-goal 'candidate-goal 'h-goal
	(if (node-generating-alt (getn h)) (alt-unmatched-conds (node-generating-alt (getn h)))))
    t)


; goal is always success goal
(defun def-is-u-goal (h n g u-g)
     (equal (get h 'h-goal) (get h 'u-goal)))


; should be no test...all goals should be cached...
(defun def-cached-goal-fails-for-unique (h n g u-g)
    t)
		 

; I don't think this should ever fire...

(defun def-regular-goal-fails-for-unique (h n g u-g)
    (error "not-imp"))

;  sole-op rules
; goal is always success goal
(defun def-is-u-op (h n g op u-op)
    (eq op (get h 'u-op)))

; h-goal should already be set...

(defun def-cached-op-fails-for-unique (h n g op u-op)
    (and (member op (node-op-level-failures (getn h)))
	 (progn (setf (get h 'h-op) op)
		t)))

; I don't think this should ever fire...

(defun def-regular-op-fails-for-unique (h n g op u-op)
    (progn (setf (get h 'h-op) op)
	   t))


; --------------------- GOAL INTERACTION -------------------


		

(defun def-goal-protection-interaction (h n)
   (node-protection-violation (getn h)))

(defun def-reset-interacts (h n)
    (cond ((and (get h 'reset-alt)
		(not (get h 'protection-violation))
		(not (get h 'protection-violation)))
	   (setf (get h 'h-goal)
		 (if (get h 'reset-alt) (alt-goal (get h 'reset-alt))))
	   (setf (get h 'h-op)
		 (if (get h 'reset-alt) (alt-op (get h 'reset-alt))))
	   t)))

; have to make sure h-goal is set, since the node may
; not have a last-goal (etc), since it may have
; been created by restarting. (When it is stopped
; by incr (eg. prereq viol), no goal info is stored...)
		

(defun def-interaction (h n) 
  (prog ()
	(cond ((or (get h 'reset-alt)
		   (is-top-level-node (getn h)))
	       (return nil)))
	(cond ((setf (get h 'h-goal)
		     (or (node-last-goal (getn h))
			 (node-current-goal (getn h)))))
	      ((get h 'prerequisite-violation)
	       (setf (get h 'h-goal) (node-prerequisite-violation (getn h)))))
	(return t)))


(defun def-interacts-after-goal-selection (h n)
    (cond ((and (is-top-level-node (getn h))
		(node-select-goal-hst (getn h)))
	   (setf (get h 'h-goal) (caddar (node-select-goal-hst (getn h))))
	   t)))

(defun def-top-level-interacts (h n)
    (is-top-level-node (getn h)))


(defun def-goal-top-level-prerequiste-violation (h n)
    (and (is-top-level-node (getn h))
	 (get h 'prerequisite-violation)
	 t))

(defun def-prerequisite-interaction (h n g)
    (cond ((get h 'prerequisite-violation) t)))


(defun def-goal-interacts-due-to-goal-rejection (h n g)
  (prog ()
	(cond ((not-top-level-node (getn h)) (return))
	      ((not (node-reject-goal-hst (getn h))) (return))
	      ((eq (car *RULE-STACK*) 'def-top-level-fails)
	       (setf (get h 'h-goal)
		     (elt (alt-unmatched-conds (node-generating-alt (getn h)))
			  (which-elem g (get h 'generalized-goal-formulii))))))
	(return
	 (g-loop (init records (node-reject-goal-hst (getn h)) record nil
		       h-goal (get h 'h-goal))
		 (while (setq record (pop records)))
		 (do (cond ((equal h-goal
				   (caddr record))
			    (return t))))))))

(defun def-goal-interacts-after-op-selection (h n g)
  (cond ((eq (car *RULE-STACK*) 'def-top-level-interacts)
	 (setf (get h 'h-goal)
	       (elt (alt-unmatched-conds (node-generating-alt (getn h)))
		    (which-elem g (get h 'generalized-goal-formulii))))))
  (g-loop (init records (node-select-op-hst (getn h)) record nil
		h-goal (get h 'h-goal))
	  (while (setq record (pop records)))
	  (do (cond ((equal h-goal
			    (subst-bindings 
			     (get-nth-from-sig-for-ebs 3 (car record))
			     (cadr record)))
		     (setf (get h 'h-op) (caddr record))
		     (setf (get h 'op-select-record) record)
		     (return t))))))
		  

(defun def-all-ops-interact (h n g)
    (cond ((eq (car *RULE-STACK*) 'def-top-level-interacts)
	   (setf (get h 'h-goal)
		 (elt (if
			   (node-generating-alt (getn h)) (alt-unmatched-conds
			   (node-generating-alt (getn h))))
		      (which-elem g (get h 'generalized-goal-formulii))))))
    t)

; each record = (rule bindings op)
(defun def-op-interacts-from-scr-rejection (h n g op)
    (let ((rej-hst (node-reject-op-hst (getn h))))
	 (and rej-hst
	      (g-loop (init rej-record nil)
		    (while (setq rej-record (pop rej-hst)))
		    (do (and (eq op (caddr rej-record))
			     ;  compare h-goal with goal when rule fired
			     (equal (get h 'h-goal)
				    (subst-bindings (get-nth-from-sig-for-ebs
						     3 (car rej-record))
					(cadr rej-record)))
			     (setf (get h 'op-reject-rule)
				   (car rej-record))
			     (return t)))))))


(defun def-cached-reset-interacts (h n g op)
    (and (is-variable op)(setq op (get h 'h-op)))
    (g-loop (init children (g-map (c in (get h 'children))
				(when (eq op (alt-op (node-generating-alt c))))
				(save c))
		child nil desc nil alt-forms nil alt-form nil r-alt-form nil)
	  (while (setq child (pop children)))
	  (do (and (was-proved-elsewhere `(interacts ,child))
  	           (setq desc (te-to-desc (list 'interacts child)))
		   (setq alt-forms (get-forms-from-exp 'alt-on-deck desc))
		   (not (get-forms-from-exp 'has-bound-vars desc))
		   (g-loop (while (setq alt-form (pop alt-forms)))
			 (do (setq r-alt-form
				   (singleton-realify alt-form h child
				       (list (list alt-form alt-form))))
			     (and (equal (get h 'h-goal)
					 (caddr r-alt-form))
				  (eq op (cadddr r-alt-form))
				  (setf (get h 'alt-form) alt-form)
				  (return t))))
		   (setf (get h 'h-child) child)
		   (return t)))))


(defun def-reset-op-interacts (h n g op)
    (get h 'reset-alt))

(defun def-op-interacts (h n g op) t)

(defun def-not-relevent-contributes-to-interaction (h n g add op)
        (was-not-relevent h add (getn h)))

(defun def-add-interacts (h n g add op)
    (cond ((was-relevent h add (getn h))
	   (setf (get h 'applied-children)
		 (cons (list (list op add)
			     (g-map (c in (node-children (getn h)))
				    (when (node-applied-node c))
				    (save c)))
		       (get h 'applied-children))))))
	       

(defun def-exp-or-application-interacts (h exp b op add g dvars n)
    (and (not (eq t dvars))
	; all rhs-lhs vars are dvars
	 (null (ldiffq (get op 'all-rhs-lhs-vars) dvars))
;	 (same-members dvars (get op 'all-rhs-lhs-vars))
	 (cadr (assoc (list op add) (get h 'applied-children)
		      :test #'equal))))



(defun def-exp-interacts (h exp b op add g dvars n)
    (did-fail h exp op add (getn h)))

(defun def-lit-interaction-not-same-bindings (h exp b op add g n)
  (and (eq (car (get h 'te)) 'bindings-interact)
       (not (was-subgoal-subnode h exp op add))))

(defun def-lit-inference-interaction (h exp b op add g n)
    (cond ((and (not (closed-literal exp))
		(not (static-p exp)))
	   (put-mult-vals h 'def-lit-inference-interaction 'interacts 'h-child
	       (was-subgoal-subnode h exp op add))
	   t)))

(defun def-lit-static-interaction (h exp b op add g n)
	 (cond ((static-p exp) t)))

(defun def-later-reset-subgoal-interaction (h exp b op add g n)
    (and (g-loop (init children (was-subgoal-subnode h exp op add)
		     c nil)
	       (before-starting (and (null children) (return)))
	       (while (setq c (pop children)))
	       (do (cond ((not (was-proved-later-in-path (list 'interacts c)))
			  (return))))
	       (result t))
	 (put-mult-vals h 'def-later-reset-subgoal-interaction 'interacts
			'h-child (was-subgoal-subnode h exp op add))
	 t))

(defun def-lit-subgoal-interaction (h exp b op add g n)
    (put-mult-vals h 'def-lit-subgoal-interaction 'interacts 'h-child
	(was-subgoal-subnode h exp op add))
    t)

(defun def-exists-and-interacts (h vars gen exp bindings op add g dvars n)
    (and (not (eq dvars t))
	 (null (get-new-dvars (cdr gen) dvars))))


;  assuming both gen-exp and exp don't fail !
    
(defun def-null-or-interacts (h exps b op add g dvars n)
    (null exps))

(defun def-or-interacts (h exps b op add g dvars s)
    (not (null exps)))    


(defun def-application-interacts (h add op r-bindings dvars g n)
    (cond ((eq (car (get h 'te)) 'bindings-interact)
	   (cond ((node-applied-node (get h 'the-child-with-bindings))
		  (put-mult-vals h 'def-application-interacts 'interacts 'h-child
		      (list (get h 'the-child-with-bindings)))
		  t)))
	  ((was-applicable h op add (getn h))
	   (put-mult-vals h 'def-application-interacts 'interacts 'h-child
	       (g-map (c in (get h 'children))
		     (when (and (node-applied-node c)
				(eq (alt-op (node-generating-alt c))
				    op)
				(eq add
				    (alt-post-cond 
					(node-generating-alt c)))))
		     (save c)))
	   t)))


