#|
*******************************************************************************
PRODIGY/EBL Module Version 2.0  
Copyright 1989 by Steven Minton.

The PRODIGY/EBL module was designed and built by Steven Minton. Thanks
to Jaime Carbonell and Craig Knoblock for their helpful advice. Andy
Philips contributed to the version 2.0 modifications.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map")
	(load-path *PLANNER-PATH* "data-types")
	(load-path *EBL-PATH*     "ebl-data-types"))

;  stuff especially for inter description compression

; just use savings from d1, since its easier..
(defun inter-compress (d1 d1-sig d1-bindings te match-time est-savings h)
    (g-loop (init rules (or (eval (rule-type-to-rule-lst 
				(get (car d1-sig) 'rule-type)))
			  (return))
		rule nil d1-eqs (get-top-level-eqs d1) comb-match-time nil
		d2 nil d2-sig nil combined-exp nil stop nil)
	  (while (setq rule (car (pop rules))))
	  (do (setq d2 (get rule 'lhs-for-ebs))
	      (setq d2-sig (get rule 'unique-sig))
	      (cond ((null (get rule 'was-learned)))
		    ((quick-inter-test d1-eqs d1 d2 d1-sig d2-sig)
		     (format t "~%Attempting inter-compress with ~a" rule)
		     (setq combined-exp 
			   (full-inter-compress d1 d2 d1-sig d2-sig))
		     (and combined-exp
			 (setq comb-match-time
			      (passes-inter-test combined-exp
				d1-bindings (cadr te))))
		     (cond ((equal combined-exp d1)
			    (format t "~%no change in exp"))
			   ((null combined-exp)
			    (format t "~%Expression reduced to Nil -- hmmm"))			    
			   ((and (not (eq t combined-exp))
				 (eq (car combined-exp) 'or))
			    (format t "~%Absolutely no reduction achieved"))
			   ((null comb-match-time)
			    (format t "~%combined-exp does not match"))
			   ((and (< comb-match-time (1+ match-time))
				 (< (count-atomics combined-exp)
					(count-atomics d1)))
			    (format t "~%PASSES inter-test! ~a ~a" comb-match-time match-time)
			    (format t "~%D1: ")
			    (pprint d1)
			    (format t "~%Combined-exp: ")
			    (pprint combined-exp)
			    (make-learned-rule-from-inter combined-exp d1-sig te 
				comb-match-time est-savings h rule)
			    (setq stop nil)) 
			   (t (format t "~%FAILS inter-test! ~a ~a" comb-match-time match-time))))))
	  (until stop))) 	; for the hell of it, why do more than one?


(defun make-learned-rule-from-inter (combined-exp d1-sig te comb-match-time
					est-savings hst rule)
    (let ((h (make-inter-hist (cadr te) hst)))
	 (setf (get h 'te) te)
	 (setf (get h 'est-cost) comb-match-time)
	 (setf (get h 'est-savings) est-savings)
	 (setf (get (make-learned-scr-rule h d1-sig
		      combined-exp) 'compressed-with-rule)
	     rule )))


(defun full-inter-compress (d1 d2 d1-sig d2-sig)
    (prog (combined1 combined2 combined3 combined4 new-is-equals)
	  (setq new-is-equals 
		(g-map (pair in (append (conv-metas-to-eqs d1 d2)
				       (get-top-level-eqs d1)
				       (get-top-level-eqs d2)))
		     ; get rid of obvious equals
		      (when (not (eq (car pair)(cadr pair))))
		      (save (cons 'is-equal pair))))
	  (cond (new-is-equals
		    (setq combined1 ; should be append1. (It was in franz).
			  (cons 'and (append new-is-equals 
					 (list
					  (list 'or d1
					       (subst-bindings d2 
						   (make-pairs (cdr d2-sig) (cdr  d1-sig)))))))))
		(t (setq combined1
			 (list 'or d1
			       (subst-bindings d2 
				   (make-pairs (cdr d2-sig) (cdr  d1-sig)))))))
	  (setq combined2 
		(inner-simplify combined1 `((or (not ,d1-sig) ,combined1))))
	  (and combined2
	       (setq combined3 (top-level-tp combined2 `((or (not ,d1-sig) ,combined2)))))
	  (cond ((null combined3) (return))
		((and (listp combined3)
		      (eq (car combined3) 'or))
		 (return combined3))
		(t (setq combined4 
			 (reorder-exp-for-match combined3 (cdr d1-sig)))
		   (return combined4)))))

    
; returns time or nil if exp does not match

(defun passes-inter-test (exp d1-bindings n)
    (let (time1 time2 new-match-time)
	 (and exp
	      (or (eq t exp)
		  (not (eq 'or (car exp))))
	      (setq time1 (get-internal-run-time))
	      (cond ((exp-match exp d1-bindings (node-state n))
		     (setq time2 (get-internal-run-time))
		     (setq new-match-time (- time2 time1))
		     new-match-time)
		    (t  nil)))))

				       

; what else to test besides primary-candidate-goal. Give up
; if has top-level-goals?

(defun quick-inter-test (d1-top-level-eqs d1 d2 d1-sig d2-sig)
    (and (meta-matches 
	     (find-top-exp 'primary-candidate-goal d1)
	     (find-top-exp 'primary-candidate-goal d2))
	(meta-matches 
	     (find-top-exp 'is-top-level-goal d1)
	     (find-top-exp 'is-top-level-goal d2))
	 (eqs-all-consistent 
	     (nconc (make-pairs (cdr d1-sig) (cdr d2-sig))
		    (conv-metas-to-eqs d1 d2)
		    (get-top-level-eqs d2)
		    d1-top-level-eqs))))

; returns eqs with d2 first.
; should'nt be wrong with is-top-level-goal, but stronger result.

(defun conv-metas-to-eqs (d1 d2)
    (cond ((or (find-subexp 'primary-candidate-goal d1)
	       (find-subexp 'is-top-level-goal d1))
	   (append
		  (make-pairs 
		      (caddr (find-top-exp 'is-top-level-goal d2))
		      (caddr (find-top-exp 'is-top-level-goal d1)))
		  (make-pairs 
		      (caddr (find-top-exp 'primary-candidate-goal d2))
		      (caddr (find-top-exp 'primary-candidate-goal d1)))))))


(defun get-top-level-eqs (desc)
    (cond ((eq (car desc) 'and)
	   (g-loop (init ret-val nil)
		 (next desc (cdr desc))
		 (while desc)
		 (do (and (eq (caar desc) 'is-equal)
			  (push (cdar desc) ret-val)))
		 (result ret-val)))))

    
	     
 ; uses find-unifiers, which returns ((is-equal <a> <b>)...)

(defun eqs-all-consistent (eqs)
    (g-loop (init eq-vars nil)
	  (while (setq eq-vars (pop eqs)))
	  (do (cond ((is-variable (car eq-vars))
		     (setq eqs (subst (cadr eq-vars)(car eq-vars)
				      eqs)))
		    ((is-variable (cadr eq-vars))
		     (setq eqs (subst (car eq-vars)(cadr eq-vars)
				      eqs)))
		    ((eq (car eq-vars)(cadr eq-vars)))
		    ((and (not (atom (car eq-vars)))
			  (not (atom (cadr eq-vars)))
			  (let ((new-is-eqs
				    (find-unifiers (car eq-vars)
					(cadr eq-vars))))
			       (cond ((null new-is-eqs) nil)
				     ((eq t new-is-eqs) t)
				     (t (setq eqs (append (mapcar #'cdr new-is-eqs) 
							  eqs)))))))
		    ((return))))
	  (result t)))
			 





(defun find-top-exp (exp-pred d1)
    (cond ((eq (car d1) exp-pred) d1)
	  ((eq (car d1) 'and)
	   (find-subexp exp-pred d1))))


; assume meta1 and meta2 have same pred, or are nil
; nodes, etc, set equal

(defun meta-matches (meta1 meta2)
    (cond ((or (null meta1)
	       (null meta2))
	   (and (null meta1) (null meta2)))
	  ((eq (car meta1) 'current-goal)
	   (and (eq (caaddr meta1)(caaddr meta2))))
	  ((eq (car meta1) 'primary-candidate-goal)
	   (and (eq (caaddr meta1)(caaddr meta2))))
	  (t t)))



(defun count-atomics (exp)
   (cond ((atom exp) 0)
	 ((atomic-formula-p exp) 1)
	 ((member (car exp) '(exists forall))
	  (+ (count-atomics (get-gen-exp exp))
	       (count-atomics (get-exp exp))))
	 ((member (car exp) '(and or))
	  (g-loop (init count 0)
		(next exp (cdr exp))
		(while exp)
		(do (setq count (+ (count-atomics (car exp))
				   count)))
		(result count)))
	 ((negated-p exp) (count-atomics (cadr exp)))
	 ((error "count-atomics, bad exp type"))))
		
			  
	 
	  
