;;;
;;;
(proclaim '(special *AXIOMS* *HIERARCHY* *ABS-HIERARCHY* *GROUP-GRAPH* 
		    *STATIC* *OPS* *CONTEXT-ARRAY* *CONSTRAINTS*
		    *ABS-PRINT-FLAG* *PRIMARY* *INS-TYPES* 
		    *VARIABLE-EXPANSION* *LEARNED-RULES-IN-SYS*))
;;;
;;; A formula is a ground level predicate that occurs as a precondition or 
;;; effect of an operator.

;;;(defstruct (formula (:print-function (lambda (formula stream level)
;;;				       (declare (ignore stream level))
;;;				       (format stream "#S~a" 
;;;                                            (formula-type formula)))))
;;;  instance    ; e.g., (in-room block1 room5)
;;;  type        ; e.g., (in-room block room)
;;;  predeladd   ; one of 'precond, 'add, 'del
;;;  status      ; one of 'primary or 'secondary
;;;  operator)   ; name of the operator

;;;=============================================================================

;;; Takes prodigy goal expresion and augments it with any other goals
;;; that necessarily hold.  In addition it sets up the information in
;;; the context-array based on the goal to be solved and then calls
;;; the functions for creating the abstraction hierarchy.  This stuff
;;; assumes that an initial partial order has already been created
;;; using (create-abstraction) and then this function refines it into
;;; a hierarchy based on the goal.  The partial order should be in
;;; *GROUP-GRAPH*.  The final partial order is in *HIERARCHY*, and the
;;; entire set of constraints on the problem is in *CONSTRAINTS*.  The
;;; final result will be in *ABS-HIERARCHY*.

(defun build-hierarchy (goal)
  (let ((aug-goal (augment-goal-exp goal t)))
    (load-abstract-goal aug-goal)
    (compute-type-information '(*finish*) 0 nil nil)
    (clear-context-array *context-array*)
    (fill-in-context-array *ins-types* '(*finish*) *ops* *context-array*)
    (create-abstraction-hierarchy *context-array* 
				  (if *VARIABLE-EXPANSION* 
				      (exp-match-failures aug-goal
							  '((nil nil)))
				    (simplify-exp aug-goal)))
    (partition-control-rules *ABS-HIERARCHY*)
    aug-goal))

;;; Top level function that refines the initial partial order into an
;;; abstraction hierarchy that is monotonic for a conjunction of
;;; goals.  It first adds the precondition constraints from the
;;; context array.  Then it deletes any unreachable groups and
;;; combines the remaining strongly connected components.  Finally, it
;;; uses the resulting partial order of monotonic abstraction space to
;;; create a final abstraction space.

(defun create-abstraction-hierarchy (context-array goal-list)
  (setq *HIERARCHY* (find-constraints context-array goal-list *GROUP-GRAPH*))
;  (setq *HIERARCHY* (copy-array *GROUP-GRAPH*))
  (setq *CONSTRAINTS* (copy-array *HIERARCHY*))
  (combine-strong-components *HIERARCHY*)
;  (setq *COMPONENTS* (copy-array *HIERARCHY*))
  (order-hierarchy *HIERARCHY* goal-list)
  (create-actual-hierarchy *HIERARCHY*))

(defun create-actual-hierarchy (hierarchy)
  (cond (*ABS-PRINT-FLAG* 
	 (format t "~%~%Abstraction Hierarchy: ~%~%")
	 (print-row hierarchy 0)))
  (create-abs-hierarchy hierarchy 
			(setq *ABS-HIERARCHY* 
			      (make-array (list 2 (array-dimension
						   hierarchy 0))))
			(1- (array-dimension hierarchy 0))
			(array-dimension hierarchy 0)))

(defun print-constraints (graph)
  (initialize-unvisited graph (1- (array-dimension graph 0)))
  graph)


;;;
;;; Initialize the part of the context array that is problem specific.

(defun clear-context-array (context-array)
  (do ((x (1- (array-dimension context-array 0))(1- x)))
      ((zerop x))
    (do ((y (1- (array-dimension context-array 1))(1- y)))
	((zerop y))
      (if (eql x 1)(setf (aref context-array x y 0) nil))
      (setf (aref context-array x y 1) nil))))

;;;
;;;
;;;
;;; Recurses through the goal expression augmenting each subgoal.
;;;
(defun augment-goal-exp (goal-exp &optional (ground nil))
  (cond ((null goal-exp) nil)
	((member (car goal-exp) '(forall exists)) goal-exp)
	((eq 'or (car goal-exp))
	 (cons (car goal-exp)(augment-or-exp (cdr goal-exp) ground)))
	((eq 'and (car goal-exp))
	 (cons (car goal-exp)(augment-and-exp (cdr goal-exp)
					      (cdr goal-exp) ground)))
	(t (let ((augmentations (augment-goal goal-exp *AXIOMS* nil ground)))
	     (cond ((null augmentations) goal-exp)
		   (t (cons 'and (cons goal-exp augmentations))))))))

(defun augment-or-exp (or-exp ground)
  (cond ((null or-exp) nil)
	((member (caar or-exp) '(forall exists and or))
	 (cons (augment-goal-exp (car or-exp) ground)
	       (augment-or-exp (cdr or-exp) ground)))
	(t 
	 (let ((augmentations (augment-goal (car or-exp) *AXIOMS* nil ground)))
	   (cond ((null augmentations)
		  (cons (car or-exp)
			(augment-or-exp (cdr or-exp) ground)))
		 (t (cons (cons 'and (cons (car or-exp) augmentations))
			  (augment-or-exp (cdr or-exp) ground))))))))

(defun augment-and-exp (and-exp exp-list ground)
  (cond ((null and-exp) nil)
	((member (caar and-exp) '(forall exists and or))
	 (cons (augment-goal-exp (car and-exp) ground)
	       (augment-and-exp (cdr and-exp) exp-list ground)))
	(t (let ((augmentations (augment-goal (car and-exp) *AXIOMS* exp-list
					      ground)))
	     (cons (car and-exp)
		   (augment-and-exp (append augmentations (cdr and-exp))
				    (append exp-list augmentations)
				    ground))))))
				
;;; Takes the given goal and negates it.

(defun negate-goal (goal)
  (cond ((eq '~ (car goal))(cadr goal))
	(t (list '~ goal))))

;;; 
;;;
;;;
;;; Recurses through the axioms to see if any match and can thus be
;;; used for augmentation.  The exp-list is the context in which the
;;; exp occurs.  Thus, any augmentation is matched against this list
;;; to avoid repetition and to ensure proper variable bindings.
;;;

(defun augment-goal (exp axioms exp-list &optional (ground nil))
  (cond ((null axioms) nil)
	((let ((new-blsts (match (list (car (first axioms))) (list exp) 
				 '(((nil))) (extract-vars exp))))
	   (cond ((not (null new-blsts))
		  (augment-exp-list exp-list (cdr (first axioms)) 
				    nil new-blsts ground)))))
	(t (augment-goal exp (cdr axioms) exp-list ground))))


(defun augment-exp-list (exp-list augmentation unmatched-aug blsts ground)
  (cond ((null augmentation)
	 (if ground
	     (remove-var-lits (reverse (sublis (car blsts) unmatched-aug)))
	   (reverse (sublis (car blsts) unmatched-aug))))
	(t (let ((new-blsts (match (list (car augmentation)) exp-list 
				   blsts (extract-vars exp-list))))
 	     (cond ((null new-blsts)
		    (augment-exp-list exp-list (cdr augmentation)
				      (cons (car augmentation) unmatched-aug)
				      blsts ground))
		   (t (augment-exp-list exp-list (cdr augmentation)
					unmatched-aug new-blsts ground)))))))

(defun remove-var-lits (lits)
   (cond ((null lits) nil)
	 ((and (has-vars (car lits))
	       (not (member (caar lits) *static-preds*)))
	  (remove-var-lits (cdr lits)))
	 (t (cons (car lits)(remove-var-lits (cdr lits))))))

	
;;;
;;;
;;;
;;; Takes the abstraction hierarchy in *HIERARCHY* and converts it into 
;;; the form actually used by the planning.  That is, an array containing
;;; the typed predicates that should be considered at each level of abstraction.
;;; At the lowest level, level 1, this is all the predicates, and at the highest
;;; level it only considers the static predicate.  
;;;
(defun create-abs-hierarchy (hierarchy abs-hierarchy index size)
  (cond ((zerop index))
	((eql index (1- size))
	 (setf (aref abs-hierarchy 0 index)
	       (cons '(done)
		     (append (augment-with-instances *STATIC*)
			     (augment-with-types 
			      (aref hierarchy 0 (- size index))))))
         (setf (aref abs-hierarchy 1 index)
                     (aref hierarchy 0 (- size index)))
;	 (setf (aref abs-hierarchy 2 index)
;	       (determine-relevant-ops (aref abs-hierarchy 0 index) *PRIMARY*))
	 (create-abs-hierarchy hierarchy abs-hierarchy (1- index) size))
	(t 
	 (setf (aref abs-hierarchy 0 index)
	       (augment-with-types (append (aref abs-hierarchy 0 (1+ index))
					   (aref hierarchy 0 (- size index)))))
	 (setf (aref abs-hierarchy 1 index)
	       (aref hierarchy 0 (- size index)))
;	 (setf (aref abs-hierarchy 2 index)
;	       (determine-relevant-ops (aref abs-hierarchy 0 index) *PRIMARY*))
	 (create-abs-hierarchy hierarchy abs-hierarchy (1- index) size))))

(defun augment-with-instances (lits)
  (if (not *VARIABLE-EXPANSION*) lits
    (expand-nonstatic lits lits)))


(defun expand-nonstatic (lits lit-list)
  (cond ((null lits) lit-list)
	(t (let ((primary-ops
		  (assoc (car lits) *primary*
			 :test #'(lambda (x y)(match (list x)(list y)
						     '(((nil))))))))
	     (cond ((null primary-ops)
		    (expand-nonstatic (cdr lits) lit-list))
		   ((null (cdr primary-ops))
		    (expand-nonstatic 
		     (cdr lits)(append (generate-descendents (car lits) nil)
				       lit-list)))
		   (t (error "static lits are neither static nor unachievable")))))))

;;;
;;;
;;;
(defun augment-with-types (types )
  (if (not *VARIABLE-EXPANSION*) types
    (extract-all types types)))


(defun extract-all (types type-list)
  (cond ((null types) type-list)
	((member (extract (car types)) type-list :test #'equal)
	 (extract-all (cdr types) type-list))
	(t (extract-all (cdr types)
			(cons (extract (car types)) type-list)))))

;;;
;;;
;;;
(defun determine-relevant-ops (literals primary)
  (cond ((null primary) nil)
	((member (extract (caar primary)) literals :test #'equal)
	 (append (cdar primary)
		 (determine-relevant-ops literals (cdr primary))))
	(t (determine-relevant-ops literals (cdr primary)))))


(defun partition-control-rules (hierarchy)
  (dolist (rules '(*SCR-NODE-SELECT-RULES*  *SCR-GOAL-SELECT-RULES*  
		  *SCR-OP-SELECT-RULES*    *SCR-BINDINGS-SELECT-RULES*
		  *SCR-NODE-REJECT-RULES*  *SCR-GOAL-REJECT-RULES* 
		  *SCR-OP-REJECT-RULES*    *SCR-BINDINGS-REJECT-RULES* 
		  *SCR-NODE-PREFERENCE-RULES* *SCR-GOAL-PREFERENCE-RULES* 
		  *SCR-OP-PREFERENCE-RULES* *SCR-BINDINGS-PREFERENCE-RULES*
		  *LEARNED-RULES-IN-SYS*))
	  (dolist (rule (eval rules))
		  (let ((rule-nm (if (listp rule)(car rule) rule)))
		    (if (null (scr-goals rule-nm))
			(setf (scr-abs-level rule-nm) nil)
		      (setf (scr-abs-level rule-nm)
			    (determine-level (scr-goals rule-nm) 
					     hierarchy
					     (1- (array-dimension
						  hierarchy 1)))))))))

(defun determine-level (goals hierarchy level)
  (cond ((zerop level) t)
	((subsetp goals (aref hierarchy 0 level))
	 (aref hierarchy 0 level))
	(t (determine-level goals hierarchy (1- level)))))
