;;;
;;;
(proclaim '(special *NUMBER* *COMPONENTS*))
;;;
;;; A formula is a ground level predicate that occurs as a precondition or 
;;; effect of an operator.

;;;(defstruct (formula (:print-function (lambda (formula stream level)
;;;				       (declare (ignore stream level))
;;;				       (format stream "#S~a" 
;;;                                            (formula-type formula)))))
;;;  instance    ; e.g., (in-room block1 room5)
;;;  type        ; e.g., (in-room block room)
;;;  predeladd   ; one of 'precond, 'add, 'del
;;;  status      ; one of 'primary or 'secondary
;;;  operator)   ; name of the operator

;;;=============================================================================
;;;
;;;
;;;
;;; Combines a directed graph into its strongly connected components.
;;; Uses the algorithm described in Aho, Hopcroft, and Ullman Data
;;; Structures and Algorithms.
;;; 
(defun combine-strong-components (graph)
  (let ((new-graph (make-array (array-dimensions graph))))
    (number-graph graph)
    (reverse-arcs graph new-graph)
    (combine-components new-graph graph)
    (restore-labels graph (1- (array-dimension graph 0)))))

;;;
;;;
;;; Copies the labels for one axis to the other axis for display purposes.
;;;
(defun restore-labels (hierarchy index)
  (cond ((zerop index))
	(t (setf (aref hierarchy index 0)(aref hierarchy 0 index))
	   (setf (aref hierarchy index index) nil)
	   (restore-labels hierarchy (1- index)))))


;;;
;;;
;;;
;;; Numbers the elements in the graph using dfs.
;;;
(defun number-graph (graph)
  (setq *NUMBER* 1)
  (initialize-unvisited graph (1- (array-dimension graph 0)))
  (unvisited graph 1))
;;;
;;;
;;;
;;; Assigns a number to a particular element in the graph.
;;;
(defun assign-number (index graph)
  (setf (aref graph index 0) *NUMBER*)
  (setq *NUMBER* (1+ *NUMBER*)))
;;;
;;;
;;;
;;; Scans the graph for unvisited components and does a dfs on them.
;;;
(defun unvisited (graph index)
  (cond ((= index (array-dimension graph 0)) graph)
	((null (aref graph index 0))
	 (dfs index 0 graph nil)
	 (unvisited graph (1+ index)))
	(t (unvisited graph (1+ index)))))

;;;
;;;
;;;
;;; Performs a dfs starting with the given vertex on the give graph.
;;; The index should be called with 0 and the vertices with nil.  The
;;; vertices is used to collect the list of vertices searched.  The
;;; graph is numbered along the bottom row of the graph. 
;;;
(defun dfs (vertex index graph vertices)
  (cond ((zerop index)
	 (setf (aref graph vertex 0) 'visited)
	 (let ((result (dfs vertex 1 graph (cons vertex vertices))))
	   (assign-number vertex graph)
	   result))
	((= index (array-dimension graph 0)) vertices)
	(t (cond ((and (constraint-p graph vertex index)
		       (null (aref graph index 0)))
		  (dfs vertex (1+ index) graph 
		       (dfs index 0 graph vertices)))
	         (t (dfs vertex (1+ index) graph vertices))))))
;;;
;;;
;;;
;;; Copies and reverses all of the elements of graph into new-graph.
;;;
(defun reverse-arcs (graph new-graph)
  (do ((i 1 (1+ i)))
      ((= i (array-dimension graph 0)))
    (do ((j 1 (1+ j)))
	((= j (array-dimension graph 0)))
      (setf (aref new-graph j i)(aref graph i j)))))
;;;
;;;
;;;
;;; Determines the strongly connected components using highest-unvisited
;;; and strongs the result in *components*.  Then each of these components
;;; is combined into a single entry in the graph.
;;;
(defun combine-components (new-graph graph)
  (setq *COMPONENTS* nil)
  (setq *NUMBER* 1)
  (highest-unvisited new-graph graph 
		     (find-highest-unvisited new-graph graph 1 0))
  (initialize-unvisited graph (1- (array-dimension graph 0)))
  (combine-each-component graph *COMPONENTS* 
			  (create-map (1- (array-dimension graph 0))
					  (make-array (list (array-dimension 
							     graph 0))))))
;;;
;;;
;;;
;;; Creates an index map which maps each of the indexes of the strongly
;;; connected components into the actual index into the graph.  Remember
;;; that the indices are changing since the graph changes when two separate
;;; components are combined into one.
;;;
(defun create-map (index map)
  (cond ((zerop index) map)
	(t (setf (aref map index) index)
	   (create-map (1- index) map))))
;;;
;;;
;;;
;;; Combines the components in the graph.
;;;
(defun combine-each-component (graph components map)
  (cond ((null components) graph)
	(t (combine-component graph (sort (car components) #'<) map (cdr components)))))
;;;
;;;
;;;
;;; Combining a component involves both updating graph and updating
;;; the map.  The map is used to map a component number into an index in
;;; the graph.  
;;;
(defun combine-component (graph component map remaining-components)
  (cond ((or (null component)(eql 1 (length component)))
	 (combine-each-component graph remaining-components map))
	(t (let ((index1 (aref map (car component))) 
		 (index2 (aref map (cadr component))))
	     (combine-interacting-groups (min index1 index2)
					 (max index1 index2)
					 graph)
	     (combine-component graph (cdr component) 
				(update-map map 
						(min (car component)
						     (cadr component))
						(max (car component)
						     (cadr component)))
				remaining-components)))))
;;;
;;;
;;;
;;; The map is updated by copying the value of num1 into num2 and then
;;; decrementing all of the indices following num2.
;;;
(defun update-map (map num1 num2)
  (let ((x-dim (array-dimension map 0)))
    (setf (aref map num2)(aref map num1))
    (do ((x (1+ num2)(1+ x)))
	((= x x-dim) map)
      (setf (aref map x)(1- (aref map x))))))
;;;
;;;
;;;
;;; Find the highest numbered unvisited component and records it.
;;;
(defun highest-unvisited (new-graph graph index)
  (cond ((zerop index) new-graph)
	(t (record-component (dfs index 0 new-graph nil))
	   (highest-unvisited new-graph graph 
			      (find-highest-unvisited new-graph graph 1 0)))))
;;;
(defun find-highest-unvisited (new-graph graph index highest)
  (cond ((= index (array-dimension graph 0)) highest)
	((and (null (aref new-graph index 0))
	      (zerop highest))
	 (find-highest-unvisited new-graph graph (1+ index) index))
	((and (null (aref new-graph index 0))
	      (> (aref graph index 0) (aref graph highest 0)))
	 (find-highest-unvisited new-graph graph (1+ index) index))
	(t (find-highest-unvisited new-graph graph (1+ index) highest))))
;;;
(defun record-component (component)
  (push component *COMPONENTS*))


;;; The code below is used to remove all the unreachable groups and 
;;; also uses the DFS code.
;;;
;;;
;;; Takes the directed graph and a list of the rows which correspond
;;; to the top level goals and determines if any of the nodes in the graph
;;; are unreachable.  If they are unreachable, they are deleted.
;;;
(defun delete-unreachable-groups (hierarchy goal-rows)
  (initialize-unvisited hierarchy (1- (array-dimension hierarchy 0)))
  (setq *NUMBER* 1)
  (delete-unvisited-groups hierarchy 
			   (unvisited-nodes (dfs-list hierarchy goal-rows)
					    (1- (array-dimension hierarchy 
								 0)))))
;;;
;;;
;;;
;;; Does a depth-first search on each of the goal-rows.
;;;
(defun dfs-list (hierarchy goal-rows)
  (cond ((null goal-rows) hierarchy)
	(t (dfs (car goal-rows) 0 hierarchy nil)
	   (dfs-list hierarchy (cdr goal-rows)))))
;;;
;;;
;;;
;;; Finds all the unvisited nodes after performing the dfs.
;;;
(defun unvisited-nodes (graph index)
  (cond ((zerop index) nil)
	((not (null (aref graph index 0)))
	 (unvisited-nodes graph (1- index)))
	(t (cons index (unvisited-nodes graph (1- index))))))
;;;
;;;
;;;
;;; Initialize the graph to indicate that none of the nodes have been visited.
;;;
(defun initialize-unvisited (graph index)
  (cond ((zerop index) graph)
	(t (setf (aref graph index 0) nil)
	   (initialize-unvisited graph (1- index)))))
;;;
;;;
;;;
;;; Takes the list of unvisited nodes and combines them with the top-level node.
;;;
;(defun combine-unvisited-groups (hierarchy unvisited-groups)
;  (cond ((null unvisited-groups) hierarchy)
;	(t (combine-interacting-groups 1 (car unvisited-groups) hierarchy)
;	   (combine-unvisited-groups hierarchy (cdr unvisited-groups)))))
;;;
;;;
;;;
;;; Takes the list of unvisited nodes and deletes them.
;;;
(defun delete-unvisited-groups (hierarchy unvisited-groups)
  (cond ((null unvisited-groups) hierarchy)
	(t (delete-group (car unvisited-groups) hierarchy)
	   (delete-unvisited-groups hierarchy (cdr unvisited-groups)))))

