
(defun find-field (op field)
  (cond ((null op) nil)
	((atom (car op))
	 (find-field (cdr op) field))
	((eq field (caar op))
	 (cadar op))
	(t (find-field (cdr op) field))))

(defun preconds (op)
  (let ((pre (find-field op 'preconds)))
    (cond ((eq 'and (car pre))
	   (cdr pre))
	  (t (list pre)))))

(defun effects (op)
  (effects2 (find-field op 'effects)))

(defun effects2 (effects)
  (cond ((null effects) nil)
	((eq 'del (caar effects))
	 (cons (list '~ (cadar effects))
	       (effects2 (cdr effects))))
	((eq 'add (caar effects))
	 (cons (cadar effects)
	       (effects2 (cdr effects))))
	(t (error "Neither an add or delete!"))))

(defun all-lits (ops)
  (cond ((null ops) nil)
	(t (append (preconds (car ops))
		   (append (effects (car ops))
			   (all-lits (cdr ops)))))))

(defun literals (ops)
  (remove-duplicates (all-lits ops)
		     :test #'equal))



(defun find-constraints (ops)
  (find-constraints-on-ops ops (build-array (literals ops))))

(defun build-array (literals)
  (let ((graph (make-array (list (1+ (length literals))
				 (1+ (length literals)))
			   :initial-element nil)))
    (place-literals-in-array graph literals 1)))

(defun place-literals-in-array (graph literals index)
  (cond ((null literals) graph)
	(t (setf (aref graph 0 index) (car literals))
	   (place-literals-in-array graph (cdr literals) (1+ index)))))

(defun find-constraints-on-ops (ops graph)
  (cond ((null ops) graph)
	(t (find-constraints-on-op (car ops) (effects (car ops)) graph)
	   (find-constraints-on-ops (cdr ops) graph))))

(defun find-constraints-on-op (op effects graph)
  (cond ((null effects) nil)
	(t (constrain-lits (car effects)(effects op) graph)
	   (constrain-lits (car effects)(preconds op) graph)
	   (find-constraints-on-op op (cdr effects) graph))))

(defun constrain-lits (effect lits graph) 
  (cond ((null lits) nil)
	(t (constrain effect (car lits) graph)
	   (constrain-lits effect (cdr lits) graph))))

(defun constrain (lit1 lit2 graph)
  (setf (aref graph (find-lit lit1 graph 1)(find-lit lit2 graph 1)) t))
  

(defun find-lit (lit graph index)
  (cond ((= index (car (array-dimensions graph)))
	 (error "lit not found in array"))
	((equal lit (aref graph 0 index)) index)
	(t (find-lit lit graph (1+ index)))))

(defun find-strong-components (ops)
  (let ((graph (find-constraints ops))
	(new-graph (build-array (literals ops))))
    (number-graph graph)
    (reverse-arcs graph new-graph)
    (assign-components new-graph graph)
;    (combine-groups graph groups)))
))

(defun graph-size (graph)
  (car (array-dimensions graph)))


(defun reverse-arcs (graph new-graph)
  (do ((i 1 (1+ i)))
      ((= i (graph-size graph)))
    (do ((j 1 (1+ j)))
	((= j (graph-size graph)))
      (setf (aref new-graph j i)(aref graph i j)))))

(defun number-graph (graph)
  (setq NUMBER 1)
  (unvisited graph 1))

(defun unvisited (graph index)
  (cond ((= index (car (array-dimensions graph))) graph)
	((null (aref graph index 0))
	 (dfs index graph)
	 (assign-number index graph)
	 (unvisited graph (1+ index)))
	(t (unvisited graph (1+ index)))))

(defun dfs (vertex graph)
  (setf (aref graph vertex 0) 'visited)
  (dfs-vertex-list vertex 1 graph))

(defun dfs-vertex-list (vertex index graph)
  (cond ((= index (array-dimension graph 0)) graph)
	(t (cond ((and (aref graph index vertex)
		    (null (aref graph index 0)))
		  (dfs index graph)
		  (assign-number index graph)
		  (setq GROUP (cons index GROUP))))
	   (dfs-vertex-list vertex (1+ index) graph))))

(defun assign-number (index graph)
  (setf (aref graph index 0) NUMBER)
  (setq NUMBER (1+ NUMBER)))


(defun assign-components (new-graph graph)
  (setq GROUP nil)
  (setq GROUPS nil)
  (setq NUMBER 1)
  (highest-unvisited new-graph graph (find-highest-unvisited new-graph graph)))

(defun highest-unvisited (new-graph graph index)
  (cond ((zerop index) new-graph)
	(t (dfs index new-graph)
	   (assign-number index new-graph)
	   (setq GROUP (cons index GROUP))
	   (setq GROUPS (cons GROUP GROUPS))
	   (setq GROUP nil)
	   (highest-unvisited new-graph graph 
			      (find-highest-unvisited new-graph graph)))))

(defun find-highest-unvisited (new-graph graph)
  (find-highest new-graph graph 1 0))

(defun find-highest (new-graph graph index highest)
  (cond ((= index (graph-size graph)) highest)
	((and (null (aref new-graph index 0))
	      (zerop highest))
	 (find-highest new-graph graph (1+ index) index))
	((and (null (aref new-graph index 0))
	      (> (aref graph index 0) (aref graph highest 0)))
	 (find-highest new-graph graph (1+ index) index))
	(t (find-highest new-graph graph (1+ index) highest))))

	 
