(setq *msg-flag* nil)
(setq *grid-flag* nil)

;;Roommap and modification to realgraph for making initial states for thesis.
;;The problems are in their respective problem directories.
;;; Room map for standard strips domain.


(defun calc-window-dependents (width height char-width scale)
   "Calculates all of the window size dependent factors of the domain
    window."
  (setf	*DOMAIN-HEIGHT* height
	*DOMAIN-WIDTH* width
	*ORGIN-Y* (truncate *DOMAIN-HEIGHT* (/ .925))
	*ORGIN-X* (truncate *DOMAIN-WIDTH* (/ .075))
	*SUB-HEIGHT* (truncate *DOMAIN-HEIGHT* (/ .95))
	*SUB-WIDTH* (truncate *DOMAIN-WIDTH* (/ .95))
	*RESOL-X* (truncate *SUB-WIDTH* *X-DIM*)
	*RESOL-Y* (truncate *SUB-HEIGHT* *Y-DIM*)
	*HALF-RES-X* (truncate *RESOL-X* 2)
	*HALF-RES-Y* (truncate *RESOL-Y* 2)
	*VECTOR-X* (initialize-vector *X-DIM* *RESOL-X* *ORGIN-X*)
	*VECTOR-Y* (initialize-vector *Y-DIM* (- *RESOL-Y*) *ORGIN-Y*)
	*CHARS-IN-OBJECT* (truncate (1- (* *HALF-RES-X* scale 2)) 
								char-width)
))    

(setq *X-DIM* 12)
(setq *Y-DIM* 10)
(setq *Z-DIM* 0)

(setq *ROOMS* (list	(list 	(make-location :room 'room7 :x 9 :y 0 :z 0)
				(make-location :room 'room7 :x 11 :y 3 :z 0))
			(list 	(make-location :room 'room6 :x 4 :y 0 :z 0)
				(make-location :room 'room6 :x 8 :y 3 :z 0))
			(list 	(make-location :room 'room5 :x 2 :y 0 :z 0)
				(make-location :room 'room5 :x 3 :y 3 :z 0))
			(list 	(make-location :room 'room1 :x 0 :y 4 :z 0)
				(make-location :room 'room1 :x 1 :y 9 :z 0))
			(list 	(make-location :room 'room2 :x 2 :y 4 :z 0)
				(make-location :room 'room2 :x 5 :y 9 :z 0))
			(list 	(make-location :room 'room4 :x 9 :y 4 :z 0)
				(make-location :room 'room4 :x 11 :y 9 :z 0))
			(list 	(make-location :room 'room3 :x 6 :y 4 :z 0)
				(make-location :room 'room3 :x 8 :y 9 :z 0))
	      ))

(setq *ROBOT-POS* (list
			(make-location :room 'room7 :x 9 :y 3 :z 0)
			(make-location :room 'room4 :x 9 :y 9 :z 0)
			(make-location :room 'room3 :x 6 :y 9 :z 0)
			(make-location :room 'room6 :x 4 :y 3 :z 0)
			(make-location :room 'room2 :x 3 :y 6 :z 0)
			(make-location :room 'room5 :x 2 :y 2 :z 0)
			(make-location :room 'room1 :x 0 :y 9 :z 0)
		  )
)

(setq *DOORS* 
	(list 
	   (make-door	:name 'door67
			:loc1 (make-location :room 'room7 :x 9 :y 1  :z 0)
			:loc2 (make-location :room 'room6 :x 8 :y 1 :z 0))
	   (make-door	:name 'door26
			:loc1 (make-location :room 'room2 :x 5 :y 4 :z 0)
			:loc2 (make-location :room 'room6 :x 5 :y 3 :z 0))
	   (make-door	:name 'door56
			:loc1 (make-location :room 'room6 :x 4 :y 1 :z 0)
			:loc2 (make-location :room 'room5 :x 3 :y 1 :z 0))
	   (make-door	:name 'door25
			:loc1 (make-location :room 'room5 :x 3 :y 3 :z 0)
			:loc2 (make-location :room 'room2 :x 3 :y 4 :z 0))
	   (make-door	:name 'door12
			:loc1 (make-location :room 'room1 :x 1 :y 7 :z 0)
			:loc2 (make-location :room 'room2 :x 2 :y 7 :z 0))
	   (make-door	:name 'door23 
			:loc1 (make-location :room 'room2 :x 5 :y 7 :z 0)
			:loc2 (make-location :room 'room3 :x 6 :y 7 :z 0))
	   (make-door	:name 'door36
			:loc1 (make-location :room 'room3 :x 7 :y 4 :z 0)
			:loc2 (make-location :room 'room6 :x 7 :y 3 :z 0))
	   (make-door	:name 'door34
			:loc1 (make-location :room 'room3 :x 8 :y 6 :z 0)
			:loc2 (make-location :room 'room4 :x 9 :y 6 :z 0))
	)
)
(setq *ROOM-MAP* (make-array (list *X-DIM* *Y-DIM*) :initial-element nil))

(initialize-room-map *ROOMS*)
