
(proclaim 
 '(special *SCR-NODE-SELECT-RULES*      *SCR-GOAL-SELECT-RULES*
	   *SCR-OP-SELECT-RULES*	*SCR-BINDINGS-SELECT-RULES*
	   *SCR-NODE-REJECT-RULES*      *SCR-GOAL-REJECT-RULES*
	   *SCR-OP-REJECT-RULES*	*SCR-BINDINGS-REJECT-RULES*
	   *SCR-NODE-PREFERENCE-RULES*  *SCR-GOAL-PREFERENCE-RULES*
	   *SCR-OP-PREFERENCE-RULES*    *SCR-BINDINGS-PREFERENCE-RULES*
	   *STANDARD-META-FNS* *VARIABLE-TYPING*))



(eval-when (compile) 
  (load-path *PLANNER-PATH* "data-types"))


;;; This stuff creates the initial default set of search control for a domain.
(defun create-scrules (primary)
  (if (not (boundp '*SCR-GOAL-SELECT-RULES*))
      (initialize-scrules-vars))
  (add-standard-goal-selection-rule)
  (add-control-rules primary))
;;;
;;; First delete any existing search control rule stuff.
;;;
(defun initialize-scrules-vars ()
  (format t "~%~%Reinitializing all search control rules.")
  (setq *SCR-NODE-SELECT-RULES* nil)
  (setq *SCR-GOAL-SELECT-RULES* nil)
  (setq *SCR-OP-SELECT-RULES* nil)
  (setq *SCR-BINDINGS-SELECT-RULES* nil)

  (setq *SCR-NODE-REJECT-RULES* nil)
  (setq *SCR-GOAL-REJECT-RULES* nil)
  (setq *SCR-OP-REJECT-RULES* nil)
  (setq *SCR-BINDINGS-REJECT-RULES* nil)

  (setq *SCR-NODE-PREFERENCE-RULES* nil)
  (setq *SCR-GOAL-PREFERENCE-RULES* nil)
  (setq *SCR-OP-PREFERENCE-RULES* nil)
  (setq *SCR-BINDINGS-PREFERENCE-RULES* nil)
  )
;;;
;;; Add the standard top level reordering rule.
(defun add-standard-goal-selection-rule ()
  (if (no-select-first-goal-rule *SCR-GOAL-SELECT-RULES*)
      (setq *SCR-GOAL-SELECT-RULES*
	(cons '(SELECT-FIRST-GOAL
		(lhs (and (current-node <node>)
			  (not-top-level-node <node>)
			  (list-of-candidate-goals <node> <goals>)
			  (is-first-goal <goal> <goals>)))
		(rhs (select goal <goal>)))
	      *SCR-GOAL-SELECT-RULES*))))

(defun no-select-first-goal-rule (rules)
  (cond ((null rules) t)
	((eq 'select-first-goal (caar rules)) nil)
	(t (no-select-first-goal-rule (cdr rules)))))

;;; Add the operator selection rules based on the primary adds.  If
;;; all the effects are primary then there is no point to a selection
;;; rule.  The function 'is-arg-type' is added dynamically in case
;;; the meta-fns are reloaded and it is removed from the list.
;;;
(defun add-control-rules (primary)
  (cond ((eq 'all primary))
	(t (add-meta-fn 'is-arg-type)
	   (pushnew 'is-arg-type *STANDARD-META-FNS*)
	   (setq *SCR-OP-SELECT-RULES* 
		 (append (remove-old-rules *SCR-OP-SELECT-RULES*)
			 (create-operator-selection-rules primary)))
	   (setq *SCR-GOAL-REJECT-RULES* 
		 (append (remove-old-rules *SCR-GOAL-REJECT-RULES*)
			 (create-goal-rejection-rules primary))))))
;;;
(defun create-operator-selection-rules (primary)
  (cond ((null primary) nil)
	((null (cdar primary))
	 (create-operator-selection-rules (cdr primary)))
	(t (append (create-selection-rule (caar primary)(cdar primary))
		   (create-operator-selection-rules (cdr primary))))))
;;;
(defun create-goal-rejection-rules (primary)
  (cond ((null primary) nil)
	((null (cdar primary))
	 (cons (mark-rule (create-rejection-rule (caar primary)))
	       (create-goal-rejection-rules (cdr primary))))
	(t (create-goal-rejection-rules (cdr primary)))))

;;;
;;;
;;; Create the rejections for literals that cannot be achieved
;;; directly. 
(defun create-rejection-rule (literal)
  (if (and *variable-typing* (variables literal))
      `(,(gentemp "OP-REJECT-")
	(lhs (and (current-node <node>)
		  (candidate-goal <node> ,literal)
		  ,(known-types literal)))
	(rhs (reject goal ,literal)))
    `(,(gentemp "OP-REJECT-")
      (lhs (and (current-node <node>)
		(candidate-goal <node> ,literal)))
      (rhs (reject goal ,literal)))))

  
;;;
;;; Create the selection rules based on each primary effect.  If
;;; variable typing is turned on then we need to include some
;;; conditions about the types of the arguments.
;;;
(defun create-selection-rule (primary-effect operators)
  (cond ((null operators) nil)
	(t (cons (mark-rule
		  (if (and *variable-typing* (variables primary-effect))
		      `(,(gentemp "OP-SELECT-")
			(lhs (and (current-node <node>)
				  (current-goal <node> ,primary-effect)
				  ,(known-types primary-effect)
				  (candidate-op  <node> ,(car operators))))
			(rhs (select op ,(car operators))))
		    `(,(gentemp "OP-SELECT-")
		      (lhs (and (current-node <node>)
				(current-goal <node> ,primary-effect)
				(candidate-op  <node> ,(car operators))))
		      (rhs (select op ,(car operators))))))
		  (create-selection-rule primary-effect (cdr operators))))))
;;;
;;;
;;; Flags the rule as one generated by ALPINE.
(defun mark-rule (rule)
  (setf (get (car rule) 'alpine) t)
  rule)
;;;
;;;
;;; Remove all the old rules generated by alpine.
(defun remove-old-rules (rules)
  (cond ((null rules) nil)
	((get (caar rules) 'alpine)
	 (remove-old-rules (cdr rules)))
	(t (cons (car rules)(remove-old-rules (cdr rules))))))
;;;
;;; Tests wheter there are any variables in the given literal
(defun variables (literal)
  (cond ((null literal) nil)
	((is-variable (car literal)))
	(t (variables (cdr literal)))))
;;;
;;; Returns the expression that tests the types of the literal.
;;;
(defun known-types (literal)
  (let ((type-list (types literal)))
    (if (eql 1 (length type-list))
	(car type-list)
	(cons 'and type-list))))
;;;
;;;
;;; Returns the list of type expresssions.
;;;
(defun types (literal)
  (cond ((null literal) nil)
	((is-variable (car literal))
	 (cons `(is-arg-type ,(car literal) ,(arg-type (car literal)))
	       (types (cdr literal))))
	(t (types (cdr literal)))))

