#|
*******************************************************************************
PRODIGY Version 2.0  
Copyright 1989 by Steven Minton, Craig Knoblock, Dan Kuokka and Jaime Carbonell

The PRODIGY System was designed and built by Steven Minton, Craig Knoblock,
Dan Kuokka and Jaime Carbonell.  Additional contributors include Henrik Nordin,
Yolanda Gil, Manuela Veloso, Robert Joseph, Santiago Rementeria, Alicia Perez, 
Ellen Riloff, Michael Miller, and Dan Kahn.

The PRODIGY system is experimental software for research purposes only.
This software is made available under the following conditions:
1) PRODIGY will only be used for internal, noncommercial research purposes.
2) The code will not be distributed to other sites without the explicit 
   permission of the designers.  PRODIGY is available by request.
3) Any bugs, bug fixes, or extensions will be forwarded to the designers. 

Send comments or requests to: prodigy@cs.cmu.edu or The PRODIGY PROJECT,
School of Computer Science, Carnegie Mellon University, Pittsburgh, PA 15213.
*******************************************************************************|#

;;; The search control rules in this file implement the following domain axiom:
;;;   An operation or set of operations that fail will not succeed if they
;;;   are tried at any later time slot in the same order.
;;; In other words, you can't shift the whole plan or part of the plan to
;;; the right and expect that it will now work when it didn't before.

(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 
      '((SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
		    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))))
(setq *SCR-OP-SELECT-RULES* nil)
(setq *SCR-BINDINGS-SELECT-RULES* nil)
(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-OP-REJECT-RULES* 
  '(
	    (DONT-MAKE-OBJ1
	     (lhs (and (current-node <node>)
		       (current-goal <node> (is-object <x>))
		       (candidate-op <node> WELD)))
	     (rhs (reject operator WELD)))

	    (DONT-MAKE-OBJ2
	     (lhs (and (current-node <node>)
		       (current-goal <node> (is-object <x>))
		       (candidate-op <node> BOLT)))
	     (rhs (reject operator BOLT)))))

(setq *SCR-BINDINGS-REJECT-RULES* '(

   (DONT-TRY-ALL-TIMES-1
    (lhs (and	(current-node <node>)
	   	(current-goal <node> <goal>)
		(current-op <node> <op>)
	   	(or  (is-equal <op> POLISH)
		     (is-equal <op> ROLL)
		     (is-equal <op> GRIND))
		(uses-machine <op> <machine>)
	   	(candidate-bindings <node> (<obj> <time> <before-time>))
		(previous-slot <time> <prev-time>)
		(known <node> (~ (last-scheduled <obj> <prev-time>)))
		(known <node> (~ (scheduled <any-obj> <machine> <prev-time>)))
	 ))
    (rhs (reject bindings (<obj> <time> <before-time>))))

   (DONT-TRY-ALL-TIMES-2
    (lhs (and	(current-node <node>)
	   	(current-goal <node> <goal>)
	        (current-op <node> <op>)
	   	(or (is-equal <op> IMMERSION-PAINT)
		    (is-equal <op> SPRAY-PAINT)
		    (is-equal <op>  LATHE))
		(uses-machine <op> <machine>)
	   	(candidate-bindings <node> (<obj> <time> <any-arg> <before-time>))
		(previous-slot <time> <prev-time>)
		(~ (known <node> (last-scheduled <obj> <prev-time>)))
		(~ (known <node> (scheduled <any-obj> <machine>
				<prev-time>)))
	 ))
    (rhs (reject bindings (<obj> <time> <any-arg> <before-time>))))

   (DONT-TRY-ALL-TIMES-3
    (lhs (and	(current-node <node>)
	   	(current-goal <node> <goal>)
	        (current-op <node> <op>)
	   	(or (is-equal <op> PUNCH)
		    (is-equal <op>  DRILL-PRESS))
		(uses-machine <op> <machine>)
	   	(candidate-bindings <node> (<obj> <time> <any-arg1> <any-arg2> 
						<before-time>))
		(previous-slot <time> <prev-time>)
		(~ (known <node> (last-scheduled <obj> <prev-time>)))
		(~ (known <node> (scheduled <any-obj> <machine>
				<prev-time>)))
	 ))
    (rhs (reject bindings (<obj> <time> <any-arg1> <any-arg2> <before-time>))))

   (DONT-TRY-ALL-TIMES-4
    (lhs (and	(current-node <node>)
	   	(current-goal <node> <goal>)
	        (current-op <node> WELD)
;	   	(is-equal <op> WELD)
		(uses-machine <op> <machine>)
	   	(candidate-bindings <node> (<obj-1> <obj-2> <time> 
					    <any-arg1> <before-time-1>
				 	    <before-time-2> <any-arg2>))
		(previous-slot <time> <prev-time>)
		(known <node> (~ (last-scheduled <obj-1> <prev-time>)))
		(known <node> (~ (last-scheduled <obj-2> <prev-time>)))
		(known <node> (~ (scheduled <any-obj> <machine>
				<prev-time>)))
	 ))
    (rhs (reject bindings (<obj-1> <obj-2> <time> <any-arg1>
					 <before-time-1> 
					<before-time-2> <any-arg2>))))
   (DONT-TRY-ALL-TIMES-5
    (lhs (and	(current-node <node>)
	   	(current-goal <node> <goal>)
	        (current-op <node> BOLT)
;	   	(is-equal <op> BOLT)
		(uses-machine <op> <machine>)
	   	(candidate-bindings <node> (<obj-1> <obj-2> <time> 
					    <any-arg1> <before-time-1>
				 	    <before-time-2> <any-arg2>
					    <any-arg3> <any-arg4>))
		(previous-slot <time> <prev-time>)
		(known <node> (~ (last-scheduled <obj-1> <prev-time>)))
		(known <node> (~ (last-scheduled <obj-2> <prev-time>)))
		(known <node> (~ (scheduled <any-obj> <machine>
				<prev-time>)))
	 ))
    (rhs (reject bindings (<obj-1> <obj-2> <time> <any-arg1> 
					 <before-time-1> 
					<before-time-2> <any-arg2>
					<any-arg3> <any-arg4>))))
	 )
	   
    )
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES* nil)

;  '((RTEST
;      (lhs (and (current-node <n>)
;	        (candidate-goal <n> (shape <x> CYLINDRICAL))
;	        (candidate-goal <n> (polished <x>))))
;      (rhs (perfer (shape <x> CYLINDRICAL) (polished <x>))))))

(setq *SCR-OP-PREFERENCE-RULES* 	nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)
