;===========================================================
;  Functions for the graphics.
;===========================================================


(defstruct door
  name
  loc1
  loc2
  state)

;(defstruct location
;  room
;  x
;  y
;  z)


(defun make-location (&key room x y z rx ry rz)
  (list 'location room x y z rx ry rz))

(defun location-p (loc)
  (and (listp loc) (eq (car loc) 'location)))

(defun location-room (loc)
  (second loc))

(defun location-x (loc)
  (third loc))

(defun location-y (loc)
  (fourth loc))

(defun location-z (loc)
  (fifth loc))

;
; Called with a list of rooms in the form:
;   ((loc1a loc1b)
;    (loc2a loc2b) ...)
; where the locna indicates the corner of a room and the pair
; of coordinates defines a rectangle which is the room.  Note 
; that there is no check to make sure you don't have overlapping rooms.
; This function calls initialize-room to update the array called 
; *room-map* to contain the corresponding room in each element of the
; array.
;
(defun initialize-room-map (rooms)
  (cond ((null rooms))
	(t (let ((room (car rooms)))
	     (initialize-room (location-room (first room))
			      (location-x (first room))
			      (location-y (first room))
			      (location-x (second room))
			      (location-y (second room)))
	     (initialize-room-map (cdr rooms))))))
;
;
; Called with the room name and the coordinates to update *room-map*.
;
(defun initialize-room (room x1 y1 x2 y2)
  (declare (special *ROOM-MAP*))
  (do ((x x1 (+ x 1)))
      ((> x x2))
      (do ((y y1 (+ y 1)))
	  ((> y y2))
	  (setf (aref *ROOM-MAP* x y) room))))

; ROBOT-LOCATION is an access function that returns the location a robot
; should be in if it is in a particular room

(defun robot-location (room)
     (declare (special *ROBOT-POS*))
	(find-if #'(lambda (x) (eq room (location-room x))) *ROBOT-POS*)
)
