;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; Binding rules.
;;; Author : Tak Sinn
;;; account: c473by
;;; domain : typing
;;;
(setq *SCR-NODE-SELECT-RULES* nil)

(setq *SCR-GOAL-SELECT-RULES*
;;; this control rule control how the problem should select the first goal
;;; Goal must be in order in order to process.
;;;
    '((SELECT-ORDERED-GOAL
       (lhs (and (current-node <node>)
                 (not-top-level-node <node>)
;;; If this statement is taken out, random order in the goal state can be used.
;;; Since the order is chosen depending on the number on the goal (typed x x number) 
;;; Right now, I allow any order.
                    (primary-candidate-goal <node> <goal>)
       ))
       (rhs (select goal <goal>)))))

  
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)
(setq *SCR-OP-SELECT-RULES* nil)
(setq *SCR-BINDINGS-SELECT-RULES* nil)

;;;
;;; This reject finger not for the corresponding key.
;;;
(setq *SCR-NODE-REJECT-RULES*
  '((REJECT-INRELEVENT-FINGER
    (lhs (and (candidate-node <node>)
              (primary-candidate-goal <node> (isfinger <f2> <f1>))))
    (rhs (reject node <node>)))

;;;
;;; This reject the finger not in the proper hand.
;;; if wrong finger and hand, reject it.
;;;
    (REJECT-HAND-FINGER
     (lhs (and (candidate-node <node>)
               (primary-candidate-goal <node> (on <hand> <finger> <key>))
               (known <node> (~ (isfinger <finger> <key>)))))
     (rhs (reject node <node>)))

;;;
;;; This reject whether we have the wrong case.
;;; Don't try to turn cap-lock on and off all the time 
;;; subgoaling it.
;;; 
     (REJECT-CAP-CASE
      (lhs (and (candidate-node <node>)
                (primary-candidate-goal <node> (samecase <cap> <case>))))
      (rhs (reject node <node>)))

))      
       
(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-OP-REJECT-RULES* nil)
;;;
;;; This binding reject rule reject
;;; the wrong binding of wrong finger.
;;; if we detect the wrong finger on wrong hand for a key,
;;; we reject the bindings until we find the right hand and finger
;;; for key binding.
;;;
(setq *SCR-BINDINGS-REJECT-RULES*
    '((REJECT-FINGER
      (lhs (and (current-node <node>)
                (current-op <node> TYPE-USING)
                (current-goal <node> (TYPED <case> <key> <num>))
                (candidate-bindings <node> (<*hand> <*finger> <*key> <num>))
                (known <node> (~ (on <*hand> <*finger> <*key>)))
                (known <node> (~ (isfinger <*finger> <*key>)))))
      (rhs (reject bindings (<*hand> <*finger> <*key> <num>))))
))
      

(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES* nil)
(setq *SCR-OP-PREFERENCE-RULES* nil)
;;;
;;; This prefer the  which hand, finger, key, and nextkey
;;; for the right binding to an improper one.
;;; Try to prefer to choose another one if the current
;;; binding doesn't match the precond.
;;;
(setq *SCR-BINDINGS-PREFERENCE-RULES* 
    '((PREFER-FINGER
      (lhs (and (current-node <node>)
                (current-goal <node> (TYPED <case> <*key> (*num>)))
                (current-op <node> TYPE-USING)
                (candidate-bindings <node> ( <*hand> <*finger> <*key> <*num>))
                (known <node> (letter <*key>))
                (known <node> (ishand <*hand>))
                (known <node> (leftorright <*hand> <*key>))
                (known <node> (isfinger <*finger> <*key>))
                (known <node> (istip <*finger>))
                (known <node> (on <*hand> <*finger> <key1>))
                (known <node> (positioning <key1> <*key> down))
                (known <node> (capflag <flag>))
                (known <node> (samecase <case> <flag>))
                (known <node> (cap-key <flag>))
                (known <node> (keyed <oldkey>))
                (known <node> (next-key <oldkey> <*num>))
                (candidate-bindings <node> (<b1> <b2> <b3> <b4>))
                (not-equal (<*hand> <*finger> <*key> <*num>)
                           (<b1> <b2> <b3> <b4>))))
     (rhs
         (prefer bindings (<*hand> <*finger> <*key> <*num>)
                           (<b1> <b2> <b3> <b4>))))))
            
