;;;*************************************************************************
;;;
;;;Test Problem  : sew the pocket on the left-front of the garment.
;;;                The pocket has some blue buttons with diameter 2 on it.
;;;
;;;                The purpose of this problem is to test the control rule
;;;                SEW-BUTTONS-ON-POCKET-BEFORE-SEW-POCKET
;;;
;;;**************************************************************************

(load-goal 
           '(and
                (with-option POCKET LEFT-FRONT)  ;has a pocket at left-front of shirt
                (pocket-with-buttons 2 BLUE)     ;has blue buttons with diameter 2 cms on pocket
            )      
)

(load-start-state
    '(

       ;; tools needed
       (is-tool  SEWING-MACHINE)                 

       (fabric-is fabE LEFT-FRONT)
       (size-of   fabE WIDTH 60)
       (size-of   fabE LENGTH 100)
       (free      fabE)

       (fabric-is fabF POCKET)
       (size-of   fabF WIDTH 40)
       (size-of   fabF LENGTH 80)
       (free      fabF)

       ;;; have more buttons than needed, let Prodigy choose the right one.

       (has but1 BUTTONS)
       (has but2 BUTTONS)

       (size-of but1 DIAMETER 1)
       (size-of but2 DIAMETER 2)

       (color-of but2 BLUE)
       (color-of but1 GREEN)
       
     )
)


