;;;***********************************************
;;;
;;; Test Problem: a "fancy" skirt
;;;***********************************************

(load-goal 
        
        '(and
              (skirt)
              (with-embroidery RED SKIRT-RIGHT-FRONT)
              (with-embroidery YELLOW SKIRT-LEFT-BACK)
              (with-buttons 1 GREEN)
              (skirt-with-belt-loops)
              (garment-ironed)
              (with-option POCKET SKIRT-LEFT-FRONT)
              (with-embroidery BLACK SKIRT-RIGHT-BACK)
              (with-embroidery GREEN POCKET)
              (skirt-with-zipper-of-length 12)
         )
)

(load-start-state
    '(

       ;; all the tools
       (is-tool  SEWING-MACHINE)                 
       (is-tool  EMBROIDERING-MACHINE)
       (is-tool  IRON)

       ;;all the necessary parts of the shirt
       (fabric-is fabA SKIRT-LEFT-FRONT)
       (size-of   fabA WIDTH  100)
       (size-of   fabA LENGTH 70)
       (free      fabA)

       (fabric-is fabB SKIRT-RIGHT-FRONT)
       (size-of   fabB WIDTH  60)
       (size-of   fabB LENGTH 90)
       (free      fabB)

       (fabric-is fabD SKIRT-LEFT-BACK)
       (size-of   fabD WIDTH  100)
       (size-of   fabD LENGTH 70)
       (free      fabD)

       (fabric-is fabE SKIRT-RIGHT-BACK)
       (size-of   fabE WIDTH  60)
       (size-of   fabE LENGTH 90)
       (free      fabE)

       (fabric-is fabF WAIST-BAND)
       (size-of   fabF WIDTH  70)
       (size-of   fabF LENGTH 25)
       (free      fabF)

       (fabric-is fabZ POCKET)
       (size-of   fabZ WIDTH  70)
       (size-of   fabZ LENGTH 25)
       (free      fabZ)


       ;; have more embroidering material than needed; let
       ;; prodigy choose the right one.
      
       (has thread1 EMBROIDERY-THREAD)
       (has thread2 EMBROIDERY-THREAD)
       (has thread3 EMBROIDERY-THREAD)
       (has thread4 EMBROIDERY-THREAD)

       (color-of thread1 RED)
       (color-of thread2 GREEN)
       (color-of thread3 BLACK)
       (color-of thread4 YELLOW)

       (has but1 BUTTONS)
       (has but2 BUTTONS)

       (size-of but1 DIAMETER 1)
       (size-of but2 DIAMETER 2)

       (color-of but2 BLUE)
       (color-of but1 GREEN)

       (has zip1 ZIPPER)
       (has zip2 ZIPPER)
       (has zip3 ZIPPER)
       (has zip4 ZIPPER)

       (zipper-len zip1 8)
       (zipper-len zip2 13)
       (zipper-len zip3 11)
       (zipper-len zip4 12)
       
     )
)







