;;;********************************************************************************
;;;********************************************************************************
;;;
;;; Domain  : Tailoring
;;;
;;; Code by : Dinh Dang
;;; Class   : CSE473
;;; Quarter : Spring 1991
;;; Date    : 05/17/91
;;;
;;; Account : c473bj
;;;
;;;                             
;;;*********************************************************************************
;;;*********************************************************************************
;;;
;;; OPERATORS: total of 16
;;;
;;; NOTE1:  all the "SEW ...." operators are very symmetric and similiar, so only the
;;;        very first "SEW...." operator in the domain is thoroughly document.  For
;;;        the rest "SEW...." operators, I only document the part of code that are 
;;;        different from the first "SEW...." operator.
;;;        
;;; NOTE2: Since I have to cut the fabric (i.e. destroy an object) to the required
;;;        size, I need to use non static generator for the size of the fabric.
;;;
;;; NOTE3: The required sizes of the different parts of a shirt-with-collar,
;;;        a T-shirt, or a skirt are:
;;;
;;;              Pattern           WIDTH  LENGTH  T-shirt   shirt-with-collar     skirt
;;;
;;;              LEFT-SLEEVE       50     30      yes       yes                    no
;;;              RIGHT-SLEEVE      50     30      yes       yes                    no
;;;              LEFT-FRONT        40     80      no        yes                    no
;;;              RIGHT-FRONT       40     80      no        yes                    no
;;;              BACK              60     80      yes       yes                    no
;;;              FRONT             70     80      yes       no                     no
;;;              POCKET            20     20      yes       yes                    no
;;;              COLLAR            40     15      no        yes                    no
;;;              SKIRT-LEFT-FRONT  35     50      no        no                     yes
;;;              SKIRT-RIGHT-FRONT 35     50      no        no                     yes
;;;              SKIRT-LEFT-BACK   30     50      no        no                     yes
;;;              SKIRT-RIGHT-BACK  30     50      no        no                     yes
;;;              WAIST-BAND        64     4       no        no                     yes
;;;***********************************************************************************

(setq *OPERATORS* '(
;;;
;;; SEW-SKIRT-FRONT: combine the front-left and front-right of the skirt
;;;

   (SEW-SKIRT-FRONT
       (params ())
       (preconds 
                 (and (is-power-on SEWING-MACHINE)        ;sewing machine on

                      (fabric-is <fab1> SKIRT-LEFT-FRONT) ;fabric for left-front of skirt
                      (free <fab1>)                       ;not sewed
                      (fabric-ok <fab1> WIDTH  35)        ;fabric wide enough.
                      (fabric-ok <fab1> LENGTH 50)        ;fabric long enough.

                      (fabric-is <fab2> SKIRT-RIGHT-FRONT) ;fabric for right-front of skirt
                      (free <fab2>)                       ;not sewed
                      (fabric-ok <fab2> WIDTH  35)        ;fabric wide enough.
                      (fabric-ok <fab2> LENGTH 50)        ;fabric long enough.
                 )

       )
       (effects  ((add (ready-skirt-front))               ;work done
                  (del (free <fab1>))    
                  (del (free <fab2>))    
                  (if (garment-ironed) 
                      (del( garment-ironed))              ;garment was wrinkled
                  )
                 )
       )
   )
;;;
;;; SEW-SKIRT-BACK: combine the left-back and right-back of the skirt
;;;

   (SEW-SKIRT-BACK
       (params ())
       (preconds 
                 (and (is-power-on SEWING-MACHINE)        ;sewing machine on

                      (fabric-is <fab1> SKIRT-LEFT-BACK) ;fabric for left-back of skirt
                      (free <fab1>)                       ;not sewed
                      (fabric-ok <fab1> WIDTH  30)        ;fabric wide enough.
                      (fabric-ok <fab1> LENGTH 50)        ;fabric long enough.

                      (fabric-is <fab2> SKIRT-RIGHT-BACK) ;fabric for right-back of skirt
                      (free <fab2>)                       ;not sewed
                      (fabric-ok <fab2> WIDTH  30)        ;fabric wide enough.
                      (fabric-ok <fab2> LENGTH 50)        ;fabric long enough.
                 )
       )
       (effects  ((add (ready-skirt-back) )               ;work done
                  (del (free <fab1>))    
                  (del (free <fab2>))    
                  (if (garment-ironed) 
                      (del( garment-ironed))              ;garment was wrinkled
                  )
                 )
       )
   )
;;;
;;; SEW-SKIRT-SIDES: sews the sides of the skirt
;;; 
;;;
   (SEW-SKIRT-SIDES
       (params ())
       (preconds 
                 (and (is-power-on SEWING-MACHINE)        ;sewing machine on
                      (ready-skirt-front)
                      (ready-skirt-back)
                 )

       )
       (effects  ((add (ready-skirt-sides))               ;work done
                  (if (garment-ironed) 
                      (del( garment-ironed))              ;garment was wrinkled
                  )
                 )
       )
    )
   

;;;
;;; SEW-WAIST-BAND: sews the waist-band of the skirt
;;;

   (SEW-WAIST-BAND
       (params ())
       (preconds 
                 (and (is-power-on SEWING-MACHINE)        ;sewing machine on

                      (fabric-is <fab1> WAIST-BAND)       ;fabric for waist-band
                      (free <fab1>)                       ;not sewed
                      (fabric-ok <fab1> WIDTH  64)        ;fabric wide enough.
                      (fabric-ok <fab1> LENGTH 4 )        ;fabric long enough.
                      (ready-skirt-sides)                 ; the body of the skirt must have been sewed
                 )
       )
       (effects  ((add (ready-waist-band))                ;work done
                  (del (free <fab1>))                     ;not free any more
                  (if (garment-ironed) 
                      (del( garment-ironed))              ;garment was wrinkled
                  )
                 )
       )
     )
;;;
;;; SEW-BELT-LOOPS: sews belt-loops onto the waist-band of the skirt.
;;;

   (SEW-BELT-LOOPS
       (params ())
       (preconds 
                 (and (is-power-on SEWING-MACHINE)        ;sewing machine on
                      (fabric-is <fab1> WAIST-BAND)       ;fabric for waist-band
                      (free <fab1>)                       ;not sewed
                      (fabric-ok <fab1> WIDTH  64)        ;fabric wide enough.
                      (fabric-ok <fab1> LENGTH 4 )        ;fabric long enough.
                      (ready-skirt-sides)                 ;the body od the skirt must have been sewed
                 )
       )
       (effects  ((add (skirt-with-belt-loops))           ;work done
                  (if (garment-ironed) 
                      (del( garment-ironed))              ;garment was wrinkled
                  )
                 )
       )
     )
;;;
;;; SEW-ZIPPER: sews the zipper onto the left-front and right-front of the skirt
;;;

   (SEW-ZIPPER
       (params ())
       (preconds 
                 (and (is-power-on SEWING-MACHINE)        ;sewing machine on
                      (has <zip1> ZIPPER)                 ; zipper
                      (zipper-len <zip1> <len>)        ; length of zipper
                
                      (fabric-is <fab1> SKIRT-LEFT-FRONT) ;fabric for left-front of skirt
                      (free <fab1>)                       ;not sewed
                      (fabric-ok <fab1> WIDTH  35)        ;fabric wide enough.
                      (fabric-ok <fab1> LENGTH 50)        ;fabric long enough.

                      (fabric-is <fab2> SKIRT-RIGHT-FRONT) ;fabric for right-front of skirt
                      (free <fab2>)                       ;not sewed
                      (fabric-ok <fab2> WIDTH  35)        ;fabric wide enough.
                      (fabric-ok <fab2> LENGTH 50)        ;fabric long enough.
                      
        
                 )
       )
       (effects  ((add (skirt-with-zipper-of-length <len>))     ;work done
                  (del (has <zip1> ZIPPER))
                  (if (garment-ironed) 
                      (del( garment-ironed))              ;garment was wrinkled
                  )
                 )
       )
     )
;;;
;;; SEW-LEFT-SLEEVE: Sews the left sleeve of the shirt or the T-shirt
;;;
;;;
     (SEW-LEFT-SLEEVE
       (params ())
       (preconds 
                 (and (is-power-on SEWING-MACHINE)      

                      (fabric-is <fab1> LEFT-SLEEVE)    ;left-sleeve
                      (free <fab1>)
                      (fabric-ok <fab1> WIDTH 50)        ;check size
                      (fabric-ok <fab1> LENGTH 30)

                      (or
                         (ready-back-n-left-front)       ;back & left front sewed(shirt)
                         (ready-back-n-front)            ;back & front sewed (T-shirt)
                      )
                 )
       )
       (effects  ((add (ready-left-sleeve))             ;work done
                  (del (free <fab1>))
                  (if (garment-ironed) 
                      (del( garment-ironed))             ;garment was wrinkled
                  )
                 )
       )
     )
;;;
;;; SEW-RIGHT-SLEEVE: Sews the right sleeve of the shirt or the T-shirt
;;;
;;; Please see the documentation for SEW-LEFT-SLEEVE because these two operators
;;; are symmetric.
;;;
     (SEW-RIGHT-SLEEVE
       (params ())
       (preconds 
                 (and (is-power-on SEWING-MACHINE)      

                      (fabric-is <fab1> RIGHT-SLEEVE)    ;right-sleeve
                      (free <fab1>)
                      (fabric-ok <fab1> WIDTH 50)        ;check size
                      (fabric-ok <fab1> LENGTH 30)

                      (or
                         (ready-back-n-right-front)      ;back & right front sewed(shirt)
                         (ready-back-n-front)            ;back & front sewed (T-shirt)
                      )
                 )
       )
       (effects  ((add (ready-right-sleeve))             ;work done
                  (del (free <fab1>))
                  (if (garment-ironed) 
                      (del( garment-ironed))             ;garment was wrinkled
                  )
                 )
       )
     )

;;;
;;; SEW-COLLAR: sews the collar of the shirt.  (T-shirt does not have collar,
;;;             so it will not use this operator.)
;;;

     (SEW-COLLAR
        (params ())
        (preconds
                 (and (is-power-on SEWING-MACHINE)

                      (fabric-is <fab1> COLLAR)           ;collar
                      (free <fab1>)
                      (fabric-ok <fab1> WIDTH 40)
                      (fabric-ok <fab1> LENGTH 15)

                      (ready-back-n-left-front)           ;back&left-front sewed(shirt)
                      (ready-back-n-right-front)          ;back&right-front sewed(shirt)
                 )
        )
        (effects 
                 ((add (ready-collar))                    ;work done
                  (del (free <fab1>))                      
                  (if (garment-ironed) 
                      (del( garment-ironed))              ;garment was wrinkled.
                  )
                 )
        )
     )
;;;
;;; SEW-BACK-N-LEFT-FRONT: sews the back and left-front of the shirt together.
;;;                        (T-shirt will not use this operator.)
;;;
;;; 
     (SEW-BACK-N-LEFT-FRONT
        (params ())
        (preconds
                 (and (is-power-on SEWING-MACHINE)

                      (fabric-is <fab1> LEFT-FRONT)        ;left-front
                      (free <fab1>)
                      (fabric-ok <fab1> WIDTH 40)
                      (fabric-ok <fab1> LENGTH 80)

                      (fabric-is <fab2> BACK)              ;back
                      (free <fab2>)
                      (fabric-ok <fab2> WIDTH 60)
                      (fabric-ok <fab2> LENGTH 80)
                 )
         )

         (effects
                  ((add (ready-back-n-left-front))
                   (del (free <fab1>))
                   (if (ready-back-n-right-front)          ;<fab2> is not free any more
                       (del (free <fab2>))                 ;if back&right-front have
                   )                                       ;been sewed together
                   (if (garment-ironed) 
                       (del( garment-ironed))
                   )
                  )
         )        
     )
;;;
;;; SEW-BACK-N-RIGHT-FRONT: sews the back and right front together
;;;                        (T-shirt will not use this operator.)
;;;
;;;

     (SEW-BACK-N-RIGHT-FRONT
        (params ())
        (preconds
                 (and (is-power-on SEWING-MACHINE)

                      (fabric-is <fab1> RIGHT-FRONT)         ;right-front
                      (free <fab1>)
                      (fabric-ok <fab1> WIDTH 40)
                      (fabric-ok <fab1> LENGTH 80)

                      (fabric-is <fab2> BACK)                ;back
                      (free <fab2>)
                      (fabric-ok <fab2> WIDTH 60)
                      (fabric-ok <fab2> LENGTH 80)
                 )
         )
         (effects
                  ((add (ready-back-n-right-front))
                   (del (free <fab1>))
                   (if (ready-back-n-left-front) (del        ;<fab2> is not fee any more
                       (free <fab2>))                        ;if back&left-front have
                   )                                         ;been sewed together
                   (if (garment-ironed) (del( garment-ironed)))
                  )
         )
     )
;;;
;;; SEW-BACK-N-FRONT: This operator is used in T-shirt making only,
;;;                   since T-shirt haa a back and a front
;;;
     (SEW-BACK-N-FRONT
        (params ())
        (preconds
                 (and (is-power-on SEWING-MACHINE)

                      (fabric-is <fab1> FRONT)               ;front
                      (free <fab1>)
                      (fabric-ok <fab1> WIDTH 70)
                      (fabric-ok <fab1> LENGTH 80)

                      (fabric-is <fab2> BACK)                ;back
                      (free <fab2>)
                      (fabric-ok <fab2> WIDTH 60)
                      (fabric-ok <fab2> LENGTH 80)
                 )
         )
         (effects
                  ((add (ready-back-n-front))
                   (del (free <fab1>))
                   (del (free <fab2>))
                   (if (garment-ironed) (del( garment-ironed)))
                  )
         )        
     )
;;;
;;; SEW-POCKET: sews the pocket onto the left-front or the right-front
;;;             of the shirt-with-collar or on the front of the T-shirt.
;;;
;;;     
     (SEW-POCKET
        (params (<any-pattern>))
        (preconds
                 (and (is-power-on SEWING-MACHINE)

                      (fabric-is <fab1> POCKET)                      ;the pocket
                      (free <fab1>)
                      (fabric-ok <fab1> WIDTH 20)
                      (fabric-ok <fab1> LENGTH 20)
                 
                      (fabric-is <fab2> <any-pattern>)
                      (free <fab2>)
                      (or
                        (and (same-pattern <any-pattern> LEFT-FRONT) ;left-front
                             (fabric-ok <fab2> WIDTH 40)
                             (fabric-ok <fab2> LENGTH 80)
                        )
                        (and (same-pattern <any-pattern> RIGHT-FRONT) ;right-front
                             (fabric-ok <fab2> WIDTH 40)
                             (fabric-ok <fab2> LENGTH 80)
                        )
                        (and (same-pattern <any-pattern> FRONT)       ;front of T-shirt
                             (fabric-ok <fab2> WIDTH 70)
                             (fabric-ok <fab2> LENGTH 80)
                        )
                        (and (same-pattern <any-pattern> SKIRT-LEFT-FRONT)  ;left-front of skirt
                             (fabric-ok <fab2> WIDTH 35)
                             (fabric-ok <fab2> LENGTH 50)
                        )
                        (and (same-pattern <any-pattern> SKIRT-RIGHT-FRONT) ;right-front of skirt
                             (fabric-ok <fab2> WIDTH 35)
                             (fabric-ok <fab2> LENGTH 50)
                        )
                      )
                      
                 )
        )
        (effects
                  ((add (with-option POCKET <any-pattern>))
                   (del (free <fab1>))
                   (if (garment-ironed) (del( garment-ironed)))
                  )
        )
     )
;;;
;;; SEW-EMBROIDERY: embroiders the specified part of the garment
;;;                 to be sewed with desired color thread.
;;;
;;;

     (SEW-EMBROIDERY
        (params (<color-desired> <any-pattern>))
            (preconds
                 (and (is-power-on EMBROIDERING-MACHINE)

                      (has <the-thread> EMBROIDERY-THREAD)   
                      (color-of <the-thread> <color-desired>)  ;color thread chosen

                      (fabric-is <fab1> <any-pattern>)        ;on this part of garment 
                      (free <fab1>)
                 )
        )
        (effects
                 ((add (with-embroidery <color-desired> <any-pattern>)) ;work done
                  (del (has <the-thread> EMBROIDERY-THREAD))            ;use up thread
                  (if (garment-ironed) (del( garment-ironed)))          ;garment wrinkled
                 )
        )
     
     )
;;;
;;; SEW-TAG: sews tag onto the back of the garment.
;;;          
;;;
;;;

     (SEW-TAG
        (params (<any-pattern>))
        (preconds
                 (and (is-power-on SEWING-MACHINE)

                      (fabric-is <fab1> BACK)                  ;add tag on this part
                      (free <fab1>)                            ;this part still free
                      (fabric-ok <fab1> WIDTH  60)             ;check size
                      (fabric-ok <fab1> LENGTH 80)             ;check size
                 )
        )
        (effects 
                ((add (tag-attached-at BACK))
                 (if (garment-ironed) 
                     (del( garment-ironed))                    ;garment wrinkled
                 ) 
                )
        )
     )
;;;
;;; SEW-BUTTONS-ON-GARMENT: sews buttons of designated diameter and color onto
;;;                          the garment.
;;;
;;;
     (SEW-BUTTONS-ON-GARMENT
        (params (<diameter> <color> ))
        (preconds 
            (and
                 (garment-ready)                              ;garment must exist
                 (has <button> BUTTONS)                       ;have buttons
                 (size-of <button> DIAMETER <diameter>)       ;their size
                 (color-of <button> <color>)                  ;color
                 (button-holes-sewed <diameter>)              ;garment has button holes
            )
        )
        (effects 
                 ((add (with-buttons <diameter> <color>))     ;work done
                  (del (has <button> BUTTONS))                ;no more buttons
                  (if (garment-ironed) 
                      (del( garment-ironed))
                  )
                 )
        )

     )
;;;
;;; SEW-BUTTONS-ON-POCKET: sews buttons of designated diameter and color onto
;;;                        the pocket
;;;
;;;
     (SEW-BUTTONS-ON-POCKET
        (params (<diameter> <color> ))
        (preconds 
            (and
                 (fabric-is <fab1> POCKET)                    ;the pocket
                 (free <fab1>)
                 (fabric-ok <fab1> WIDTH 20)
                 (fabric-ok <fab1> LENGTH 20)

                 (has <button> BUTTONS)                       ;have buttons
                 (size-of <button> DIAMETER <diameter>)       ;their size
                 (color-of <button> <color>)                  ;color
            )
        )
        (effects 
                 ((add (pocket-with-buttons <diameter> <color>))  
                  (del (has <button> BUTTONS))                ;no more buttons
                  (if (garment-ironed) 
                      (del( garment-ironed))
                  )
                 )
        )

     )
;;;
;;; SEW-BUTTON-HOLES: sews button holes with specified diameter.
;;;
;;;

     (SEW-BUTTON-HOLES
        (params (<diameter>))
        (preconds
                  (and (is-power-on SEWING-MACHINE)

                       (garment-ready)                        ;garment exists
                       (has <button> BUTTONS)                 ;has buttons
                       (size-of <button> DIAMETER <diameter>) ;diameter of buttons
                       (has-marked-diameter <diameter>)       ;has button hole markings
                  )
        )
        (effects
                 ((add (button-holes-sewed <diameter>))       ;work done
                  (del (has-marked-diameter <diameter>))      ;no more markings
                 )
        )
     )
;;;
;;; MARK-BUTTON-HOLES: marks the garment where buttons holes should
;;;                    be made.
;;;
;;;

     (MARK-BUTTON-HOLES
        (params (<diameter>))
        (preconds
                 (and (garment-ready)                        ;garment exists
                      (has <button> BUTTONS)                 ;has buttons
                      (size-of <button> DIAMETER <diameter>) ;their diameter
                 )
        )
        (effects
                 ((add (has-marked-diameter <diameter>))     ;work done
                  (if (garment-ironed)                      
                      (del( garment-ironed))                 ;garment was wrinkled.
                  )
                 )
        )
     )
;;;
;;; IRON-GARMENT: iron the garment
;;;
;;;

     (IRON-GARMENT
        (params ())
        (preconds 
                 (and
                      (garment-ready)        ;garment exists
                      (is-power-on IRON)     ;the iron is switched on.
                 )
        )
        (effects
                 ((add (garment-ironed))     ;work done
                 )
        )
     )




;;;
;;; TURN-ON: swich on the required tailoring tool
;;;
;;;

     (TURN-ON
        (params (<any-tool>))
        (preconds
                  (and
                       (is-tool <any-tool>)       ;the tool
                       (socket-outlet-available)  
                  )
        )
        (effects  ((add (is-power-on <any-tool>)) ;work done
                  )
        )
     )
;;;
;;; TURN-OFF: switch off the designated tailoring tool
;;;
;;;

     (TURN-OFF
        (params (<any-tool>))
        (preconds
                  (and
                       (is-tool <any-tool>)       ;the tool
                       (is-power-on <any-tool>)
                  )
        )
        (effects  
                  (
                   (del (is-power-on <any-tool>)) ;work done
                  )
        )
     )
;;;
;;; MEASURE-N-CUT-FABRIC: check if the width or the length of the fabric meets 
;;;                       the width or the length required.
;;;                       the size of the fabric can only be equal or
;;;                       larger than the required size.
;;;
;;;

     (MEASURE-N-CUT-FABRIC
        (params (<any-pattern> <any-dimension> <required-size>))
        (preconds
                  (and
                       (fabric-is <fab1> <any-pattern>)       ;the fabric
                       (size-of <fab1> <any-dimension> <size>) ;size of <any-dimension>

                       (or (smaller <required-size> <size>)    ;check size
                           (same    <required-size> <size>)
                       )
                  )
        )
        (effects
                 ((add (fabric-ok <fab1> <any-dimension> <required-size>))
                  (if (smaller <required-size> <size>)
                      (del (size-of <fab1> <any-dimension> <size>))
                      (add (size-of <fab1> <any-dimension> <required-size>))
                  )
                 )

        )
     )

   )
)
;;;**********************************************************************************
;;;
;;; INFERENCE RULES : total of 4
;;;
;;;**********************************************************************************


(setq *INFERENCE-RULES*  '(


;;;
;;; INFER-SOCKET-OUTLET-AVAILABLE: infer if the socket outlet
;;;                                is available.
;;;

   (INFER-SOCKET-OUTLET-AVAILABLE
     (params ())
     (preconds 
              (~ (exists (<any-tool>)                 ;not exists any tool
                         (is-tool <any-tool>)         ;occuppying the socket outlet
                         (is-power-on <any-tool>)
                 )
              )
     )
     (effects ((add (socket-outlet-available)))       ;it is available
     )
  )
;;;
;;; INFER-SHIRT-WITH-COLLAR: infer if the shirt (with collar) is made
;;;
;;;

  (INFER-SHIRT-WITH-COLLAR
    (params ())
    (preconds
             (and (ready-back-n-left-front)
                  (ready-back-n-right-front)
                  (ready-left-sleeve)
                  (ready-right-sleeve)
                  (ready-collar)
             )
    )
    (effects
             ((add (shirt-with-collar)))
    )
  )
;;;
;;; INFER-T-SHIRT: infer if the T-shirt is made
;;;
;;;

  (INFER-T-SHIRT
    (params ())
    (preconds
             (and (ready-back-n-front)
                  (ready-left-sleeve)
                  (ready-right-sleeve)
             )
    )
    (effects
             ((add (T-shirt)))
              
    )
  )
;;;
;;; INFER-SKIRT:
;;;

  (INFER-SKIRT
     (params ())
     (preconds
               (and (ready-skirt-sides)
                    (ready-waist-band)
               )
     )
     (effects
              ((add (skirt)))
     )
  )
;;;
;;; INFER-GARMENT-READY: infer if the garment is made
;;; 
;;;

  (INFER-GARMENT-READY
    (params ())
    (preconds
               (or 
                   (T-shirt)
                   (shirt-with-collar)
                   (skirt)
               )
     )
     (effects
              ((add (garment-ready)))
     )
     
  )


 )
)



;;;**************************END OF DOMAIN.LISP **************************************
;;;***********************************************************************************









