; Operators

(setq *OPERATORS* '(


(square-up  ; can only be the first step in a complete dance
  (params nil)
  (preconds (and (prev-motion begin)
                 (swap no)
            )
  )
  (effects ((del (prev-motion begin))
            (add (prev-motion square-up))
            (add (used square-up))
           )
  )
) ; end square-up


;; operator to perform an appropriate motion from a left to a neutral
(left-to-neutral
  (params (<m2>))
  (preconds (and (left <m1> <s1>)
                 (prev-motion <m1>)
                 (neutral <m2> <s2>)
                 (~ (left <m2> <s2>))
                 (~ (right <m2> <s2>))
                 (swap no)
            )
  )
  (effects ((del (prev-motion <m1>))
            (add (prev-motion <m2>))
            (add (used <m2>))
            (add (swap <s2>))
           )
  )
) ; end left-to-neutral


;; operator to perform an appropriate motion from a left to a left
(left-to-left
  (params (<m2>))
  (preconds (and (left <m1> <s1>)
                 (prev-motion <m1>)
                 (left <m2> <s2>)
                 (~ (neutral <m2> <s2>))
                 (~ (right <m2> <s2>))
                 (not-same <m1> <m2>)  ;keeps sequential motions different
                 (swap no)
            )
  )
  (effects ((del (prev-motion <m1>))
            (add (prev-motion <m2>))
            (add (used <m2>))
            (add (swap <s2>))
           )
  )
) ; end left-to-left


;; operator to perform an appropriate motion from a neutral to a right
(neutral-to-right
  (params (<m2>))
  (preconds (and (neutral <m1> <s1>)
                 (prev-motion <m1>)
                 (right <m2> <s2>)
                 (swap no)
            )
  )
  (effects ((del (prev-motion <m1>))
            (add (prev-motion <m2>))
            (add (used <m2>))
            (add (swap <s2>))
           )
  )
) ; end neutral-to-right


;; operator to perform an appropriate motion from a neutral to a left
(neutral-to-left
  (params (<m2>))
  (preconds (and (neutral <m1> <s1>)
                 (prev-motion <m1>)
                 (left <m2> <s2>)
                 (swap no)
            )
  )
  (effects ((del (prev-motion <m1>))
            (add (prev-motion <m2>))
            (add (used <m2>))
            (add (swap <s2>))
           )
  )
) ; end neutral-to-left


;; operator to perform an appropriate motion from a neutral to a neutral
(neutral-to-neutral
  (params (<m2>))
  (preconds (and (neutral <m1> <s1>)
                 (prev-motion <m1>)
                 (neutral <m2> <s2>)
                 (not-same <m1> <m2>)  ;keeps sequential motions different
                 (swap no)
            )
  )
  (effects ((del (prev-motion <m1>))
            (add (prev-motion <m2>))
            (add (used <m2>))
            (add (swap <s2>))
           )
  )
) ; end neutral-to-neutral


;; operator to perform an appropriate motion from a right to a neutral
(right-to-neutral
  (params (<m2>))
  (preconds (and (right <m1> <s1>)
                 (prev-motion <m1>)
                 (neutral <m2> <s2>)
                 (swap no)
            )
  )
  (effects ((del (prev-motion <m1>))
            (add (prev-motion <m2>))
            (add (used <m2>))
            (add (swap <s2>))
           )
  )
) ; end right-to-neutral


;; operator to perform an appropriate motion from a right to a right
(right-to-right
  (params (<m2>))
  (preconds (and (right <m1> <s1>)
                 (prev-motion <m1>)
                 (right <m2> <s2>)
                 (not-same <m1> <m2>)  ;keeps sequential motions different
                 (swap no)
            )
  )
  (effects ((del (prev-motion <m1>))
            (add (prev-motion <m2>))
            (add (used <m2>))
            (add (swap <s2>))
           )
  )
) ; end right-to-right


;; operators that modify partner orientations
(circle-left-partner-swap
  (params nil)
  (preconds (and (mixing-ok)
                 (swap circle-left)
                 (prev-motion circle-left)
                 (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>)
            )
  )
  (effects ((del (swap circle-left))
            (add (swap no))
            (del (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>))
            (add (partners <p1> <p8> <p3> <p2> <p5> <p4> <p7> <p6>))
           )
  )
) ; end circle-left-partner-swap


(circle-right-partner-swap
  (params nil)
  (preconds (and (mixing-ok)
                 (swap circle-right)
                 (prev-motion circle-right)
                 (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>)
            )
  )
  (effects ((del (swap circle-right))
            (add (swap no))
            (del (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>))
            (add (partners <p1> <p4> <p3> <p6> <p5> <p8> <p7> <p2>))
           )
  )
) ; end circle-right-partner-swap


(slide-through-partner-swap
  (params nil)
  (preconds (and (mixing-ok)
                 (swap slide-through)
                 (prev-motion slide-through)
                 (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>)
            )
  )
  (effects ((del (swap slide-through))
            (add (swap no))
            (del (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>))
            (add (partners <p5> <p6> <p7> <p8> <p1> <p2> <p3> <p4>))
           )
  )
) ; end slide-through-partner-swap


(cross-through-partner-swap
  (params nil)
  (preconds (and (mixing-ok)
                 (swap cross-through)
                 (prev-motion cross-through)
                 (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>)
            )
  )
  (effects ((del (swap cross-through))
            (add (swap no))
            (del (partners <p1> <p2> <p3> <p4> <p5> <p6> <p7> <p8>))
            (add (partners <p5> <p2> <p7> <p4> <p1> <p6> <p3> <p8>))
           )
  )
) ; end cross-through-partner-swap


                 ))

(setq *INFERENCE-RULES* '(


(infer-end-with-original-partners
  (params nil)
  (preconds (partners 1 2 3 4 5 6 7 8)
  )
  (effects ((add (end-with-original-partners))
           )
  )
)


                 ))
