;; sc-rules9.lisp

(setq *SCR-NODE-SELECT-RULES* nil)

(setq *SCR-GOAL-SELECT-RULES* '(
;; Default control rule for Prodigy.
      (SELECT-FIRST-GOAL
           (lhs (and (current-node <node>)
                     (not-top-level-node <node>)
                     (primary-candidate-goal <node> <goal>)
                )
           )
           (rhs (select goal <goal>)
           )
      )

                               )
)

(setq *SCR-OP-SELECT-RULES* '(
;; The following seven operator selection rules greatly reduce search.  For
;; any '(follows <m1> <m2>)' goal (where <m1> and <m2> are motions), there
;; is one and only one of the seven <motion>-to-<motion> operators that
;; apply.  Since all seven operators will match a goal of this form, these
;; rules are necessary to select that one operator.
      (select-left-to-left-to-satisfy-follow-left-left
           (lhs (and (current-node <node>)
                     (known <node> (motion <m1> left))
                     (known <node> (motion <m2> left))
                     (current-goal <node> (follows <m1> <m2>))
                     (candidate-op <node> left-to-left) ;just to be sure
                )
           )
           (rhs (select operator left-to-left)
           )
      )

      (select-right-to-right-to-satisfy-follow-right-right
           (lhs (and (current-node <node>)
                     (known <node> (motion <m1> right))
                     (known <node> (motion <m2> right))
                     (current-goal <node> (follows <m1> <m2>))
                     (candidate-op <node> right-to-right) ;just to be sure
                )
           )
           (rhs (select operator right-to-right)
           )
      )

      (select-neutral-to-neutral-to-satisfy-follow-neutral-neutral
           (lhs (and (current-node <node>)
                     (known <node> (motion <m1> neutral))
                     (known <node> (motion <m2> neutral))
                     (current-goal <node> (follows <m1> <m2>))
                     (candidate-op <node> neutral-to-neutral) ;just to be sure
                )
           )
           (rhs (select operator neutral-to-neutral)
           )
      )

      (select-neutral-to-left-to-satisfy-follow-neutral-left
           (lhs (and (current-node <node>)
                     (known <node> (motion <m1> neutral))
                     (known <node> (motion <m2> left))
                     (current-goal <node> (follows <m1> <m2>))
                     (candidate-op <node> neutral-to-left) ;just to be sure
                )
           )
           (rhs (select operator neutral-to-left)
           )
      )

      (select-left-to-neutral-to-satisfy-follow-left-neutral
           (lhs (and (current-node <node>)
                     (known <node> (motion <m1> left))
                     (known <node> (motion <m2> neutral))
                     (current-goal <node> (follows <m1> <m2>))
                     (candidate-op <node> left-to-neutral) ;just to be sure
                )
           )
           (rhs (select operator left-to-neutral)
           )
      )

      (select-neutral-to-right-to-satisfy-follow-neutral-right
           (lhs (and (current-node <node>)
                     (known <node> (motion <m1> neutral))
                     (known <node> (motion <m2> right))
                     (current-goal <node> (follows <m1> <m2>))
                     (candidate-op <node> neutral-to-right) ;just to be sure
                )
           )
           (rhs (select operator neutral-to-right)
           )
      )

      (select-right-to-neutral-to-satisfy-follow-right-neutral
           (lhs (and (current-node <node>)
                     (known <node> (motion <m1> right))
                     (known <node> (motion <m2> neutral))
                     (current-goal <node> (follows <m1> <m2>))
                     (candidate-op <node> right-to-neutral) ;just to be sure
                )
           )
           (rhs (select operator right-to-neutral)
           )
      )

;; The following two operator selection rules handle the end cases of the
;; dance motion chain.  At each end only a single operator is applicable,
;; but many would match.  These rules select the single correct operator.
      (select-square-up-start-to-satisfy-follow-square-up-<anything>
           (lhs (and (current-node <node>)
                     (known <node> (motion <m1> <d1>))
                     (current-goal <node> (follows square-up <m1>))
                     (candidate-op <node> square-up-start) ;just to be sure
                )
           )
           (rhs (select operator square-up-start)
           )
      )

      (select-finish-dance-to-satisfy-follow-<anything>-end
           (lhs (and (current-node <node>)
                     (known <node> (motion <m1> <d1>))
                     (current-goal <node> (follows <m1> end))
                     (candidate-op <node> finish-dance) ;just to be sure
                )
           )
           (rhs (select operator finish-dance)
           )
      )

                             )
)

(setq *SCR-BINDINGS-SELECT-RULES* nil)

(setq *SCR-NODE-REJECT-RULES* nil)

(setq *SCR-GOAL-REJECT-RULES* '(
;; These three goal rejection rules eliminate goals of the form:
;;           (follows <left-motion> <right-motion>) and
;;           (follows <right-motion> <left-motion>) and
;;           (follows square-up square-up).
;; Goals of this form are not legal in the domain and should therefore
;; never be considered.
      (reject-illegal-goal-follow-left-right
           (lhs (and (current-node <node>)
                     (known <node> (motion <m1> left))
                     (known <node> (motion <m2> right))
                     (candidate-goal <node> (follows <m1> <m2>))
                )
           )
           (rhs (reject goal (follows <m1> <m2>))
           )
      )

      (reject-illegal-goal-follow-right-left
           (lhs (and (current-node <node>)
                     (known <node> (motion <m1> right))
                     (known <node> (motion <m2> left))
                     (candidate-goal <node> (follows <m1> <m2>))
                )
           )
           (rhs (reject goal (follows <m1> <m2>))
           )
      )

      (reject-illegal-goal-follow-square-up-square-up
           (lhs (and (current-node <node>)
                     (candidate-goal <node> (follows square-up square-up))
                )
           )
           (rhs (reject goal (follows square-up square-up))
           )
      )
                               )
)
(setq *SCR-OP-REJECT-RULES* '(
                             )
)

(setq *SCR-BINDINGS-REJECT-RULES* nil)

(setq *SCR-NODE-PREFERENCE-RULES* nil)

(setq *SCR-GOAL-PREFERENCE-RULES* '(
;; The following goal preference rule is an attempt to ensure that all
;; goals are looked at before Prodigy actually applies the first operator.
      (prefer-all-follow-goals-over-follow-square-up-<anything>
           (lhs (and (current-node <node>)
                     (known <node> (motion <m1> <d1>))
                     (known <node> (motion <m2> <d2>))
                     (not-equal <m1> square-up)
                     (not-equal <m2> square-up)
                     (candidate-goal <node> (follows square-up <m2>))
                     (candidate-goal <node> (follows <m1> <m2>))
                )
           )
           (rhs (prefer goal (follows <m1> <m2>) (follows square-up <m2>))
           )
      )

;; The following goal preference rule is an attempt to favor top-level goals
;; over non-top-level goals.
      (prefer-top-level-goals-over-non-top-level-goals
           (lhs (and (current-node <node>)
                     (known <node> (motion <m1> <d1>))
                     (known <node> (motion <m2> <d2>))
                     (known <node> (motion <m3> <d3>))
                     (not-equal <m1> square-up)
                     (not-equal <m2> square-up)
                     (not-equal <m3> square-up)
                     (is-top-level-goal <node> (used <m1>))
                     (~ (is-top-level-goal <node> (used <m2>)))
                     (candidate-goal <node> (follows <m1> <m3>))
                     (candidate-goal <node> (follows <m2> <m3>))
                )
           )
           (rhs (prefer goal (follows <m1> <m3>) (follows <m2> <m3>))
           )
      )
                                   )
)

(setq *SCR-OP-PREFERENCE-RULES* '(
;; The following four operator preference rules are intended to increase
;; the aesthetic appeal of dance solutions by prefering pairs of adjacent
;; motions that are differently directed, rather than identically directed.
      (prefer-left-to-neutral-over-neutral-to-neutral
           (lhs (and (current-node <node>)
                     (candidate-op <node> left-to-neutral)
                     (candidate-op <node> neutral-to-neutral)
                )
           )
           (rhs (prefer operator left-to-neutral neutral-to-neutral)
           )
      )

      (prefer-right-to-neutral-over-neutral-to-neutral
           (lhs (and (current-node <node>)
                     (candidate-op <node> right-to-neutral)
                     (candidate-op <node> neutral-to-neutral)
                )
           )
           (rhs (prefer operator right-to-neutral neutral-to-neutral)
           )
      )

      (prefer-neutral-to-left-over-left-to-left
           (lhs (and (current-node <node>)
                     (candidate-op <node> neutral-to-left)
                     (candidate-op <node> left-to-left)
                )
           )
           (rhs (prefer operator neutral-to-left left-to-left)
           )
      )

      (prefer-neutral-to-right-over-right-to-right
           (lhs (and (current-node <node>)
                     (candidate-op <node> neutral-to-right)
                     (candidate-op <node> right-to-right)
                )
           )
           (rhs (prefer operator neutral-to-right right-to-right)
           )
      )

;; Need to make sure that square-up-start does not get chosen as an operator
;; until no other operators can be applied.
      (prefer-all-operators-over-square-up-start
           (lhs (and (current-node <node>)
                     (candidate-op <node> square-up-start)
                     (candidate-op <node> <op>)
                )
           )
           (rhs (prefer operator <op> square-up-start)
           )
      )

                             )
)

(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)
