;; domain9.lisp

;; Operators

(setq *OPERATORS* '(


;; Must be the last link in a complete dance.
(finish-dance
  (params (<m2>))
  (preconds (and (motion <m1> <d1>)
                 (motion <m2> <d2>)
                 (not-same <m1> <m2>)
                 (not-same square-up <m2>)
                 (follows <m1> <m2>)
            )
  )
  (effects ((add (follows <m2> end))
           )
  )
) ; end finish-dance


;; Operator to perform an appropriate motion from a neutral to a left.
;; The (not-same <m2> <m3>) precondition is not strictly necessary unless
;; there are motions that are both left and neutral.
(neutral-to-left
  (params (<m2> <m3>))
  (preconds (and (motion <m1> <d1>)
                 (motion <m2> neutral)
                 (not-same <m1> <m2>)
                 (not-same square-up <m2>)
                 (motion <m3> left)
                 (not-same <m2> <m3>) ;see comment above
                 (not-same <m1> <m3>)
                 (follows <m1> <m2>)
            )
  )
  (effects ((add (follows <m2> <m3>))
            (add (used <m3>))
           )
  )
) ; end neutral-to-left


;; Operator to perform an appropriate motion from a neutral to a right.
;; The (not-same <m2> <m3>) precondition is not strictly necessary unless
;; there are motions that are both right and neutral.
(neutral-to-right
  (params (<m2> <m3>))
  (preconds (and (motion <m1> <d1>)
                 (motion <m2> neutral)
                 (not-same <m1> <m2>)
                 (not-same square-up <m2>)
                 (motion <m3> right)
                 (not-same <m2> <m3>) ;see comment above
                 (not-same <m1> <m3>)
                 (follows <m1> <m2>)
            )
  )
  (effects ((add (follows <m2> <m3>))
            (add (used <m3>))
           )
  )
) ; end neutral-to-right


;; Operator to perform an appropriate motion from a left to a neutral.
;; The (not-same <m2> <m3>) precondition is not strictly necessary unless
;; there are motions that are both left and neutral.
(left-to-neutral
  (params (<m2> <m3>))
  (preconds (and (motion <m1> <d1>)
                 (not-same <d1> right)
                 (motion <m2> left)
                 (not-same <m1> <m2>)
                 (not-same square-up <m2>)
                 (motion <m3> neutral)
                 (not-same <m2> <m3>) ;see comment above
                 (not-same <m1> <m3>)
                 (follows <m1> <m2>)
            )
  )
  (effects ((add (follows <m2> <m3>))
            (add (used <m3>))
           )
  )
) ; end left-to-neutral


;; Operator to perform an appropriate motion from a right to a neutral.
;; The (not-same <m2> <m3>) precondition is not strictly necessary unless
;; there are motions that are both right and neutral.
(right-to-neutral
  (params (<m2> <m3>))
  (preconds (and (motion <m1> <d1>)
                 (not-same <d1> left)
                 (motion <m2> right)
                 (not-same <m1> <m2>)
                 (not-same square-up <m2>)
                 (motion <m3> neutral)
                 (not-same <m2> <m3>) ;see comment above
                 (not-same <m1> <m3>)
                 (follows <m1> <m2>)
            )
  )
  (effects ((add (follows <m2> <m3>))
            (add (used <m3>))
           )
  )
) ; end right-to-neutral


;; Operator to perform an appropriate motion from a neutral to a neutral.
;; The (not-same <m2> <m3>) precondition is necessary here.
(neutral-to-neutral
  (params (<m2> <m3>))
  (preconds (and (motion <m1> <d1>)
                 (motion <m2> neutral)
                 (not-same <m1> <m2>)
                 (not-same square-up <m2>)
                 (motion <m3> neutral)
                 (not-same <m2> <m3>) ;see comment above
                 (not-same <m1> <m3>)
                 (follows <m1> <m2>)
            )
  )
  (effects ((add (follows <m2> <m3>))
            (add (used <m3>))
           )
  )
) ; end neutral-to-neutral


;; Operator to perform an appropriate motion from a left to a left.
;; The (not-same <m2> <m3>) precondition is necessary here.
(left-to-left
  (params (<m2> <m3>))
  (preconds (and (motion <m1> <d1>)
                 (not-same <d1> right)
                 (motion <m2> left)
                 (not-same <m1> <m2>)
                 (not-same square-up <m2>)
                 (motion <m3> left)
                 (not-same <m2> <m3>) ;see comment above
                 (not-same <m1> <m3>)
                 (follows <m1> <m2>)
            )
  )
  (effects ((add (follows <m2> <m3>))
            (add (used <m3>))
           )
  )
) ; end left-to-left


;; Operator to perform an appropriate motion from a right to a right.
;; The (not-same <m2> <m3>) precondition is necessary here.
(right-to-right
  (params (<m2> <m3>))
  (preconds (and (motion <m1> <d1>)
                 (not-same <d1> left)
                 (motion <m2> right)
                 (not-same <m1> <m2>)
                 (not-same square-up <m2>)
                 (motion <m3> right)
                 (not-same <m2> <m3>) ;see comment above
                 (not-same <m1> <m3>)
                 (follows <m1> <m2>)
            )
  )
  (effects ((add (follows <m2> <m3>))
            (add (used <m3>))
           )
  )
) ; end right-to-right


;; Must be the first step in a complete dance.
(square-up-start
  (params (<m1>))
  (preconds (motion <m1> <d1>)
  )
  (effects ((add (follows square-up <m1>))
            (add (used <m1>))
           )
  )
) ; end square-up-start


;; Final operator to complete the dance.
(complete-dance
  (params nil)
  (preconds (and (motion <m1> <d1>)
                 (follows <m1> end)
                 (forall (<m2> <d2>) (motion <m2> <d2>)
                         (and (not-same <m2> square-up)
                              (used <m2>)
                         )
                 )
            )
  )
  (effects ((add (dance-complete))
           )
  )
) ; end complete-dance


                 ))

(setq *INFERENCE-RULES* nil)
