;; -----------------------------------------------------------
;; -----------------------------------------------------------
;;
;;   Kristine Hauff -- c473al
;;   May 17, 1991
;;   Domain:  Sewing different articles of clothing
;;   File:  domain.lisp, which lists all of the operators
;;
;; -----------------------------------------------------------
;; -----------------------------------------------------------

;; This sewing domain is able to sew a dress, a shirt, a skirt, pants,
;; and/or shorts given an amount of fabric, a pattern, thread, and any
;; extra notions desired (buttons, elastic, lace, or zipper).  
;; Given an amount of fabric in inches, this domain will complete a
;; garment if enough fabric is given and fail if it does not.  Also,
;; more than one garment can be sewn at the same time since the garment
;; is associated with its thread, fabric, the amount of fabric, notions,
;; pattern, and pattern size.  Any garment can have no notions or one 
;; choice from all of the notions.

(setq *OPERATORS* '(

;; -----------------------------------------------------------
;;    Layout Fabric
;; -----------------------------------------------------------


  (LAYOUT-FABRIC
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-fabric <garment> <fabric>)
           (have-surface <table>)))
      (effects (
           (add (fabric-layed-out <garment> <fabric>)))))

;; -----------------------------------------------------------
;;    Cut out the given pattern for garment piece
;; -----------------------------------------------------------

  (CUT-PATTERN
    (params (<garment> <pattern-piece>))
    (preconds
      (and
           (have-garment <garment>)
           (have-pattern <garment> <pattern>)
           (have-cutting-tool <scissors>)))
      (effects (
           (add (pattern-cut-out <garment> <pattern-piece> <size>))
           (add (pattern-pinnable <garment> <pattern-piece>)))))


;; -----------------------------------------------------------
;;    Pin and unpin items together
;; -----------------------------------------------------------

;; The predicate pattern-cut-out is a non-static generator for patternpiece
;; and size because it gets added to the state in the CUT-PATTERN operator.
;; It has to be non-static for the following reason:  given a pattern that
;; contains all of the individual pattern pieces stamped on it, each piece
;; must be cut apart from the original pattern sheet.  Because more pattern
;; pieces exist than the original pattern, a non-static generator must be 
;; used.

  (PIN-PATTERN-TO-FABRIC
    (params ( <garment> <patternpiece> <fabric>))
    (preconds
      (and
           (have-garment <garment>)
           (have-fabric <garment> <fabric>)
           (pattern-cut-out <garment> <patternpiece> <size>)
           (pattern-pinnable <garment> <patternpiece>)
           (fabric-pinnable <garment> <fabric>)
           (fabric-layed-out <garment> <fabric>)))
      (effects (
           (add (pattern-and-fabric-pinned <garment> <patternpiece> <fabric>)))))


  (UNPIN-PATTERN-FROM-FABRIC
    (params ( <garment> <patternpiece> <fabric>))
    (preconds
      (and
           (have-garment <garment>)
           (have-fabric <garment> <fabric>)
           (pattern-cut-out <garment> <patternpiece> <size>)
           (pattern-and-fabric-pinned <garment> <patternpiece> <fabric>)))
      (effects (
           (del (pattern-and-fabric-pinned <garment> <patternpiece> <fabric>)))))


;; Both predicates have-fabric-piece and have-fabric-part are non-static
;; generators since they both get added and deleted.  In the CUT-FABRIC
;; operator an individual fabric piece cut out by a pattern is created
;; from the original fabric piece.  Because more fabric pieces are cut
;; out of the original fabric piece, a non-static generator must be used.
;; When the individual fabric pieces are sewn together, together they form
;; a fabric part (have-fabric-part).  Thus two items forming one must use
;; a non-static generator to represent the final product.

  (PIN-FABRIC-TO-FABRIC
    (params ( <garment> <fabric1> <fabric2>))
    (preconds
      (and
           (have-garment <garment>)
           (or (have-fabric-piece <garment> <fabric1> <size>)
               (have-fabric-part <garment> <fabric1>))
           (or (have-fabric-piece <garment> <fabric2> <size>)
               (have-fabric-part <garment> <fabric2>))
           (fabric-pinnable <garment> <fabric1>)
           (fabric-pinnable <garment> <fabric2>)))
      (effects (
           (add (fabrics-pinned <garment> <fabric1> <fabric2>)))))


  (UNPIN-FABRIC-FROM-FABRIC
    (params ( <garment> <fabric1> <fabric2>))
    (preconds
      (and
           (have-garment <garment>)
           (or (have-fabric-piece <garment> <fabric1> <size>)
               (have-fabric-part <garment> <fabric1>))
           (or (have-fabric-piece <garment> <fabric2> <size>)
               (have-fabric-part <garment> <fabric2>))
           (fabrics-pinned <garment> <fabric1> <fabric2>)))
      (effects (
           (del (fabrics-pinned <garment> <fabric1> <fabric2>))
           (del (have-fabric-piece <garment> <fabric1> <size>))
           (del (have-fabric-piece <garment> <fabric2> <size>)))))

;; ---------------------------------------------------------------
;;    Cut the fabric after patterns have been layed out on fabric
;; ---------------------------------------------------------------

;; Amount-of-fabric must be a non-static generator since the state can only
;; contain one value for the amount of fabric that a piece contains.  Hence
;; when a new value is calculated the old value must be deleted from the 
;; state and the new value must be added.  Because this value is bound to
;; only one garment's fabric piece, it will not cause problems when the
;; values bind since the fabric-amount is always associated with the garment.

;; Every time a fabric piece is cut from the original fabric piece, the 
;; size of the original fabric decrements.  Hence functions have been
;; written to calculate the size of the piece needed to be cut off of the 
;; fabric piece and to decrement this amount from the original amount of
;; fabric.  If the current fabric amount available is less than the size 
;; of the piece needed, then this garment cannot be produced.  There is 
;; only one amount of fabric value for the fabric at a time.


  (CUT-FABRIC
    (params ( <garment> <pattern> <amount-left> <new-amount-left>))
    (preconds
      (and
           (have-garment <garment>)
           (have-pattern-size <garment> <garment-size>)
           (have-fabric <garment> <fabric>)
           (have-cutting-tool <scissors>)
           (pattern-cut-out <garment> <pattern> <size>)
           (fabric-layed-out <garment> <fabric>)
           (pattern-and-fabric-pinned <garment> <pattern> <fabric>)
           (amount-of-fabric <garment> <fabric> <amount-left>)
           (calc-pattern-size <size> <garment-size> <total-size>)
           (calc-new-fabric-amount <amount-left> <total-size> <new-amount-left>)
           (greater-than <amount-left> <total-size>)))
      (effects (
           (add (have-fabric-piece <garment> <pattern> <size>))
           (add (fabric-pinnable <garment> <pattern>))
           (add (amount-of-fabric <garment> <fabric> <new-amount-left>))
           (del (amount-of-fabric <garment> <fabric> <amount-left>)))))



;; --------------------------------------------------
;;    Machine operations
;; --------------------------------------------------

  (THREAD-MACHINE
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-machine <machine>)
           (have-thread <garment> <thread>)))
      (effects (         
           (add (machine-threaded <garment> <machine>)))))


;; This operator sets the stitch that the machine is currently using.
;; Hence it may only have one stitch, such as a straight stitch, a large 
;; straight stitch, a basting stitch, or a zigzag stitch, at a time.


  (SET-MACHINE
    (params (<stitch>))
    (preconds
      (and
           (have-machine <machine>)
           (sewing-stitch <stitch>)))
      (effects (
           (del (machine-stitch-set  <*other-stitch>))
           (add (machine-stitch-set  <stitch>)))))


;; --------------------------------------------------
;;    Sew items together 
;; --------------------------------------------------

;; -----------------
;; SEW-DRESS sews an uncompleted dress (no hemming or serging done) by
;; combining a shirt and a skirt together.  Thus it is the first operator
;; since only a dress pattern may be applied here whereas a shirt and a 
;; skirt can take either themselves or the dress pattern.  This is how
;; many dresses are designed in the real world (with modifications).

;; Before the complete dress can be sewn, SEW-DRESS checks the technique
;; chosen for sewing the bottom part of the dress. A dress can only have
;; a gathered or pleated bottom, not a straight skirt.


  (SEW-DRESS
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-pattern <garment> <pattern>)
;;           matches <pattern> DRESS-PATTERN
           (have-machine <machine>)
           (machine-threaded <garment> <machine>)
           (shirt-sewn <garment> SHIRT)
           (skirt-sewn <garment> SKIRT)
           (skirt-technique <kind>)
           (technique-completed <garment> <kind>)
           (~ (technique-completed <garment> STRAIGHT-BAND))
           (~ (fabrics-pinned <garment> LEFT-SLEEVES BODICE))
           (~ (fabrics-pinned <garment> RIGHT-SLEEVES BODICE))
           (fabrics-pinned <garment> SHIRT SKIRT)
           (machine-stitch-set STRAIGHT)))
      (effects (
           (del (shirt-sewn <garment> SHIRT))
           (del (skirt-sewn <garment> SKIRT))
           (del (fabric-pinnable <garment> SHIRT))
           (del (fabric-pinnable <garment> SKIRT))
           (add (garment-sewn <garment>))
           (add (have-fabric-part <garment> <garment>)))))


;; -----------------
;; Sews both the left and right sleeves.

  (SEW-SLEEVES
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-fabric <garment> <fabric>)
           (have-pattern <garment> <pattern>)
;;           or matches <pattern> SHIRT-PATTERN
;;               matches <pattern> DRESS-PATTERN
           (have-machine <machine>)
           (machine-threaded <garment> <machine>)
           (machine-stitch-set STRAIGHT)
           (have-fabric-piece <garment> LEFT-FRONT-SLEEVES 10)
           (~ (pattern-and-fabric-pinned <garment> LEFT-FRONT-SLEEVES <fabric>))
           (have-fabric-piece <garment> RIGHT-FRONT-SLEEVES 10)
           (~ (pattern-and-fabric-pinned <garment> RIGHT-FRONT-SLEEVES <fabric>))
           (have-fabric-piece <garment> LEFT-BACK-SLEEVES 10)
           (~ (pattern-and-fabric-pinned <garment> LEFT-BACK-SLEEVES <fabric>))
           (have-fabric-piece <garment> RIGHT-BACK-SLEEVES 10) 
           (~ (pattern-and-fabric-pinned <garment> RIGHT-BACK-SLEEVES <fabric>))
           (fabrics-pinned <garment> LEFT-FRONT-SLEEVES LEFT-BACK-SLEEVES)
           (fabrics-pinned <garment> RIGHT-FRONT-SLEEVES RIGHT-BACK-SLEEVES)))
      (effects (
           (add (sleeves-sewn <garment> LEFT-SLEEVES))
           (add (sleeves-sewn <garment> RIGHT-SLEEVES))
           (add (have-fabric-part <garment> LEFT-SLEEVES))
           (add (have-fabric-part <garment> RIGHT-SLEEVES))
           (add (fabric-pinnable <garment> LEFT-SLEEVES))
           (add (fabric-pinnable <garment> RIGHT-SLEEVES)))))


;; -----------------
;; Sews the individual left and right bodices, each from two other pieces.

  (SEW-BODICE-SIDES
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-fabric <garment> <fabric>)
           (have-pattern <garment> <pattern>)
;;           or matches <pattern> SHIRT-PATTERN
;;               matches <pattern> DRESS-PATTERN
           (have-machine <machine>)
           (machine-threaded <garment> <machine>)
           (machine-stitch-set STRAIGHT)
           (have-fabric-piece <garment> LEFT-FRONT-BODICE 18)
           (~ (pattern-and-fabric-pinned <garment> LEFT-FRONT-BODICE <fabric>))
           (have-fabric-piece <garment> RIGHT-FRONT-BODICE 18)
           (~ (pattern-and-fabric-pinned <garment> RIGHT-FRONT-BODICE <fabric>))
           (have-fabric-piece <garment> LEFT-BACK-BODICE 18) 
           (~ (pattern-and-fabric-pinned <garment> LEFT-BACK-BODICE <fabric>))
           (have-fabric-piece <garment> RIGHT-BACK-BODICE 18) 
           (~ (pattern-and-fabric-pinned <garment> RIGHT-BACK-BODICE <fabric>))
           (fabrics-pinned <garment> LEFT-FRONT-BODICE LEFT-BACK-BODICE)
           (fabrics-pinned <garment> RIGHT-FRONT-BODICE RIGHT-BACK-BODICE)))
      (effects (
           (add (bodice-side-sewn <garment> LEFT-BODICE))
           (add (bodice-side-sewn <garment> RIGHT-BODICE))
           (add (have-fabric-part <garment> LEFT-BODICE))
           (add (have-fabric-part <garment> RIGHT-BODICE))
           (add (fabric-pinnable <garment> LEFT-BODICE))
           (add (fabric-pinnable <garment> RIGHT-BODICE)))))


;; -----------------
;; Combines the left and the right bodice parts that were created in the
;; above operator.

  (SEW-BODICE
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-pattern <garment> <pattern>)
;;           or matches <pattern> SHIRT-PATTERN
;;               matches <pattern> DRESS-PATTERN
           (have-machine <machine>)
           (machine-threaded <garment> <machine>)
           (bodice-side-sewn <garment> LEFT-BODICE)
           (bodice-side-sewn <garment> RIGHT-BODICE)
           (~ (fabrics-pinned <garment> LEFT-FRONT-BODICE LEFT-BACK-BODICE))
           (~ (fabrics-pinned <garment> RIGHT-FRONT-BODICE RIGHT-BACK-BODICE))
           (ends-surged <garment> LEFT-BODICE)
           (ends-surged <garment> RIGHT-BODICE)
           (fabrics-pinned <garment> LEFT-BODICE RIGHT-BODICE)
           (machine-stitch-set STRAIGHT)))
      (effects (
           (del (bodice-side-sewn <garment> LEFT-BODICE))
           (del (bodice-side-sewn <garment> RIGHT-BODICE))
           (del (fabric-pinnable <garment> LEFT-BODICE))
           (del (fabric-pinnable <garment> RIGHT-BODICE))
           (add (bodice-sewn <garment> BODICE))
           (add (have-fabric-part <garment> BODICE))
           (add (fabric-pinnable <garment> BODICE)))))


;; -----------------
;; Combines the completed left and right sleeves to the sewn bodice to make
;; a shirt or the top part of a dress.

  (SEW-SLEEVES-TO-BODICE
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-machine <machine>)
           (have-pattern <garment> <pattern>)
           (or (matches <pattern> SHIRT-PATTERN)
               (matches <pattern> DRESS-PATTERN))
           (machine-threaded <garment> <machine>)
           (sleeves-sewn <garment> LEFT-SLEEVES)
           (sleeves-sewn <garment> RIGHT-SLEEVES)
           (~ (fabrics-pinned <garment> LEFT-FRONT-SLEEVES LEFT-BACK-SLEEVES))
           (~ (fabrics-pinned <garment> RIGHT-FRONT-SLEEVES RIGHT-BACK-SLEEVES))
           (ends-surged <garment> LEFT-SLEEVES)
           (ends-surged <garment> RIGHT-SLEEVES)
           (bodice-sewn <garment> BODICE)
           (~ (fabrics-pinned <garment> LEFT-BODICE RIGHT-BODICE))
           (ends-surged <garment> BODICE)
           (fabrics-pinned <garment> LEFT-SLEEVES BODICE)
           (fabrics-pinned <garment> RIGHT-SLEEVES BODICE)
           (machine-stitch-set STRAIGHT)))
      (effects (
           (del (sleeves-sewn <garment> LEFT-SLEEVES))
           (del (sleeves-sewn <garment> RIGHT-SLEEVES))
           (del (bodice-sewn <garment> BODICE))
           (if (matches <pattern> SHIRT-PATTERN)
               (add (garment-sewn <garment>))
               (add (fabric-pinnable <garment> <garment>))
               (add (have-fabric-part <garment> <garment>)))
           (if (matches <pattern> DRESS-PATTERN)
               (add (shirt-sewn <garment> <shirt>))
               (add (have-fabric-part <garment> <shirt>))
               (add (fabric-pinnable <garment> <shirt>))))))


;; -----------------
;; Sews the individual left and right pant parts, each from two other pieces.


  (SEW-PANT-SIDES
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-fabric <garment> <fabric>)
           (have-pattern <garment> <pattern>)
;;           matches <pattern> PANT-PATTERN
           (have-machine <machine>)
           (machine-threaded <garment> <machine>)
           (machine-stitch-set STRAIGHT)
           (have-fabric-piece <garment> LEFT-FRONT-PANT 68)
           (~ (pattern-and-fabric-pinned <garment> LEFT-FRONT-PANT <fabric>))
           (have-fabric-piece <garment> RIGHT-FRONT-PANT 68)
           (~ (pattern-and-fabric-pinned <garment> RIGHT-FRONT-PANT <fabric>))
           (have-fabric-piece <garment> LEFT-BACK-PANT 68) 
           (~ (pattern-and-fabric-pinned <garment> LEFT-BACK-PANT <fabric>))
           (have-fabric-piece <garment> RIGHT-BACK-PANT 68) 
           (~ (pattern-and-fabric-pinned <garment> RIGHT-BACK-PANT <fabric>))
           (fabrics-pinned <garment> LEFT-FRONT-PANT LEFT-BACK-PANT)
           (fabrics-pinned <garment> RIGHT-FRONT-PANT RIGHT-BACK-PANT)))
      (effects (
           (add (pant-side-sewn <garment> LEFT-PANT))
           (add (pant-side-sewn <garment> RIGHT-PANT))
           (add (have-fabric-part <garment> LEFT-PANT))
           (add (have-fabric-part <garment> RIGHT-PANT))
           (add (fabric-pinnable <garment> LEFT-PANT))
           (add (fabric-pinnable <garment> RIGHT-PANT)))))


;; -----------------
;; Combines the left and the right pant parts that were created in the
;; above operator.           

  (SEW-PANTS
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-machine <machine>)
           (have-pattern <garment> <pattern>)
;;           matches <pattern> PANT-PATTERN
           (machine-threaded <garment> <machine>)
           (pant-side-sewn <garment> LEFT-PANT)
           (pant-side-sewn <garment> RIGHT-PANT)
           (~ (fabrics-pinned <garment> LEFT-FRONT-PANT LEFT-BACK-PANT))
           (~ (fabrics-pinned <garment> RIGHT-FRONT-PANT RIGHT-BACK-PANT))
           (ends-surged <garment> LEFT-PANT)
           (ends-surged <garment> RIGHT-PANT)
           (fabrics-pinned <garment> LEFT-PANT RIGHT-PANT)
           (machine-stitch-set STRAIGHT)))
      (effects (
           (del (pant-side-sewn <garment> LEFT-PANT))
           (del (pant-side-sewn <garment> RIGHT-PANT))
           (del (fabric-pinnable <garment> LEFT-PANT))
           (del (fabric-pinnable <garment> RIGHT-PANT))
           (add (garment-sewn <garment>))
           (add (have-fabric-part <garment> <garment>)))))

;; -----------------
;; Sews the individual left and right short parts, each from two other pieces.
           

  (SEW-SHORT-SIDES
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-fabric <garment> <fabric>)
           (have-pattern <garment> <pattern>)
;;           matches <pattern> SHORT-PATTERN
           (have-machine <machine>)
           (machine-threaded <garment> <machine>)
           (machine-stitch-set STRAIGHT)
           (have-fabric-piece <garment> LEFT-FRONT-SHORT 36)
           (~ (pattern-and-fabric-pinned <garment> LEFT-FRONT-SHORT <fabric>))
           (have-fabric-piece <garment> RIGHT-FRONT-SHORT 36)
           (~ (pattern-and-fabric-pinned <garment> RIGHT-FRONT-SHORT <fabric>))
           (have-fabric-piece <garment> LEFT-BACK-SHORT 36) 
           (~ (pattern-and-fabric-pinned <garment> LEFT-BACK-SHORT <fabric>))
           (have-fabric-piece <garment> RIGHT-BACK-SHORT 36) 
           (~ (pattern-and-fabric-pinned <garment> RIGHT-BACK-SHORT <fabric>))
           (fabrics-pinned <garment> LEFT-FRONT-SHORT LEFT-BACK-SHORT)
           (fabrics-pinned <garment> RIGHT-FRONT-SHORT RIGHT-BACK-SHORT)))
      (effects (
           (add (short-side-sewn <garment> LEFT-SHORT))
           (add (short-side-sewn <garment> RIGHT-SHORT))
           (add (have-fabric-part <garment> LEFT-SHORT))
           (add (have-fabric-part <garment> RIGHT-SHORT))
           (add (fabric-pinnable <garment> LEFT-SHORT))
           (add (fabric-pinnable <garment> RIGHT-SHORT)))))


;; -----------------
;; Combines the left and the right short parts that were created in the
;; above operator.           

  (SEW-SHORTS
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-pattern <garment> <pattern>)
;;           matches <pattern> SHORT-PATTERN
           (have-machine <machine>)
           (machine-threaded <garment> <machine>)
           (short-side-sewn <garment> LEFT-SHORT)
           (short-side-sewn <garment> RIGHT-SHORT)
           (~ (fabrics-pinned <garment> LEFT-FRONT-SHORT LEFT-BACK-SHORT))
           (~ (fabrics-pinned <garment> RIGHT-FRONT-SHORT RIGHT-BACK-SHORT))
           (ends-surged <garment> LEFT-SHORT)
           (ends-surged <garment> RIGHT-SHORT)
           (fabrics-pinned <garment> LEFT-SHORT RIGHT-SHORT)
           (machine-stitch-set STRAIGHT)))
      (effects (
           (del (short-side-sewn <garment> LEFT-SHORT))
           (del (short-side-sewn <garment> RIGHT-SHORT))
           (del (fabric-pinnable <garment> LEFT-SHORT))
           (del (fabric-pinnable <garment> RIGHT-SHORT))
           (add (garment-sewn <garment>))
           (add (have-fabric-part <garment> <garment>)))))


;; -----------------
;; Sews the individual left and right skirt parts, each from two other pieces.


  (SEW-SKIRT-SIDES
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-fabric <garment> <fabric>)
           (have-pattern <garment> <pattern>)
;;           or matches <pattern> SKIRT-PATTERN
;;               matches <pattern> DRESS-PATTERN
           (have-machine <machine>)
           (machine-threaded <garment> <machine>)
           (machine-stitch-set STRAIGHT)
           (have-fabric-piece <garment> LEFT-FRONT-SKIRT 52)
           (~ (pattern-and-fabric-pinned <garment> LEFT-FRONT-SKIRT <fabric>))
           (have-fabric-piece <garment> RIGHT-FRONT-SKIRT 52)
           (~ (pattern-and-fabric-pinned <garment> RIGHT-FRONT-SKIRT <fabric>))
           (have-fabric-piece <garment> LEFT-BACK-SKIRT 52) 
           (~ (pattern-and-fabric-pinned <garment> LEFT-BACK-SKIRT <fabric>))
           (have-fabric-piece <garment> RIGHT-BACK-SKIRT 52) 
           (~ (pattern-and-fabric-pinned <garment> RIGHT-BACK-SKIRT <fabric>))
           (fabrics-pinned <garment> LEFT-FRONT-SKIRT LEFT-BACK-SKIRT)
           (fabrics-pinned <garment> RIGHT-FRONT-SKIRT RIGHT-BACK-SKIRT)))
      (effects (
           (add (skirt-side-sewn <garment> LEFT-SKIRT))
           (add (skirt-side-sewn <garment> RIGHT-SKIRT))
           (add (have-fabric-part <garment> LEFT-SKIRT))
           (add (have-fabric-part <garment> RIGHT-SKIRT))
           (add (fabric-pinnable <garment> LEFT-SKIRT))
           (add (fabric-pinnable <garment> RIGHT-SKIRT)))))


;; -----------------
;; Combines the left and the right skirt parts that were created in the
;; above operator.  Before the complete skirt can be sewn, a technique,
;; such as making a straight skirt, a pleated skirt, or a gathered skirt,
;; must be chosen and completed.  A skirt can have any of these options.


  (SEW-SKIRT
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-pattern <garment> <pattern>)
;;           or matches <pattern> SKIRT-PATTERN
;;               matches <pattern> DRESS-PATTERN
           (have-machine <machine>)
           (skirt-technique <kind>)
           (machine-threaded <garment> <machine>)
           (technique-completed <garment> <kind>)
           (fabrics-pinned <garment> LEFT-SKIRT RIGHT-SKIRT)
           (machine-stitch-set STRAIGHT)))
      (effects (
           (del (skirt-side-sewn <garment> LEFT-SKIRT))
           (del (skirt-side-sewn <garment> RIGHT-SKIRT))
           (del (fabric-pinnable <garment> LEFT-SKIRT))
           (del (fabric-pinnable <garment> RIGHT-SKIRT))
           (if (matches <pattern> SKIRT-PATTERN)
               (add (garment-sewn <garment>))
               (add (have-fabric-part <garment> <garment>)))
           (if (matches <pattern> DRESS-PATTERN)
               (add (skirt-sewn <garment> <skirt>))
               (add (have-fabric-part <garment> <skirt>))
               (add (fabric-pinnable <garment> <skirt>))))))


;; --------------------------------------------------
;;    Different skirt-sewing techniques
;; --------------------------------------------------

;; A skirt or dress can be sewn as a straight skirt with a band, with pleats or
;; with gathers.  While a skirt can have any of these options, a dress can only
;; sew the bottom with pleats or gathers, not a straight skirt.  Because 
;; MAKE-STRAIGHT-BAND is listed as the first operator, Prodigy usually chooses
;; this operator first.  A control rule is used to reject the straight skirt
;; option for a dress to keep it from backtracking an exponential amount of nodes.

  (MAKE-STRAIGHT-BAND
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (skirt-side-sewn <garment> LEFT-SKIRT)
           (skirt-side-sewn <garment> RIGHT-SKIRT)
           (ends-surged <garment> LEFT-SKIRT)
           (ends-surged <garment> RIGHT-SKIRT)
           (~ (fabrics-pinned <garment> LEFT-FRONT-SKIRT LEFT-BACK-SKIRT))
           (~ (fabrics-pinned <garment> RIGHT-FRONT-SKIRT RIGHT-BACK-SKIRT))
           (have-machine <machine>)
           (machine-threaded <garment> <machine>)
           (machine-stitch-set STRAIGHT)))
      (effects (
           (add (technique-completed <garment> STRAIGHT-BAND)))))


  (MAKE-PLEATS
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (skirt-side-sewn <garment> LEFT-SKIRT)
           (skirt-side-sewn <garment> RIGHT-SKIRT)
           (ends-surged <garment> LEFT-SKIRT)
           (ends-surged <garment> RIGHT-SKIRT)
           (~ (fabrics-pinned <garment> LEFT-FRONT-SKIRT LEFT-BACK-SKIRT))
           (~ (fabrics-pinned <garment> RIGHT-FRONT-SKIRT RIGHT-BACK-SKIRT))
           (have-machine <machine>)
           (machine-threaded <garment> <machine>)
           (machine-stitch-set STRAIGHT)))
      (effects (
           (add (technique-completed <garment> PLEATED)))))


  (MAKE-GATHERS
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (skirt-side-sewn <garment> LEFT-SKIRT)
           (skirt-side-sewn <garment> RIGHT-SKIRT)
           (ends-surged <garment> LEFT-SKIRT)
           (ends-surged <garment> RIGHT-SKIRT)
           (~ (fabrics-pinned <garment> LEFT-FRONT-SKIRT LEFT-BACK-SKIRT))
           (~ (fabrics-pinned <garment> RIGHT-FRONT-SKIRT RIGHT-BACK-SKIRT))
           (have-machine <machine>)
           (machine-threaded <garment> <machine>)
           (machine-stitch-set BASTING)))
      (effects (
           (add (technique-completed <garment> GATHERED)))))


;; --------------------------------------------------
;;    Hemming and serging the garment
;; --------------------------------------------------

;; Finishes the bottom edge on the garment by sewing by hand or by
;; machine.  There exists certain times times when it is better to 
;; hem a garment one way or the other. Ex: hemming a skirt by hand
;; looks better than by machine.

  (HEM-BY-MACHINE
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (garment-sewn <garment>)
           (ends-surged <garment> <garment>)
           (have-machine <machine>)
           (machine-threaded <garment> <machine>)
           (machine-stitch-set LRG-STRAIGHT)
           (have-fabric-part <garment> <garment>)))
      (effects (
           (del (garment-sewn <garment>))
           (add (garment-hemmed <garment>)))))


  (HEM-BY-HAND
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-cutting-tool <scissors>)
           (have-needle <needle>)
           (have-thread <garment> <thread>)
           (garment-sewn <garment>)
           (ends-surged <garment> <garment>)
           (have-fabric-part <garment> <garment>)))
      (effects (
           (del (garment-sewn <garment>))
           (add (garment-hemmed <garment>)))))


;; -----------------
;; Finishes the inside seam created when two pieces are sewn together.  This
;; can also be done by hand or by machine.


  (SERGE-ENDS-BY-MACHINE
    (params (<garment> <fabric-part>))
    (preconds
      (and
           (have-garment <garment>)
           (have-fabric-part <garment> <fabric-part>)
           (have-machine <machine>)
           (machine-threaded <garment> <machine>)
           (machine-stitch-set ZIGZAG)))
      (effects (
           (del (fabrics-pinned <garment> <*fabric1> <*fabric1>))
           (add (ends-surged <garment> <fabric-part>)))))


  (SERGE-ENDS-BY-HAND
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-needle <needle>)
           (have-thread <garment> <thread>)
           (have-fabric-part <garment> <garment>)))
      (effects (
           (del (fabrics-pinned <garment> <*fabric1> <*fabric1>))
           (add (ends-surged <garment> <garment>)))))





;; --------------------------------------------------
;;    Add extras to garment
;; --------------------------------------------------

;; hand-sew or machine sew buttons on  -- prefer one over the other in control
;;   rules


  (ADD-NOTHING
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (garment-hemmed <garment>)
           (have-fabric-part <garment> <garment>)))
      (effects (
           (add (with-nothing <garment> <fabric> <amount-left> <pattern>
                                         <garment-size> <thread>)))))


;; The button holes can be cut out by machine, in which case a zigzag
;; pattern is formed on the material where the button goes.  Either
;; scissors or a cutting blade can then be used to open the hole.  

  (CUT-BUTTON-HOLES-BY-MACHINE
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-machine <machine>)
           (machine-stitch-set ZIGZAG)
           (have-cutting-tool <scissors>)
           (have-fabric-part <garment> <garment>)))
      (effects (
           (add (button-holes-cut <garment>)))))


;; To create a button hole by hand, the sewer must cut the hole first and
;; then sew stitches around it so that it will not fray.

  (CUT-BUTTON-HOLES-BY-HAND
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-cutting-tool <scissors>)
           (have-needle <needle>)
           (have-thread <garment> <thread>)
           (have-fabric-part <garment> <garment>)))
      (effects (
           (add (button-holes-cut <garment>)))))
 

  (ADD-BUTTONS
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-buttons <garment> <buttons>)
           (garment-hemmed <garment>)
           (have-fabric-part <garment> <garment>)
           (button-holes-cut  <garment>)))
      (effects (
           (add (with-buttons <garment> <buttons> <fabric> <amount-left>
                              <pattern> <garment-size> <thread>)))))


  (ADD-LACE
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-lace <garment> <lace>)
           (machine-stitch-set STRAIGHT)
           (garment-hemmed <garment>)
           (have-fabric-part <garment> <garment>)))
      (effects (
           (add (with-lace <garment> <lace> <fabric> <amount-left>
                              <pattern> <garment-size> <thread>)))))

  (ADD-ELASTIC
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-elastic <garment> <elastic>)
           (machine-stitch-set BASTING)
           (garment-hemmed <garment>)
           (have-fabric-part <garment> <garment>)))
      (effects (
           (add (with-elastic <garment> <elastic> <fabric> <amount-left>
                              <pattern> <garment-size> <thread>)))))

  (ADD-ZIPPER
    (params (<garment>))
    (preconds
      (and
           (have-garment <garment>)
           (have-zipper <garment> <zipper>)
           (machine-stitch-set STRAIGHT)
           (garment-hemmed <garment>)
           (have-fabric-part <garment> <garment>)))
      (effects (
           (add (with-zipper <garment> <zipper> <fabric> <amount-left>
                              <pattern> <garment-size> <thread>)))))


))

(setq *INFERENCE-RULES* nil)








