
(setq *SCR-NODE-SELECT-RULES* nil)

;; Default control rule for Prodigy.
(setq *SCR-GOAL-SELECT-RULES* '(
      (SELECT-FIRST-GOAL
           (lhs (and (current-node <node>)
                     (not-top-level-node <node>)
                     (primary-candidate-goal <node> <goal>)
                )
           )
           (rhs (select goal <goal>))
           )
                               )
)

;; The following operator selection rules are designed to channel Prodigy's
;; search along more productive lines.  The goal '(swap no)'can be added by
;; most of the operators in this domain.  These rules tell Prodigy which
;; operators to try first.
(setq *SCR-OP-SELECT-RULES* '(
      (select-specific-swap-adder-for-circle-left-partner-swap
           (lhs (and (current-node <node>)
                     (current-goal <node> (swap no))
                     (candidate-op <node> circle-left-partner-swap)
                )
           )
           (rhs (select operator circle-left-partner-swap)
           )
      )

      (select-specific-swap-adder-for-circle-right-partner-swap
           (lhs (and (current-node <node>)
                     (current-goal <node> (swap no))
                     (candidate-op <node> circle-right-partner-swap)
                )
           )
           (rhs (select operator circle-right-partner-swap)
           )
      )

      (select-specific-swap-adder-for-slide-through-partner-swap
           (lhs (and (current-node <node>)
                     (current-goal <node> (swap no))
                     (candidate-op <node> slide-through-partner-swap)
                )
           )
           (rhs (select operator slide-through-partner-swap)
           )
      )

      (select-specific-swap-adder-for-cross-through-partner-swap
           (lhs (and (current-node <node>)
                     (current-goal <node> (swap no))
                     (candidate-op <node> cross-through-partner-swap)
                )
           )
           (rhs (select operator cross-through-partner-swap)
           )
      )

      (select-specific-swap-adder-for-square-up-start
           (lhs (and (current-node <node>)
                     (current-goal <node> (swap no))
                     (candidate-op <node> square-up-start)
                )
           )
           (rhs (select operator square-up-start)
           )
      )

                             )
)
(setq *SCR-BINDINGS-SELECT-RULES* nil)
(setq *SCR-NODE-REJECT-RULES* nil)

;; This goal rejection rule is designed to prevent cycles in the dance, e.g.
;;           allemande-left --> do-si-do
;;           do-si-do       --> allemande-left
;; or equivalently in predicates:
;;           (follows allemande-left do-si-do)
;;           (follows do-si-do allemande-left).
(setq *SCR-GOAL-REJECT-RULES* '(
      (avoid-cycle-in-dance
           (lhs (and (current-node <node>)
                     (current-goal <node> (follows <m1> <m2>))
                     (known <node> (follows <m2> <m1>))
                )
           )
           (rhs (reject goal (follows <m1> <m2>))
           )
      )
                               )
)
(setq *SCR-OP-REJECT-RULES* nil)
(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES*  nil)
(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)
