
(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 
      '((SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
		    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))
       ))

(setq *SCR-BINDINGS-REJECT-RULES*

'(

;; The time slot generator without these search control rules will at
;; first randomly pick whether it will try to add the next time slot
;; for a specialist as a break, reserved event, or as a slot for
;; teachers.  These first 2 rules make sure that we add the breaks and
;; events as we go along so we can eliminate a lot of backtracking.


;;----------------------------------------------------------------------------
;; In adding a time slot if there is a break to be scheduled and the
;; bindings that were chosen for the next time slot will not allow
;; enough time to fit the break in then reject those bindings.  If
;; this is the case, then we probably want to add the break at this
;; time, and not the rejected bindinds.


  (DONT-ADD-TIME-SLOT-THAT-DOESNT-LEAVE-ROOM-FOR-A-BREAK
   (lhs (and (current-node <node>)
			 (current-op <node> ADD-TIME-SLOT)
			 (candidate-bindings <node> (<specialist> <start> <end>))
			 (known <node> (exists (<break-start> <break-end> <length>)
								   (Allowed-Break <specialist>
												  <break-name> <break-start>
												  <break-end> <length>)
								   (and (add-time <end> <length> <temp-end>)
										(less-than <break-end> <temp-end>))))))


   (rhs (reject bindings (<specialist> <start> <end>))))





;;----------------------------------------------------------------------------
;; In adding a time slot if there is an event to be scheduled and the
;; bindings that were chosen for the next time slot will not allow
;; enough time to fit the break in then reject those bindings.  If
;; this is the case, then we probably want to add the event at this
;; time, and not the rejected bindings.


(DONT-ADD-TIME-SLOT-THAT-DOESNT-LEAVE-ROOM-FOR-AN-EVENT
 (lhs (and (current-node <node>)
		   (current-op <node> ADD-TIME-SLOT)
		   (candidate-bindings <node> (<specialist> <start> <end>))
		   (known <node> (exists (<event-start> <event-end> <length>)
								 (Wanted-Event <specialist> <event-name>
											   <event-start> <event-end> <length> <grades>)
								 (and (add-time <end> <length> <temp-end>)
									  (less-than <event-end> <temp-end>))))))

 (rhs (reject bindings (<specialist> <start> <end>))))





;;--------------------------------------------------------------------------------
;; In adding recesses and lunches in a recess or lunch event, we can
;; get rid of the choosing starting times that will not leave enough
;; room for the other recesses and lunches.  Because, if a time like
;; that was chosen we would get failure and have to backtrack.


   (DONT-ADD-RECESS-LUNCH-TIME-IF-IT-DOESNT-LEAVE-SPACE-FOR-OTHERS
      (lhs (and (current-node <node>)
                (current-op <node> ADD-RECESS-LUNCH)
                (candidate-bindings <node> (<name> <num> <start> <end>))
                (known <node> (exists (<other-num>)
       			              (Recess-Lunch-Grades <name> <other-num> <grades>)
        			 (and (not-equal <num> <other-num>)
	       	  		      (~(Recess-Lunch-Time <name> <other-num> <other-start> <other-end>))
				      (Recess-Lunch <name> <earliest> <latest> <length>)
				      (~(time-will-fit <earliest> <length> <start>))
				      (~(time-will-fit <end> <length> <latest>)))))))

      (rhs (reject bindings (<name> <num> <start> <end>))))




;;------------------------------------------------------------------------------------
;; For any time slot that is suppose to be used by teachers, it (the
;; time slot) needs to be able to have some grade that can possibly be
;; scheduled during the slots start and end time.  In a recess or
;; lunch event, there are usually a couple of recesses or lunches.
;; For example, the morning recess event might contain 2 recesses, in
;; the first recess grades (1 2 3) might participate, and in the 2nd
;; recess grades (4 5 6) might participate.  The point is that it is a
;; rule for grade schools that all grades participate in a recess or
;; lunch event.  So, after the time-outline has been created we can go
;; through and check to see if all of the recesses in a recess event
;; or all the lunches in a lunch event overlap any time-slot that
;; could hold teachers.  This is considered an invalid solution, even
;; though there might be enough free time slots to schedule all the
;; teachers.

   (R-L-EVENT-CANNOT-COMPLETELY-OVERLAP-A-TIME-SLOT-MADE-FOR-TEACHERS
      (lhs (and (current-node <node>)
           (current-op <node> ADD-RECESS-LUNCH)
           (candidate-bindings <node> (<name> <num> <start> <end>))
           (known <node> (and (forall (<other-num>)
 			                (Recess-Lunch-Grades <name> <other-num> <grades>)
			            (or (is-equal <num> <other-num>)
				        (Recess-Lunch-Time <name> <other-num> <any-start> <any-end>)))

                              (exists (<sp-name> <ts-start> <ts-end>)
                                      (Time-Slot <sp-name> <ts-start> <ts-end>)
                                 (and
                                      (~(SP-Break <sp-name> <any-name> <ts-start> <ts-end>))
                                      (~(Reserved-Event <sp-name> <a-name> <ts-start> <ts-end> <grades>))

                                      (forall (<temp-num> <rl-start> <rl-end>)
                                              (Recess-Lunch-Time <name> <temp-num> <rl-start> <rl-end>)
                                          (overlap <ts-start> <ts-end> <rl-start> <rl-end>))
                                      (overlap <ts-start> <ts-end> <start> <end>)))))))

	 (rhs (reject bindings (<name> <num> <start> <end>))))

))




(setq *SCR-BINDINGS-PREFERENCE-RULES* 

'(

;;--------------------------------------------------------------------------------
;; When scheduling teachers with specialists it is VERY preferable
;; (almost mandatory) that when a teacher is scheduled multiple times
;; with a specialist, the teacher should not be scheduled two days in
;; a row for that specialist.  So, when we are scheduling a teacher
;; with a specialist, and we have already scheduled the teacher one or
;; more times with this specialist, we want to schedule the teacher on
;; a day that is NOT next to those day(s) already scheduled.
;; Therefore, this rule does not apply to scheduling a teacher for the
;; first time with a specialist.

(DAY-CHOSEN-SHOULD-BE-2-OR-MORE-DAYS-AWAY-FROM-AN-ALREADY-SCHEDULED-DAY-FOR-THAT-SPECIALIST-AND-TEACHER
 (priority 0)
 (lhs (and (current-node <node>)
		   (current-op <node> ASSIGN)
		   (candidate-bindings <node> (<teach-name> <sp-name> <start-time1> <end-time1> <day1>))
		   (candidate-bindings <node> (<teach-name> <sp-name> <start-time2> <end-time2> <day2>))
		   (not-equal <day1> <day2>)

		   (known <node> (exists (<any-start> <any-end> <day>)
								 (Scheduled <teach-name> <sp-name> <any-start> <any-end> <day>)
								 (day1-is-2-or-more-away-from-day-and-better-than-day2 <day> <day1> <day2>)))))

 (rhs (prefer bindings (<teach-name> <sp-name> <start-time1> <end-time1> <day1>)
			  (<teach-name> <sp-name> <start-time2> <end-time2> <day2>))))





;;--------------------------------------------------------------------------------------
;; In choosing the day to schedule a teacher with a specialist, we
;; give highest priority picking a day so that a teacher is NOT
;; scheduled 2 days in a row for the same specialist.  Next, we give
;; priority to the day that has the most empty time slots (meaning:
;; choose the day that has the least number of people scheduled on
;; it).  This is important because if the days that are more
;; restricted (has less empty slots, more teachers scheduled on that
;; day) are chosen as our days to schedule a teacher over less
;; restricted days we could come up with failures that would have to
;; be solved by backtracking.  These failures can almost be completely
;; avoided by choosing the day with the most empty slots over days
;; that have less empty slots.  ;; An example: if we had 2 teachers
;; left to schedule with specialist Music, the only days left are
;; Monday and Wednesday, Monday has 3 free slots and Wednesday only 1,
;; teach1 has not been scheduled at all yet (so it can be scheduled on
;; any day), and teach2 can only be scheduled on Wednesday.  If, you
;; have followed me this far, I am lucky.  If we schedule teach1 on
;; Wednesday, then Wednesday will have NO empty slots left.  This
;; would lead to a failure since teach2 can only be scheduled on
;; Wednesday.  So, it would be better to have chosen Monday (THE DAY
;; WITH THE MORE EMPTY SLOTS) to schedule teach1, THIS LEAVES THE
;; OVERALL SCHEDULE MORE FLEXABLE.  ;; This is a FANCY rule (it took a
;; long time to figure this out).  In order to compare days, I count
;; the number of teachers that have been scheduled with that
;; specialist on that day.  NOTE: I have learned how to COUNT THE
;; NUMBER OF PREDICATES (non-static) OF A CERTAIN TYPE in the current
;; state.  This is all handled in the Meta-Fn
;; day1-has-more-empty-slots.


(CHOOSE-THE-DAY-THAT-HAS-THE-LEAST-NUMBER-OF-PEOPLE-SCHEDULED-ON-IT
   (priority 1)
   (lhs (and (current-node <node>)
             (current-op <node> ASSIGN)
             (candidate-bindings <node> (<teach-name> <sp-name> <start-time1> <end-time1> <day1>))
             (candidate-bindings <node> (<teach-name> <sp-name> <start-time2> <end-time2> <day2>))
             (not-equal <day1> <day2>)

             (day1-has-more-empty-slots  (Scheduled <any-name1> <sp-name> <any-start1> <any-end1> <day1>)
                                         (Scheduled <any-name2> <sp-name> <any-start2> <any-end2> <day2>)
                                          <node>)))


  (rhs (prefer bindings (<teach-name> <sp-name> <start-time1> <end-time1> <day1>)
                        (<teach-name> <sp-name> <start-time2> <end-time2> <day2>))))





;;;
;;; ----------------------------------------------------------------------------------
;;; PREFER-MOST-RESTRICTED-TIME-SLOTS ;;; This rule was created to
;;; direct the assignment of teachers to specialists.  The motivation
;;; behind this rule was the fact that when assembling the schedule,
;;; it is wisest to first schedule those time slots with the least
;;; amount of leeway.  In this case the leeway is measured by the
;;; number of grades that a specialist can teach in a given time slot.
;;; A specialist cannot teach a grade at an event or at recess, and
;;; this is represented in the expressions below.  Note that there are
;;; two identical (except for variable names) expressions for the two
;;; time slots being compared.  These expressions are only partially
;;; bound (time slot start and end).  They will be fully bound inside
;;; the function fewer-grades-can-be-taught where these bindings will
;;; be analyzed to see how many grades can be taught during a time
;;; slot.  The time slot in which the fewest grades can be taught is
;;; preferred.

(PREFER-MOST-RESTRICTED-TIME-SLOTS
   (priority 2)
   (lhs (and (current-node <node>)
             (current-op <node> ASSIGN)
             (candidate-bindings <node> (<teach-name> <sp-name> <start1> <end1> <day>))
             (candidate-bindings <node> (<teach-name> <sp-name> <start2> <end2> <day>))
	     (known <node> (Specialist <sp-name> <length> <num-times> <gradelist> <day-list>))
	     (fewer-grades-can-be-taught 
                             (or (and (Reserved-Event <any-sp1> <e-name1> <e-start1> <e-end1> <e-gradelist1>)
	 		              (overlap <start1> <end1> <e-start1> <e-end1>))
  	 		         (and (Recess-Lunch-Time <r-l-name1> <r-l-num1> <r-l-start1> <r-l-end1>)
				      (overlap <start1> <end1> <r-l-start1> <r-l-end1>)
				      (Recess-Lunch-Grades <r-l-name1> <r-l-num1> <r-l-gradelist1>)))

	                     (or (and (Reserved-Event <any-sp2> <e-name2> <e-start2> <e-end2> <e-gradelist2>)
			              (overlap <start2> <end2> <e-start2> <e-end2>))
			         (and (Recess-Lunch-Time <r-l-name2> <r-l-num2> <r-l-start2> <r-l-end2>)
				      (overlap <start2> <end2> <r-l-start2> <r-l-end2>)
				      (Recess-Lunch-Grades <r-l-name2> <r-l-num2> <r-l-gradelist2>)))

                             <gradelist> <node>)))
 
  (rhs (prefer bindings (<teach-name> <sp-name> <start1> <end1> <day>)
                        (<teach-name> <sp-name> <start2> <end2> <day>))))      





;;;
;;; ---------------------------------------------------------------------------
;;; PREFER-RECESSES-TO-BE-SEPARATED-BY-5-MINUTES ;;; This control rule
;;; helps to find a more desired solution.  If possible, we want a
;;; short time period (5 minutes) between recesses.  In the real
;;; world, this decreases the confusion that occurs at recess.  It
;;; works by preferring a recess period that starts or ends 5 minutes
;;; from another already existing recess period.  ;;;

  (PREFER-RECESSES-TO-BE-SEPARATED-BY-5-MINUTES
   (priority 3)
   (lhs (and (current-node <node>)
	     (current-op <node> ADD-RECESS-LUNCH)
	     (candidate-bindings <node> (<name> <num> <start1> <end1>))
	     (candidate-bindings <node> (<name> <num> <start2> <end2>))
	     (known <node> (and (Recess-Lunch-Time <name> <other-num> <other-start> <other-end>)
		                (or (five-more <start1> <other-end>)
			            (five-more <other-start> <end1>))))))
   (rhs (prefer bindings (<name> <num> <start1> <end1>)
                         (<name> <num> <start2> <end2>))))





;;;
;;; --------------------------------------------------------------------------
;;; PREFER-TO-ASSIGN-SPECIALIST-AND-TEACHER-AT-A-REGULAR-TIME ;;; This
;;; control rule is used to achieve "better" solutions.  In general,
;;; if a specialist is assigned to a teacher say Monday, Wednesday,
;;; and Friday it would be nice if the specialist was assigned at the
;;; same time each day (10:00 for example) The rule achieves this by
;;; (of course) preferring a time that was already scheduled on
;;; another day.  ;;;

(PREFER-TO-ASSIGN-SPECIALIST-AND-TEACHER-AT-A-REGULAR-TIME
   (priority 4)
   (lhs (and (current-node <node>)
             (current-op <node> ASSIGN)
             (candidate-bindings <node> (<teach-name> <sp-name> <start1> <end1> <day>))
             (candidate-bindings <node> (<teach-name> <sp-name> <start2> <end2> <day>))
	     (known <node> (and (Scheduled <teach-name> <sp-name> <other-start> <other-end> <other-day>)
			        (is-equal <start1> <other-start>)))))

  (rhs (prefer bindings (<teach-name> <sp-name> <start1> <end1> <day>)
                        (<teach-name> <sp-name> <start2> <end2> <day>))))

))

(setq *SCR-NODE-REJECT-RULES* 

'(

;;--------------------------------------------------------------------
;; After the time-outline has been made for each specialist (all the
;; time slots have been created), in order to create a schedule there
;; has to be more or the same number of available time slots as the
;; number of time slots needed by the teachers.  If this is not true
;; the solver will eventually come up with failure, but we can check
;; this and save a lot of time (in the case of failure) once the
;; time-outline has been created.
     
(THERE-HAS-TO-BE-AS-MANY-TIME-SLOTS-AS-THERE-ARE-TEACHERS-TO-BE-SCHEDULED

 (lhs
  (and
   (primary-candidate-node <node>)
   (candidate-goal <node> (SCHEDULED-ALL-TEACHERS))
   (known <node> (Time-Outline-Done))
   (known <node>
		  (exists (<specialist>)
				  (Specialist <specialist> <length> <num-times>
							  <grade-list> <day-list>) 
				  (not-enough-free-slots (Time-Slot <specialist>
													<any-start1> <any-end1>)
										 (SP-Break <specialist> <any-name>
												   <any-start2> <any-end2>)
										 (Reserved-Event <specialist> <n> <s>
														 <e> <g-l>)
										 (Num-Meetings <any-teach> <specialist>
													   <any-num>)
										 <day-list> <num-times> <node>)))))
 (rhs (reject node <node>)))




;;------------------------------------------------------------------
;; This is sort of a precondition, but it can also be thought of as a
;; control rule.  This causes failure if a teacher expects to be
;; scheduled with a specialist, but for some reason the grade that the
;; teacher teaches is not in the list of grades that the specialist
;; teaches.  Without this rule a case like this will eventually come
;; to failure (could take a long long time), but this can be checked
;; right away

(SPECIALIST-NEEDS-TO-TEACH-THE-GRADES-OF-TEACHERS-THAT-EXPECT-TO-BE-SCHEDULED-WITH-THE-SPECIALIST

   (lhs (and (primary-candidate-node <node>)
             (candidate-goal <node> (ALL-DONE))
             (known <node> (exists (<teach> <teach-grade>)
                                     (Teacher <teach> <teach-grade>)
                                (exists (<specialist> <num>)
                                        (Num-Meetings <teach> <specialist> <num>)
                                    (~(exists (<length> <num-times> <grade-list> <day-list>)
                                            (Specialist <specialist> <length> <num-times> <grade-list> <day-list>)
                                       (my-member <teach-grade> <grade-list>))))))))

  (rhs (reject node <node>)))

))


(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-OP-REJECT-RULES* nil)
(setq *SCR-OP-SELECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES*  nil)
(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-SELECT-RULES* nil
)
