;; This example just shows some of the features it allows.  It allows specialist to teach on
;; specified days, like early music which is only scheduled to teach at this school on Tuesday
;; and Thursday.  

;; Also, it shows that we can specify what grades a specialist is allowed to teach.  The 
;; early-music specialist teaches K and 1st grades, while the main music teacher teaches
;; 2,3,4,5, and 6.

;; This shows the realistic aspect of your domain.  A lot of schools are getting so big that they
;; have more than one specialist for the same activity like Music shown here.  Then the speicialists
;; split the grades to be tought between them.  Usually one specialist travels from school to school 
;; like our early-music teaching only certain days at each school, while the other specialist like
;; our main-music only teaches at one grade school.



(load-goal '(all-done))

(load-start-state
                  '((start-of-school 900)
                    (end-of-school 1530)

                    (allowed-break PE Lunch 1100 1230 30)
                    (allowed-break Early-Music Lunch 1100 1230 30)
                    (allowed-break Main-Music Lunch 1100 1230 30)
                    (allowed-break Library Lunch 1100 1230 30)

                    (Recess-Lunch-Grades Lunch 1 (K 1 2 3))
		    (Recess-Lunch-Grades Lunch 2 (4 5 6))
                    (Recess-Lunch Lunch 1100 1230 30)

		    
                    (teacher Oren  3)
                    (teacher Vaghn 4)
		    (teacher Sonny 2)
                    (teacher Larry 3)
                    (teacher Moe   2)
		    (teacher Bjorn 1)
		    (teacher Bozo  1)
		    (teacher Cher  K)
		    (teacher Marie 4)
                    (teacher Curly K)
                    (teacher John  5)
                    (teacher Paul  5)
                    (teacher George 6)
                    (teacher Ringo  6)

                    (specialist early-music 40 2 (K 1) (Tuesday Thursday))

                    (specialist main-music 40 2 (2 3 4 5 6) (Monday Tuesday Wednesday Thursday Friday))
		    (specialist pe 40 1 (K 1 2 3 4 5 6) (Monday Tuesday Wednesday Thursday Friday))
                    (specialist library 35 2 (K 1 2 3 4 5 6) (Monday Tuesday Wednesday Thursday Friday))
		    
		    (num-meetings Bjorn pe 0)
		    (num-meetings Bjorn early-music 0)
		    (num-meetings Bjorn library 0)
		    (num-meetings Marie pe 0)
		    (num-meetings Marie main-music 0)
		    (num-meetings Marie library 0)
		    (num-meetings Bozo pe 0)
		    (num-meetings Bozo early-music 0)
		    (num-meetings Bozo library 0)
		    (num-meetings Sonny pe 0)
		    (num-meetings Sonny main-music 0)
		    (num-meetings Sonny library 0)
		    (num-meetings Oren pe 0)
		    (num-meetings Oren main-music 0)
		    (num-meetings Oren library 0)
		    (num-meetings Vaghn pe 0)
		    (num-meetings Vaghn main-music 0)
		    (num-meetings Vaghn library 0)

		    (num-meetings John pe 0)
		    (num-meetings John main-music 0)
		    (num-meetings John library 0)
		    (num-meetings Paul pe 0)
		    (num-meetings Paul main-music 0)
		    (num-meetings Paul library 0)
		    (num-meetings George pe 0)
		    (num-meetings George main-music 0)
		    (num-meetings George library 0)
		    (num-meetings Ringo pe 0)
		    (num-meetings Ringo main-music 0)
		    (num-meetings Ringo library 0)

		    (num-meetings Cher pe 0)
		    (num-meetings Cher early-music 0)
		    (num-meetings Cher library 0)
		    (num-meetings Larry pe 0)
		    (num-meetings Larry main-music 0)
		    (num-meetings Larry library 0)
		    (num-meetings Moe pe 0)
		    (num-meetings Moe main-music 0)
		    (num-meetings Moe library 0)
		    (num-meetings Curly pe 0)
		    (num-meetings Curly early-music 0)
		    (num-meetings Curly library 0)


))

