;; This is just one of your initial 5 test cases.   This demonstrates that our domain correctly handles when
;; a reserved events time range can overlap
;; a recess or lunch time range, and the reserved events time range 
;; overlaps a break time range for the specialist that is going to be teaching
;; the reserved event.  In this example the reserved event is Band for the music teacher.

;; In correctly handling this we need to make sure that the break time does not overlap the reserved events time, and
;; that the recess time, that has the same grades in its grade list as the reserved events grade list, does
;; not overlap the reserved events time.  Because those grades can only be at one place at a time.

(load-goal '(all-done))

(load-start-state
                  '((start-of-school 900)
                    (end-of-school 1530)


                    (Wanted-Event Music Band 1400 1530 30 (5 6))

		    (allowed-break pe Afternoon-Recess 1400 1430 10)
		    (allowed-break Music Afternoon-Recess 1400 1430 10)
		    (allowed-break Library Afternoon-Recess 1400 1430 10)

                    (Recess-Lunch Afternoon-Recess 1400 1430 10)
                    (Recess-Lunch-Grades Afternoon-Recess 1 (1 2 3))
                    (Recess-Lunch-Grades Afternoon-Recess 2 (4 5 6))

                    (teacher John  5)
                    (teacher Paul  5)
                    (teacher George 6)
                    (teacher Ringo  6)

                    (specialist music 40 2 (1 2 3 4 5 6) (Monday Tuesday Wednesday Thursday Friday))
		    (specialist pe 40 3 (1 2 3 4 5 6) (Monday Tuesday Wednesday Thursday Friday))
		    
		    (num-meetings John pe 0)
		    (num-meetings John music 0)
		    (num-meetings Paul pe 0)
		    (num-meetings Paul music 0)
		    (num-meetings George pe 0)
		    (num-meetings George music 0)
		    (num-meetings Ringo pe 0)
		    (num-meetings Ringo music 0)

))

