;; This problem will fail because there is not enough time slots to schedule all of the teachers 
;; the number of times they need to be.  The Music teacher has 3 time slots
;;
;; 1) 900 to 940
;; 2) 940 to 1020
;; 3) 1020 to 1100
;;
;; There are 5 days in a week so there are 3 * 5 = 15 time slots available for teachers.

;; Well there are 12 teachers that want to be scheduled 2 times a week with the music specialist.
;; So, this is illegal since we need 12 * 2 = 24 time slots and we only have 15.

;; This is handled by the search control rule:

;; THERE-HAS-TO-BE-AS-MANY-TIME-SLOTS-AS-THERE-ARE-TEACHERS-TO-BE-SCHEDULED


(load-goal '(all-done))

(load-start-state
                  '((start-of-school 900)
                    (end-of-school 1100)

		    (teacher Sonny 1)
                    (teacher Larry 1)
                    (teacher Moe   2)
		    (teacher Bjorn 2)
		    (teacher Bozo  3)
		    (teacher Cher  3)
		    (teacher Marie 4)
                    (teacher Curly 4)
                    (teacher John  5)
                    (teacher Paul  5)
                    (teacher George 6)
                    (teacher Ringo  6)

                    (specialist music 40 2 (1 2 3 4 5 6) (Monday Tuesday Wednesday Thursday Friday))


		    (num-meetings Bjorn music 0)
		    (num-meetings Marie music 0)
		    (num-meetings Bozo music 0)
		    (num-meetings Sonny music 0)
		    (num-meetings John music 0)
		    (num-meetings Paul music 0)
		    (num-meetings George music 0)
		    (num-meetings Ringo music 0)
		    (num-meetings Cher music 0)
		    (num-meetings Larry music 0)
		    (num-meetings Moe music 0)
		    (num-meetings Curly music 0)



))

