;; We make a schedule fail if a time-slot for a specialist (like time 900 to 940 for the Music) 
;; that is suppose to be used by teachers, has all recesses or lunches in a recess or lunch event
;; overlap that time slot.  This is because all of the grades in school get a break during each
;; recess or lunch event.  So, if all the recesses in a recess event overlap a specialist time slot
;; (that the specialist is suppose to teach teachers classes in) then no teachers can be scheduled
;; at during those time slots.  We call this a fail situation because, valid schedule should have
;; this property.  This fail situation is caught by the search control rule:

;; R-L-EVENT-CANNOT-COMPLETELY-OVERLAP-A-TIME-SLOT-MADE-FOR-TEACHERS

;; In this example the Musics (and PEs) 2nd time slot 940 to 1020 will have both receses in the
;; Morning-Recess event overlap it, since this is the only time the Morning-Recess event can be
;; scheduled.  If the Morning-Recesses range went from 930 to 1035 it would work.  The above
;; search control is a reject bindings, so if legal time bindings exist it will find them.

(load-goal '(all-done))

(load-start-state
                  '((start-of-school 900)
                    (end-of-school 1200)


                    (Recess-Lunch Morning-Recess 930 1015 15)
                    (Recess-Lunch-Grades Morning-Recess 1 (1 2 3))
                    (Recess-Lunch-Grades Morning-Recess 2 (4 5 6))


                    (teacher John  5)
                    (teacher Paul  5)
                    (teacher George 6)
                    (teacher Ringo  6)

                    (specialist music 40 2 (1 2 3 4 5 6) (Monday Tuesday Wednesday Thursday Friday))
		    (specialist pe 40 1 (1 2 3 4 5 6) (Monday Tuesday Wednesday Thursday Friday))
                    (specialist library 35 2 (1 2 3 4 5 6) (Monday Tuesday Wednesday Thursday Friday))
		    

		    (num-meetings John pe 0)
		    (num-meetings John music 0)
		    (num-meetings John library 0)
		    (num-meetings Paul pe 0)
		    (num-meetings Paul music 0)
		    (num-meetings Paul library 0)
		    (num-meetings George pe 0)
		    (num-meetings George music 0)
		    (num-meetings George library 0)
		    (num-meetings Ringo pe 0)
		    (num-meetings Ringo music 0)
		    (num-meetings Ringo library 0)




))

