
(setq *OPERATORS* '( 


;;; Make-Time-Outline commences time-slot creation for a specialist.  Note that the only precondition dealing
;;;                   with time slots says that the specialist must have a time slot which starts at the
;;;                   beginning of the day.  All other slots are created recursively in Add-Time-Slot.
;;;                   After creating time slots, it tries to add all breaks and events desired.
;;;

(Make-Time-Outline
    (params (<specialist>))
    (preconds
        (and
             (Start-of-School <school-start>)
             (Time-Slot <specialist> <school-start> <any-end-time>)
             (~(Allowed-Break <specialist> <break-name> <break-start> <break-end> <break-length>))
             (~(Wanted-Event <specialist> <event-name> <event-start> <event-end> <length> <grade-list>))))

    (effects ((add (Finished-Time-Outline <specialist>)))))




;;; Add-Time-Slot adds a slot by adding a slot the length of a class, a break, or an event.
;;; This is a recursive procedure that builds a time outline for each specialist.  I time outline
;;; looks like:
;;
;;                        (TIME-SLOT PE 1300 1340)
;;                        (TIME-SLOT PE 1340 1420)   ;; note: military time is used
;;                        (TIME-SLOT PE 1420 1430)
;;                        (TIME-SLOT PE 1430 1510)
;;                        (TIME-SLOT PE 1510 1550)
;;
;; Where each time slot can be a reserved-event, a break time for the specialist, or a slot 
;; to be used to teach a teachers class so the teacher can get their prep-time (break).
;; There are 5 days in schools per week.  The time-outline holds for every day, and a schedule
;; that this domain makes is a week long.


(Add-Time-Slot
    (params (<specialist> <start> <end>))
    (preconds
        (and (End-Of-School <school-end>)
             (less-than <start> <school-end>)
             (Specialist <specialist> <length> <num-of-days> <grade-list> <day-list>)
             (or
                           ;; The slot can either be a break, reserved event, or a slot for teachers

                 (SP-Break <specialist> <break-name> <start> <end>)                           ; break
                 (Reserved-Event <specialist> <event-name> <start> <end> <event-grade-list>)  ; event
                 (add-time <start> <length> <end>))                                           ; normal slot

             (or (~(time-will-fit <end> <length> <school-end>))  ; If we cannot fit another time slot in
                                                                 ;   before the end of school, then we are done.

                 (Time-Slot <specialist> <end> <any-end>))))     ; else follow this slot by another slot (recurse).

    (effects ((add (Time-Slot <specialist> <start> <end>)))))




;;;-------------------------------------------------------------------------------------------
;;; Specialists can have breaks if they have allowed-break predicates.  The start and end time 
;;; in the allowed-break predicate refers to the allowed time range that the break can be scheduled
;;; at with the specialist.  So, the break needs to start and end at sometime within this range.

(Add-Break
    (params (<specialist> <break-name> <start> <end>))
    (preconds
           (and 
	        (Allowed-Break <specialist> <break-name> <earliest-start> <latest-end> <length>)
	        (add-time <start> <length> <end>)
	        (within <start> <end> <earliest-start> <latest-end>)
	        (~(exists (<event-start> <event-end>)
		          (Reserved-Event <specialist> <event-name> <event-start> <event-end> <gradelist>)
		   (overlap <start> <end> <event-start> <event-end>)))))
 
    (effects ((del (Allowed-Break <specialist> <break-name> <earliest-start> <latest-end> <length>))
              (add (SP-Break <specialist> <break-name> <start> <end>)))))




;;;-------------------------------------------------------------------------------------------
;;; Reserved Events that effect Specialists need to be scheduled within their start and end 
;;; range as with the specialists.

(Add-Reserved-Event
    (params (<specialist> <event-name> <start> <end> <grade-list>))
    (preconds
           (and (Wanted-Event <specialist> <event-name> <earliest-start> <latest-end> <length> <grade-list>)
                (add-time <start> <length> <end>)
	        (within <start> <end> <earliest-start> <latest-end>)
	        (~(exists (<break-start> <break-end>)
		          (SP-Break <specialist> <break-name> <break-start> <break-end>)
		   (overlap <start> <end> <break-start> <break-end>)))))

    (effects ((del (Wanted-Event <specialist> <event-name> <earliest-start> <latest-end> <length> <grade-list>))
              (add (Reserved-Event <specialist> <event-name> <start> <end> <grade-list>)))))




;;; Add-Recess-Lunch puts recesses (e.g. morning, lunch, afternoon) into the schedule.  It does not allow
;;;            recesses to overlap each other, or events which have the same grades attending.
;;;            Given a time window into which the recess must fit, alternate start times are generated
;;;            at 5 minute intervals
;;;

(Add-Recess-Lunch
    (params (<r-l-name> <r-l-num> <start> <end>))

    (preconds
              (and (Recess-Lunch <r-l-name> <earliest-start> <latest-end> <length>)
                   (time-bind <start> <earliest-start> <latest-end> <length>)
                   (add-time <start> <length> <end>)
		   (~(exists (<other-start> <other-end>)                                 
			     (Recess-Lunch-Time <r-l-name> <num> <other-start> <other-end>) ; non-static
		        (overlap <start> <end> <other-start> <other-end>)))
		   (~(exists (<event-start> <event-end> <event-gradelist>)               ; non-static
			     (Reserved-Event <specialist> <event-name> <event-start> <event-end> <event-gradelist>)
		        (and (overlap <event-start> <event-end> <start> <end>)
			     (Recess-Lunch-Grades <r-l-name> <r-l-num> <r-l-gradelist>)
			     (~(disjoint <r-l-gradelist> <event-gradelist>)))))))

    (effects ((add (Recess-Lunch-Time <r-l-name> <r-l-num> <start> <end>)))))




;;; Assign fills a specialists schedule, i.e. associates a teacher with a time slot.  
;;; There are five days in a week.  A specialist's time slot (like PE 1000 to 1040) is valid
;;; all of these 5 days.  So, a teacher can be scheduled with a specialist during a time slot
;;; on one of the days during the week, if that time slot is a valid one for the grade the teacher
;;; teaches and the teacher is not already scheduled on the chosen day.  So, teachers can only
;;; be scheduled once a day for each day of the week.   The constaints for a legal, time slot and
;;; day for scheduling a teacher with a specialist are the notted (~) preconds.

(Assign 
 (params (<teacher> <specialist> <start> <end> <day>))
 (preconds
  (and (Teacher <teacher> <grade>)
       (Specialist <specialist> <length> <num-times> <grade-list> <day-list>)
       (one-more <new-num-of-times> <num>)                                    ; recurse to achieve number
       (Num-Meetings <teacher> <specialist> <num>)                            ;  of weekly meetings
       (my-member <grade> <grade-list>)                                       ; can teach this grade
       (day-bind <day> <day-list>)                                            ; can teach on this day
       (Time-Slot <specialist> <start> <end>)                                 

       (~(Scheduled <any-teacher> <specialist> <start> <end> <day>))          ; not currently scheduled
       (~(Scheduled <teacher> <any-specialist> <any-start> <any-end> <day>))  ; one spec. per teacher per day
       (~(SP-Break <specialist> <any-break> <start> <end>))                   ; not on break

                 ; An event that has the same grade particpating in it as the grade that the teacher teaches
                 ; cannot have its start and end time overlap the time slot we are trying to put the
                 ; teacher in.

       (~(exists (<event-gradelist> <event-start> <event-end>)              
                 (Reserved-Event <other-specialist> <event> <event-start> <event-end> <event-gradelist>) ; non-static
            (and (my-member <grade> <event-gradelist>)
                 (overlap <start> <end> <event-start> <event-end>))))


                 ; Just like a reserved event.  We cannot allow a time-slot that is overlapped by a 
                 ; recess or lunch with the grade that teacher teaches participating in that recess or lunch.

       (~(exists (<gradelist> <r-l-name> <r-l-num>)                     ; can't teach grade at recess
                 (Recess-Lunch-Grades <r-l-name> <r-l-num> <gradelist>)
            (exists (<r-l-start> <r-l-end>)
                    (Recess-Lunch-Time <r-l-name> <r-l-num> <r-l-start> <r-l-end>)     ; non-static
               (and (my-member <grade> <gradelist>)
                    (overlap <start> <end> <r-l-start> <r-l-end>)))))))

 (effects ((del (Num-Meetings <teacher> <specialist> <num>))
	   (add (Num-Meetings <teacher> <specialist> <new-num-of-times>))
	   (add (Scheduled <teacher> <specialist> <start> <end> <day>)))))


))




(setq *INFERENCE-RULES* '(



(INFER-ADD-ALL-DONE                                   
     (preconds (and (Time-Outline-Done)
                    (Scheduled-All-Teachers)))
     (effects ((add (All-Done)))))




(INFER-TEACHER-DONE       ; teacher's class must be with each specialist the required number of times
     (params (<specialist>))
     (preconds
       (forall (<specialist>)
               (Specialist <specialist> <length> <num-times> <grade-list> <day-list>)
          (or  (and (Teacher <teacher> <grade>)
                    (~(my-member <grade> <grade-list>)))
               (Num-Meetings <teacher> <specialist> <num-times>))))
     (effects ((add (Teacher-Done <teacher>)))))




(INFER-TIME-OUTLINE-DONE
     (preconds (and 
                    (forall (<specialist>)
                            (Specialist <specialist> <any-length> <any-num> <grade-list> <day-list>)
                       (Finished-Time-Outline <specialist>))
                    (All-Recesses-and-Lunches-Created)))

     (effects ((add (Time-Outline-Done)))))




(SCHEDULED-ALL-TEACHERS
 (preconds (forall (<teacher>) (teacher <teacher> <grade>)
	           (teacher-done <teacher>)))
 (effects ((add (Scheduled-All-Teachers)))))




(INFER-ALL-RECESSES-AND-LUNCHES-CREATED
     (preconds (forall (<r-l-name>)
                       (Recess-Lunch <r-l-name> <any-start> <any-end> <any-length>)
                   (forall (<r-l-number>)
		           (Recess-Lunch-Grades <r-l-name> <r-l-number> <grades>)
		       (Recess-Lunch-Time <r-l-name> <r-l-number> <start> <end>))))


     (effects ((add (All-Recesses-and-Lunches-Created)))))



    ))


