;******************************************************************************
;******************************************************************************
;
;                 R O B O - W O R K E R
;
;           Eivind Sandstrand (c473bp@hilbert.ms.washington.edu)
;           Cse 473 
;           May 20, 1991
;




(setq  *OPERATORS* '(


;; First come the two mobility operators run-to and walk to.  They perform
;; similarly in that they simply just move robo to the given location.  
;; What distinguishes them is that robo can only run when he's carrying
;; some lightweight part and that he will walk when carrying something heavy.


  (WALK-TO
   (params (<to-loc>))
   (preconds (and 
	      (is-room <to-loc>)
	      (or (and (holding <part>)                ; if something is held
		   (is-heavy <part>))                  ; it must be heavy
	          (~ (holding <anything>)))))          ; same as above

   (effects ((del (is-in-room robo <from-loc>))
	     (add (is-in-room robo <to-loc>)))))



  (RUN-TO
   (params (<to-loc>))
   (preconds (and
	      (is-room <to-loc>)                       ; must be a room
	      (or (and (holding <part>)                ; if something is held
		   (is-light <part>))                  ; it must be light
		  (~ (holding <anything>)))))          ; otherwise, can't hold
                                                       ; anything
   (effects ((del (is-in-room robo <from-loc>))        ; robo has changed
	     (add (is-in-room robo <to-loc>)))))       ; location




; The pick-up and put-down (pu and pd) operators will lift from or place upon
; the floor.  We can't pu or pd from/to a shelf.


  (TAKE-FROM-SHELF
   (params (<part> <from-sh>))
   (preconds (and
	      (is-part <part>)                          ; generators
	      (is-shelf <from-sh>)
	      (~ (holding <anything>))                  ; drop other things
	      (is-in-room <from-sh> <sh-loc>)           ; generate location
	      (is-in-room robo <sh-loc>)                ; move robo
	      (is-in-room <part> <sh-loc>)              ; double check for part
	      (on-shelf <part> <from-sh>)))

   (effects ((del (on-shelf <part> <from-sh>))          ; taken off shelf
	     (add (holding <part>)))))                  ; now being held



  (PUT-ON-SHELF
   (params (<part> <to-sh>))
   (preconds (and
	      (is-part <part>)                          ; generators
	      (holding <part>)
	      (is-shelf <to-sh>)
	      (is-in-room <to-sh> <sh-loc>)             ; locate shelf
	      (is-in-room robo <sh-loc>)))              ; move robo

   (effects ((del (holding <part>))                     ; no longer held
	     (add (on-shelf <part> <to-sh>)))))         ; but on shelf



  (PICK-UP 
   (params (<part>))
   (preconds (and
	      (is-part <part>)
	      (~ (holding <anything>))
	      (~ (on-shelf <part> <some-shelf>))       ; no pick-up from shelf
	      (is-in-room <part> <at-loc>)             ; generate where part is
	      (is-in-room robo <at-loc>)))             ; robo must be by part

   (effects ((del (is-in-room  <part> <at-loc>))       ; part-location unknow
	     (add (holding <part>)))))                 ; but it's held



  (PUT-DOWN
   (params (<part> <down-loc>))
   (preconds (and
	      (is-part <part>)                         ; generator
	      (holding <part>)                         ;
              (is-room <down-loc>)                     ; generator
	      (is-in-room robo <down-loc>)))           ; robo must be in room

   (effects ((del (holding <part>))                    ; part no longer held
	     (add (is-in-room <part> <down-loc>)))))   ; it is moved



; The take-from-shelf and put-on-shelf makes sure we only  attempt these 
; operations from/to a shelf, since later expansions may require this 
; differentiation.


; The attach operator checks for part-compatability and makes sure the process
; (which is left unspecified for now) takes place in a qualified room

  (ATTACH
   (params (<p1> <p2>))
   (preconds (and
	      (is-part <p1>)                            ; generators
	      (is-part <p2>)
	      (is-assembly-room <a-loc>)                ; finds qualified room
	      (is-in-room <p1> <a-loc>)                 ; move parts to a-loc
	      (is-in-room <p2> <a-loc>)
	      (is-in-room  robo <a-loc>)                ; move robo to  a-loc
	      (or (fits <p1> <p2>) (fits <p2> <p1>))))  ; part must be comp'ble

   (effects ((add (is-attached <p1> <p2>)))))           ; process completed




   
)) 
