;;;
;;;    Rick Granberg    8632411    CSE 473 A    Spring 1991    Project 3
;;;    -------------    -------    ---------    -----------    ---------
;;;



(setq *SCR-NODE-SELECT-RULES* nil)

(setq *SCR-GOAL-SELECT-RULES* 
      '((SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
		    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))
       ))


(setq *SCR-OP-SELECT-RULES*  '(

;;;
;;; If the lengths of two opposite sides of a house are equal, try not to 
;;; upset this balance by adding rooms with outer walls on these sides.  
;;; Try instead to add rooms that have outer walls on either of the other 
;;; two sides.
;;;

(SELECT-ADDING-ROOMS-EAST-OR-WEST
  (LHS (AND (CURRENT-NODE <node>)
	    (CURRENT-GOAL <node> (HAS-ROOM <rambler>))
	    (KNOWN <node> (SIDE-LENGTH EAST <length>))
	    (KNOWN <node> (SIDE-LENGTH WEST <length>))))
  (RHS (SELECT OPERATOR ADD-ROOM-TO-EAST-OR-WEST-OR-WEST)))

))


(setq *SCR-BINDINGS-SELECT-RULES* nil)
(setq *SCR-NODE-REJECT-RULES* nil)

(setq *SCR-GOAL-REJECT-RULES* '(

;;;
;;; If a room needs to have an outer wall on a particular side, but has no
;;; free wall on this side to convert into an outer wall, do not subgoal to 
;;; try to acquire a free wall.
;;;

(DO-NOT-SUBGOAL-FOR-OUTER-WALLS
  (LHS (AND (CURRENT-NODE <node>)
            (PRIMARY-CANDIDATE-GOAL <node> (HAS-OUTER-WALL <room> <side>))
	    (KNOWN <node> (~(HAS-FREE-WALL <room> <side>)))))
  (RHS (REJECT GOAL (HAS-OUTER-WALL <room> <side>))))



;;;
;;; If two opposite sides of a house are not equal, then do not subgoal  
;;; to try to achieve this.  Testing whether two sides are equal is for 
;;; a completed house.  If this test fails, then the house must be 
;;; designed another way anyways.
;;;

(DO-NOT-SUBGOAL-FOR-EQUAL-SIDE-LENGTHS
  (LHS (AND (CURRENT-NODE <node>)
            (PRIMARY-CANDIDATE-GOAL <node> (SIDE-LENGTH <side> <length>))))
  (RHS (REJECT GOAL (SIDE-LENGTH <side> <length>))))



;;;
;;; If two rooms are not adjacent, do not subgoal to try to achieve this.
;;; Sharing corners is used as a precondition for operations, and should
;;; not be subgoaled on.
;;;

(DO-NOT-SUBGOAL-FOR-ADJACENT-ROOMS
  (LHS (AND (CURRENT-NODE <node>)
            (PRIMARY-CANDIDATE-GOAL <node> (SHARE-CORNER <room1> <room2> <side>))))
  (RHS (REJECT GOAL (SHARE-CORNER <room1> <room2> <side>))))



;;;
;;; If a room does not have a free wall to join a new room to, or to make
;;; an outer wall out of, do not subgoal to try to add a free wall to this
;;; room.
;;;

(DO-NOT-SUBGOAL-FOR-FREE-WALLS
  (LHS (AND (CURRENT-NODE <node>)
            (PRIMARY-CANDIDATE-GOAL <node> (HAS-FREE-WALL <room> <side>))))
  (RHS (REJECT GOAL (HAS-FREE-WALL <room> <side>))))



))
			       

(setq *SCR-OP-REJECT-RULES* '(


;;;
;;; If a room is required to have an outer wall on the North side, adding
;;; a room to its North or South will not achieve this.
;;;

(DO-NOT-REMOVE-OUTER-WALL-NORTH  
  (LHS (AND (CURRENT-NODE <node>)
	    (CURRENT-GOAL <node> (HAS-OUTER-WALL <room> NORTH))
            (CANDIDATE-OP <node> ADD-ROOM-TO-NORTH-OR-SOUTH)))
  (RHS (REJECT OPERATOR ADD-ROOM-TO-NORTH-OR-SOUTH)))


;;;
;;; If a room is required to have an outer wall on the South side, adding
;;; a room to its North or South will not achieve this.
;;;

(DO-NOT-REMOVE-OUTER-WALL-SOUTH  
  (LHS (AND (CURRENT-NODE <node>)
	    (CURRENT-GOAL <node> (HAS-OUTER-WALL <room> SOUTH))
            (CANDIDATE-OP <node> ADD-ROOM-TO-NORTH-OR-SOUTH)))
  (RHS (REJECT OPERATOR ADD-ROOM-TO-NORTH-OR-SOUTH)))


;;;
;;; If a room is required to have an outer wall on the East side, adding
;;; a room to its East or West will not achieve this.
;;;

(DO-NOT-REMOVE-OUTER-WALL-EAST  
  (LHS (AND (CURRENT-NODE <node>)
	    (CURRENT-GOAL <node> (HAS-OUTER-WALL <room> EAST))
            (CANDIDATE-OP <node> ADD-ROOM-TO-EAST-OR-WEST)))
  (RHS (REJECT OPERATOR ADD-ROOM-TO-EAST-OR-WEST)))


;;;
;;; If a room is required to have an outer wall on the West side, adding
;;; a room to its East or West will not achieve this.
;;;

(DO-NOT-REMOVE-OUTER-WALL-WEST  
  (LHS (AND (CURRENT-NODE <node>)
	    (CURRENT-GOAL <node> (HAS-OUTER-WALL <room> WEST))
            (CANDIDATE-OP <node> ADD-ROOM-TO-EAST-OR-WEST)))
  (RHS (REJECT OPERATOR ADD-ROOM-TO-EAST-OR-WEST)))



))


(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES*  nil)
(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)



       
	     