(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 
      '(

	(SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
		    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))

       ))

(setq *SCR-OP-SELECT-RULES*  nil)
(setq *SCR-BINDINGS-SELECT-RULES* nil)
(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES*
      '(

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;    This control rule rejects a goal of being at a place where there are
;;;  no incoming flights, unless the goal is being at the initial place.
;;;
	(AVOID-UNREACHABLE-PLACES
	 (lhs (and
	       (current-node <node>)
	       (candidate-goal <node> (at-place <p>))
	       (known <node>
		(and
		 (~ (at-place <p>))
		 (~ (flight <fi> <sp> <p> <st> <et> <af>))))))
	 (rhs (reject node <node>)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;    This control rule rejects a goal of being at a place where there is an
;;;  unsafe condition, unless the goal is being at the initial place.
;;;

	(AVOID-UNSAFE-PLACES
	 (lhs (and
	       (current-node <node>)
	       (candidate-goal <node> (at-place <p>))
	       (known <node>
		(and
		 (~ (at-place <p>))
		 (or
		  (weather <p> hazardousfog)
		  (weather <p> hazardousstorm)
		  (emergency <p>))))))
	 (rhs (reject node <node>)))

))

(setq *SCR-OP-REJECT-RULES* nil)
(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES* 
      '(

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;    This function prefers the candidate goal with the better weather rating.
;;;

	(PREFER-BETTER-PLACE
	 (priority 1)
	 (lhs (and
	       (current-node <node>)
	       (candidate-goal <node> (at <p1>))
	       (candidate-goal <node> (at <p2>))
	       (not-equal <p1> <p2>)
	       (known <node>
		(and
		 (place <p1>)
		 (place <p2>)
		 (weather <p1> <wc1>)
		 (weather <p2> <wc2>)
		 (weather-rating <wc1> <r1>)
		 (weather-rating <wc2> <r2>)
		 (less-than <r1> <r2>)))))
	 (rhs (prefer goal (at <p1>) (at <p2>))))

))
	       
(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES*
      '(

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;    This function prefers the least cost flight from a place if there is a
;;;  cost constraint.
;;;

	(PREFER-LEAST-COST-FLIGHT
	 (priority 2)
	 (lhs (and
	       (current-node <node>)
	       (candidate-bindings <node> (<fi1> <b1>))
	       (candidate-bindings <node> (<fi2> <b2>))
	       (known <node>
		(and
		 (cost-constraint <cc>)
		 (at-place <sp>)
		 (flight <fi1> <sp> <ep1> <st1> <et1> <af1>)
		 (flight <fi2> <sp> <ep2> <st2> <et2> <af2>)
		 (less-than <af1> <af2>)))))
	 (rhs (prefer bindings (<fi1> <b1>) (<fi2> <b2>))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;    This function prefers the earlier arriving flight from a place if there
;;;  is a time constraint.
;;;

	(PREFER-EARLIER-ARRIVING-FLIGHT
	 (priority 3)
	 (lhs (and
	       (current-node <node>)
  	       (candidate-bindings <node> (<fi1> <b1>))
	       (candidate-bindings <node> (<fi2> <b2>))
	       (known <node>
		(and
		 (time-constraint <tc>)
		 (at-place <sp>)
		 (flight <fi1> <sp> <ep1> <st1> <et1> <af1>)
		 (flight <fi2> <sp> <ep2> <st2> <et2> <af2>)
		 (less-than <et1> <et2>)))))
	 (rhs (prefer bindings (<fi1> <b1>) (<fi2> <b2>))))

))