;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;    This function is used to perform the comparison x<y.

(defun less-than (x y)
  (cond ((is-variable x) 'no-match-attempted)
	((is-variable y) 'no-match-attempted)
	((< x y) t)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;    This function is used to perform the comparison abs(x-y)<maxad.

(defun diff-less-than (x y maxad)
  (cond ((is-variable x) 'no-match-attempted)
	((is-variable y) 'no-match-attempted)
	((is-variable maxad) 'no-match-attempted)
	((<= maxad (abs (- x y))) t)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;    This function is used to perform the addition x+y=z.

(defun sum (x y z)
  (cond ((is-variable x) 'no-match-attempted)
	((is-variable y) 'no-match-attempted)
	((is-variable z) (list (list (list z (+ x y)))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;    This function assigns an integer value to weather conditions in order to
;;;  compare them.

(defun weather-rating (wc r)
  (cond ((is-variable wc) 'no-match-attempted)
	((is-variable r)
	 (cond ((equal wc 'clear) (list (list (list r 0))))
	       ((equal wc 'clouds) (list (list (list r 1))))
	       ((equal wc 'overcast) (list (list (list r 2))))
	       ((equal wc 'rain) (list (list (list r 3))))
	       ((equal wc 'snow) (list (list (list r 4))))
	       ((equal wc 'fog) (list (list (list r 5))))
	       ((equal wc 'rainstorm) (list (list (list r 6))))
	       ((equal wc 'snowstorm) (list (list (list r 7))))
	       ((equal wc 'hazardousfog) (list (list (list r 8))))
	       ((equal wc 'hazardousstorm) (list (list (list r 9))))))))