;;; FINGERING Domain

;;; Thomas Burg, May 91
;;; -------------------- Meta-Functions  -------------------


;;; all meta-functions have a suffix TB (Thomas Burg)
;;; to distinguish them from the built-in's.


;;; TB-IN-GOAL
;;; checks if EXP is in the goal
;;; note difference to ON-GOAL-STACK:
;;;     the latter checks only, if on the goal stack
;;;     to 'look' ahead we need access on the whole goal
;;; probably not very elegant, but it works and took the author
;;; a lot of time anyway (as he had to play with prodigy's internals)
;;; The idea is to take IS-KNOWN from the file META-FNS.LISP
;;; in the Prodigy planner and to modify it
(defun TB-IN-GOAL (exp)
    (let 
         ; create 'state': Array with 7 elements, fill only the
         ; elements needed for matching process
         ((goal-state 
	   (make-array 7)
          )
	  result)
         ; Load both 'true assertions' and 'closed-world' with
         ; the final state
         (setf (aref goal-state 5) (rest *FINAL-STATE*))
         (setf (aref goal-state 3) (rest *FINAL-STATE*))
         ; use matching function, return t or nil
	 (setq result (exp-match exp '((nil nil)) goal-state))
	 (cond ((equal result '(((nil nil))))
	        (setq result t)))
	 result))


;;; TB-NOTE-LOWER-EQUAL
;;; checks if N1 is lower or equal to N2
;;; must not be used to generate either N1 or N2
;;; uses STRING-REVERSE (see functions.lisp)
;;; makes use of the fact, that a scale is in alphabetical order
;;; still we use the mirror-imaged note names, as the scale number
;;; is in the end
(defun tb-note-lower-equal (n1 n2)
  (cond ((OR (is-variable n1) (is-variable n2))
	 'ERROR-IN-TB-META-FUNCTION-NOTE-LOWER)
	((string<= (string-reverse (string n1))
                   (string-reverse (string n2))) t)
	(t nil)))

;;; TB-NOTE-HIGHER-EQUAL
;;; guess what ...
(defun tb-note-higher-equal (n1 n2)
  (cond ((OR (is-variable n1) (is-variable n2))
	 'ERROR-IN-TB-META-FUNCTION-NOTE-HIGHER)
	((string>= (string-reverse (string n1))
                   (string-reverse (string n2))) t)
	(t nil)))

;;; the following Meta-functions are just for testing purposes
;;; they always return true and print a variable or vector

(defun TB-PRINT-VAR (var)
  (terpri) (princ "*") (setq x var) (princ var) t)


(defun TB-PRINT-VECTOR (vec)
  (do   ( (i 0 (1+ i))) 
	( (= i (first (array-dimensions vec))) t )
        (terpri) (princ i) (princ ": ")
        (princ (aref vec i))
        t))

