;;; FINGERING Domain

;;; Thomas Burg, May 91
;;; -------------------- FUNCTIONS -------------------


;;; ADD-START-STATE
;;; is only used in the problem-files
;;; it adds the predicates supplied to the start state
;;; (similar to LOAD-START-STATE, but without deleting the old)
(defun add-start-state (lst)
  (setq *START-STATE* (append *START-STATE* lst)))



;;; IS-MORE
;;; takes three arguments X, Y and M
;;; checks for    X = Y + M
;;; may be used to generate X or Y, but not M
;;; struture similar to PRODIGY manual, p. 16, LESS-THAN (2)
(defun is-more (x y m)
  (cond ((OR (AND (is-variable x) (is-variable y))
             (is-variable m))  
             'no-match-attempted)
	((is-variable y) 
             (list (list (list y (- x m)))))
	((is-variable x) 
             (list (list (list x (+ y m)))))
	(t 
             (= x (+ y m)) )))

;;; LESS-OR-EQUAL
;;; very ez:    checks if x less or equal y
;;;             x and y must be bound
(defun less-or-equal (x y)
  (cond ((OR (is-variable x) (is-variable y))
	 'no-match-attempted)
	((<= x y))))

;;; The following LISP function is used in some Meta-functions
;;; in the file MY-METAS.LISP
;;; it is NOT used as a function inside the domain
;;; it takes a string and 'turns it around a little bit',
;;; i.e it changes the order in a note, so that an alphabetical search
;;; represents its order in a scale
;;; furthermore it changes a and b to h and i in order to allow an
;;; alphabetical evaluation

(defun string-reverse (s0)
  (let*
      (
       ; store length of string
       (length (first (array-dimensions s0))) 
       ; create string of same length as result, fill with blanks
       (result (make-string length :initial-element #\ ))
       ; store input string in s
       (s s0)
      )
      (cond
        ; length 1: (i.e. C, D, ...) return the same
	((= length 1) (setq result s))
        ; length 2: (i.e. C1, D1,...) return mirror image
	((= length 2)
         (setf (aref result 0) (aref s 1))
	 (setf (aref result 1) (aref s 0))
        )
        ; length 3: (i.e. CS1, DS1, ...): reorder to (1CS, 1DS,...)
        ((= length 3)
	 (setf (aref result 0) (aref s 2))
	 (setf (aref result 1) (aref s 0))
	 (setf (aref result 2) (aref s 1))
        )
        ; else : return 'OOPS'
        (t (princ "OOPS") (setq result "OOPS !"))
      )
      ; change A to H
      (do ((i 0 (1+ i)))
          ((>= i length))
          (if (equal (aref result i) #\A) (setf (aref result i) #\H)))
      ; change B to I
      (do ((i 0 (1+ i)))
          ((>= i length))
          (if (equal (aref result i) #\B) (setf (aref result i) #\I)))
      ; return result
      result
))

;;; The following LISP functions are either intended for testing
;;; or are used within the HACK domain


;;; COUNT
;;; takes a number X and a list LST
;;; The List has the format described in README-DOC 7:
;;;   ((n1 c1) (n2 c2) (n3 c3) ....)
;;;   where ni is the number of solutions with the cost ci
;;; COUNT keeps track of the number of soulutions with Cost C
;;; and returns a list in same format
(defun count (x lst)
  (cond 
         ; not in list: add to list with count 1
	 ((null lst) (list (cons 1 (list x))))
         ; in list: increase count
	 ((= (second (first lst)) x)
	   (cons (cons (+ (first (first lst)) 1) (list x))
		 (rest lst)))
         ; next element of list
	 (t (cons (first lst)
	       (count x (rest lst))))))


;;; APPEND-SOLU
;;; is called in HACK-domain
;;; returns always t
;;; but keeps track of solutions using the global variable
;;; *SOLU-L*
;;; calls function COUNT
(defun append-solu (x)
  (setq *solu-l* (count x *solu-l*))
  (terpri) (princ "solutions so far: ") (princ *solu-l*)
  t
)
	
;;; PRINTOUT
;;; may be used within domain to print a variable
(defun printout (x)
  (princ x) t )


         
      

  
