; domain.lisp

; FINGERING Domain

; Thomas Burg
; ------------ DOMAIN --------------

; for general comments see README file !
; --> especially for a brief overview on the operators

(setq *OPERATORS* '(


;;; The following Op. achieves the last goal in the goal-list supplied
;;; in the problem file. (Remember: The goals are ordered !)
;;; It just checks if the solution we have come up with is short
;;; enough; if so it adds the final goal to the state and thus
;;; achieves a solution.
;;; If not it fails, resulting in backtracking in the search.
;;; (Concept of cost: See README file)
(HURRAY-WE-ARE-DONE
  (preconds
     (AND
        (cost-so-far <actual-cost>)
        (less-or-equal <actual-cost> <desired-cost>)
     ))
  (effects
     (
      (add (most-cost <desired-cost>)))))


;;; in the following we see the operators discussed in the README-DOC file
;;; under 5.

;;; the following 5 operators play a note if possible, which means
;;; if note is within reach of the hand, respectively a finger
;;; Only the first one (PLAY-NOTE-THUMB) is commented, the next four
;;; are pretty much the same

;;; Play note with thumb already in correct position
(PLAY-NOTE-THUMB
 (params (<note> <C-new> <N-played-new>))
 (preconds
  (AND
       (pitch <note>)
       (thumb <note>)                       ;check if thumb is on <note>
       ; the following four lines of code are in nearly every operator:
       ; - the first line generates <N-played-old> using the LISP-function
       ;   IS-ONE-MORE. <N-played-new> is bound in the effects.
       ; - the second line checks if the note which CAN be played with
       ;   the thumb is the note which SHALL be played NOW
       ; - the third and fourth line keep track of the COST
       ;   (see README-DOC, 4.) in a very similar way
       ; note the use of the LISP function IS-MORE as a generator
       (is-more <N-played-new> <N-played-old> 1)
       (played-so-far <N-played-old>)
       (cost-so-far <C-old>)
       (is-more <C-new> <C-old> 1)
       ))
(effects
  (
   ; update number of notes played
   (del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   ; update Counter for Cost so far
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))
   ; add new note played
   (add (play-note <note> <N-played-new>)))))

;;; Play note with Index already in correct position
(PLAY-NOTE-INDEX
 (params (<note> <C-new> <N-played-new>))
 (preconds
  (AND
       (pitch <note>)
       (index <note>)                       ;index is on <note>
       (is-more <N-played-new> <N-played-old> 1)
       (played-so-far <N-played-old>)
       (cost-so-far <C-old>)
       (is-more <C-new> <C-old> 1)))
(effects
  ((del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))
   (add (play-note <note> <N-played-new>)))))

;;; Play note with Middle already in correct position
(PLAY-NOTE-MIDDLE
 (params (<note> <C-new> <N-played-new>))
 (preconds
  (AND
       (pitch <note>)
       (middle <note>)                      ;middle is on <note>
       (is-more <N-played-new> <N-played-old> 1)
       (played-so-far <N-played-old>)
       (cost-so-far <C-old>)
       (is-more <C-new> <C-old> 1)))
(effects
  ((del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))
   (add (play-note <note> <N-played-new>)))))

;;; Play note with Ring already in correct position
(PLAY-NOTE-RING
 (params (<note> <C-new> <N-played-new>))
 (preconds
  (AND
       (pitch <note>)                      
       (ring <note>)                       ;ring is on <note>
       (is-more <N-played-new> <N-played-old> 1)
       (played-so-far <N-played-old>)
       (cost-so-far <C-old>)
       (is-more <C-new> <C-old> 1)))
(effects
  ((del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))
   (add (play-note <note> <N-played-new>)))))

;;; Play note with Pinky already in correct position
(PLAY-NOTE-PINKY
 (params (<note> <C-new> <N-played-new>))
 (preconds
  (AND
       (pitch <note>)
       (pinky <note>)                       ;pinky is on <note>
       (is-more <N-played-new> <N-played-old> 1)
       (played-so-far <N-played-old>)
       (cost-so-far <C-old>)
       (is-more <C-new> <C-old> 1)))
(effects
  ((del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))
   (add (play-note <note> <N-played-new>)))))


;;; The following three operators move the hand by shifting the thumb under
;;; another finger. Thus (the right) hand moves to the RIGHT. (See 5.2.)
;;; Again, only the first operator is commented

; Move Thumb under Index
(THUMB-UNDER-INDEX 
 (params (<note-thumb-new> <C-new> <N-played-new>))
 (preconds
  (AND
   ; bind old positions of fingers
   ; we use non-static generators here, see comments in README-DOC file
   (thumb <note-thumb-old>)           
   (index <note-index-old>)
   (middle <note-middle-old>)
   (ring <note-ring-old>)
   (pinky <note-pinky-old>)
   ; check if move suitable, i.e. moving thumb under index would end up
   ; on the next note to play (compare effects: play-note <note-thumb-new>)
   (next-note <note-index-old> <note-thumb-new>)
   ; check time-constraint (right note NOW ?)
   (is-more <N-played-new> <N-played-old> 1)
   (played-so-far <N-played-old>)
   ; get old cost, bind new cost
   (cost-so-far <C-old>)
   (is-more <C-new> <C-old> 2)
   ; check if note before has been played with Index
   (play-note <note-index-old> <N-played-old>)
   ; bind new positions
   ; <note-thumb-new> has been bound in the effects, the other new positions
   ; follow directly from <note-thumb-new>
   (next-note <note-thumb-new> <note-index-new>)
   (next-note <note-index-new> <note-middle-new>)
   (next-note <note-middle-new> <note-ring-new>)
   (next-note <note-ring-new> <note-pinky-new>)
 ))
 (effects
  (
   ; delete old hand positions
   (del (thumb <note-thumb-old>))             
   (del (index <note-index-old>))
   (del (middle <note-middle-old>))
   (del (ring <note-ring-old>))
   (del (pinky <note-pinky-old>))
   ; add new ones
   (add (thumb <note-thumb-new>))
   (add (index <note-index-new>))
   (add (middle <note-middle-new>))
   (add (ring <note-ring-new>))
   (add (pinky <note-pinky-new>))
   ; counters
   (del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))
   ; note played
   (add (play-note <note-thumb-new> <N-played-new>)))))

; Move Thumb under Middle
(THUMB-UNDER-MIDDLE
 (params (<note-thumb-new> <C-new> <N-played-new>))
 (preconds
  (AND
   (thumb <note-thumb-old>)           
   (index <note-index-old>)
   (middle <note-middle-old>)
   (ring <note-ring-old>)
   (pinky <note-pinky-old>)

   (next-note <note-middle-old> <note-thumb-new>)

   (is-more <N-played-new> <N-played-old> 1)
   (played-so-far <N-played-old>)
   (cost-so-far <C-old>)
   (is-more <C-new> <C-old> 2)

   ; check if note before has been played with Middle
   (play-note <note-middle-old> <N-played-old>)

   (next-note <note-thumb-new> <note-index-new>)
   (next-note <note-index-new> <note-middle-new>)
   (next-note <note-middle-new> <note-ring-new>)
   (next-note <note-ring-new> <note-pinky-new>)
 ))
 (effects
  (
   (del (thumb <note-thumb-old>))
   (del (index <note-index-old>))
   (del (middle <note-middle-old>))
   (del (ring <note-ring-old>))
   (del (pinky <note-pinky-old>))
   (add (thumb <note-thumb-new>))
   (add (index <note-index-new>))
   (add (middle <note-middle-new>))
   (add (ring <note-ring-new>))
   (add (pinky <note-pinky-new>))

   (del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))

   (add (play-note <note-thumb-new> <N-played-new>)))))

; Move Thumb under Ring
(THUMB-UNDER-RING 
 (params (<note-thumb-new> <C-new> <N-played-new>))
 (preconds
  (AND
   (thumb <note-thumb-old>)           
   (index <note-index-old>)
   (middle <note-middle-old>)
   (ring <note-ring-old>)
   (pinky <note-pinky-old>)

   (next-note <note-ring-old> <note-thumb-new>)

   (is-more <N-played-new> <N-played-old> 1)
   (played-so-far <N-played-old>)
   (cost-so-far <C-old>)
   (is-more <C-new> <C-old> 2)

   ; check if note before has been played with Ring
   (play-note <note-ring-old> <N-played-old>)

   (next-note <note-thumb-new> <note-index-new>)
   (next-note <note-index-new> <note-middle-new>)
   (next-note <note-middle-new> <note-ring-new>)
   (next-note <note-ring-new> <note-pinky-new>)
 ))
 (effects
  (    
   (del (thumb <note-thumb-old>))             
   (del (index <note-index-old>))
   (del (middle <note-middle-old>))
   (del (ring <note-ring-old>))
   (del (pinky <note-pinky-old>))
   (add (thumb <note-thumb-new>))
   (add (index <note-index-new>))
   (add (middle <note-middle-new>))
   (add (ring <note-ring-new>))
   (add (pinky <note-pinky-new>))

   (del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))

   (add (play-note <note-thumb-new> <N-played-new>)))))


;;; The following three operators move the hand by shifting a finger over
;;; the thumb. Thus (the right) hand moves to the LEFT. (See 5.3.)
;;; The operators are vey similar to THUMB-OVER-xxxx
;;; thus they are not commented

; Move Index over thumb
(INDEX-OVER-THUMB 
 (params (<note-index-new> <C-new> <N-played-new>))
 (preconds
  (AND
   (thumb <note-thumb-old>)           
   (index <note-index-old>)
   (middle <note-middle-old>)
   (ring <note-ring-old>)
   (pinky <note-pinky-old>)

   (next-note <note-index-new> <note-thumb-old>)

   (is-more <N-played-new> <N-played-old> 1)
   (played-so-far <N-played-old>)
   (cost-so-far <C-old>)
   (is-more <C-new> <C-old> 2)
   ; check if note before has been played with Thumb
   (play-note <note-thumb-old> <N-played-old>)

   (next-note <note-index-new> <note-middle-new>)
   (next-note <note-thumb-new> <note-index-new>)
   (next-note <note-middle-new> <note-ring-new>)
   (next-note <note-ring-new> <note-pinky-new>)
 ))
 (effects
  (
   (del (thumb <note-thumb-old>))
   (del (index <note-index-old>))
   (del (middle <note-middle-old>))
   (del (ring <note-ring-old>))
   (del (pinky <note-pinky-old>))
   (add (thumb <note-thumb-new>))
   (add (index <note-index-new>))
   (add (middle <note-middle-new>))
   (add (ring <note-ring-new>))
   (add (pinky <note-pinky-new>))

   (del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))

   (add (play-note <note-index-new> <N-played-new>)))))

; Move Middle over Thumb
(MIDDLE-OVER-THUMB 
 (params (<note-middle-new> <C-new> <N-played-new>))
 (preconds
  (AND
   (thumb <note-thumb-old>)           
   (index <note-index-old>)
   (middle <note-middle-old>)
   (ring <note-ring-old>)
   (pinky <note-pinky-old>)

   (next-note <note-middle-new> <note-thumb-old>)

   (is-more <N-played-new> <N-played-old> 1)
   (played-so-far <N-played-old>)
   (cost-so-far <C-old>)
   (is-more <C-new> <C-old> 2)

   ; check if note before has been played with Thumb
   (play-note <note-thumb-old> <N-played-old>)

   (next-note <note-index-new> <note-middle-new>)
   (next-note <note-thumb-new> <note-index-new>)
   (next-note <note-middle-new> <note-ring-new>)
   (next-note <note-ring-new> <note-pinky-new>)
 ))
 (effects
  (
   (del (thumb <note-thumb-old>))
   (del (index <note-index-old>))
   (del (middle <note-middle-old>))
   (del (ring <note-ring-old>))
   (del (pinky <note-pinky-old>))

   (add (thumb <note-thumb-new>))
   (add (index <note-index-new>))
   (add (middle <note-middle-new>))
   (add (ring <note-ring-new>))
   (add (pinky <note-pinky-new>))

   (del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))

   (add (play-note <note-middle-new> <N-played-new>)))))

; Move Ring over Thumb
(RING-OVER-THUMB 
 (params (<note-ring-new> <C-new> <N-played-new>))
 (preconds
  (AND
   (thumb <note-thumb-old>)           
   (index <note-index-old>)
   (middle <note-middle-old>)
   (ring <note-ring-old>)
   (pinky <note-pinky-old>)
   (thumb <note-thumb-old>)                 

   (next-note <note-ring-new> <note-thumb-old>)

   (is-more <N-played-new> <N-played-old> 1)
   (played-so-far <N-played-old>)
   (cost-so-far <C-old>)
   (is-more <C-new> <C-old> 2)

   ; check if note before has been played with Thumb
   (play-note <note-thumb-old> <N-played-old>)

   (next-note <note-index-new> <note-middle-new>)
   (next-note <note-thumb-new> <note-index-new>)
   (next-note <note-middle-new> <note-ring-new>)
   (next-note <note-ring-new> <note-pinky-new>)
 ))
 (effects
  (
   (del (thumb <note-thumb-old>))
   (del (index <note-index-old>))
   (del (middle <note-middle-old>))
   (del (ring <note-ring-old>))
   (del (pinky <note-pinky-old>))
   (add (thumb <note-thumb-new>))
   (add (index <note-index-new>))
   (add (middle <note-middle-new>))
   (add (ring <note-ring-new>))
   (add (pinky <note-pinky-new>))

   (del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))

   (add (play-note <note-ring-new> <N-played-new>)))))


;;; The following five operators are the 'brutal approach' and shall be
;;; used only seldomly
;;; They just 'jump' to a new position on the keyboard regardless
;;; of the old one.

; Jump to a new position with Thumb playing the first note
(JUMP-THUMB
 (params (<note-thumb-new> <C-new> <N-played-new>))
 (preconds
   (AND
   ; just check time constraint and calculate cost, no 'real' preconditions
   (is-more <N-played-new> <N-played-old> 1)
   (played-so-far <N-played-old>)
   (cost-so-far <C-old>)
   (is-more <C-new> <C-old> 9)
   ; bind new positions:
   ; <note-thumb-new> is bound in the effects, the other positions follow
   (next-note <note-thumb-new> <note-index-new>)
   (next-note <note-index-new> <note-middle-new>)
   (next-note <note-middle-new> <note-ring-new>)
   (next-note <note-ring-new> <note-pinky-new>)
 ))
 (effects
  (
   ; delete old finger positions, use wildcard variables as there
   ; might be none (in the beginning) and thus they are not bound
   (del (thumb <*note-thumb-old*>))
   (del (index <*note-index-old*>))
   (del (middle <*note-middle-old*>))
   (del (ring <*note-ring-ol*d>))
   (del (pinky <*note-pinky-old*>))
   ; add new ones
   (add (thumb <note-thumb-new>))
   (add (index <note-index-new>))
   (add (middle <note-middle-new>))
   (add (ring <note-ring-new>))
   (add (pinky <note-pinky-new>))
   ; counters
   (del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))
   ; note played
   (add (play-note <note-thumb-new> <N-played-new>)))))

; Jump to a new position with Index playing the first note
(JUMP-INDEX
 (params (<note-index-new> <C-new> <N-played-new>))
 (preconds
   (AND
   (is-more <N-played-new> <N-played-old> 1)
   (played-so-far <N-played-old>)
   (cost-so-far <C-old>)
   (is-more <C-new> <C-old> 9)

   (next-note <note-thumb-new> <note-index-new>)
   (next-note <note-index-new> <note-middle-new>)
   (next-note <note-middle-new> <note-ring-new>)
   (next-note <note-ring-new> <note-pinky-new>)
 ))
 (effects
  (
   (del (thumb <*note-thumb-old*>))
   (del (index <*note-index-old*>))
   (del (middle <*note-middle-old*>))
   (del (ring <*note-ring-ol*d>))
   (del (pinky <*note-pinky-old*>))
   (add (thumb <note-thumb-new>))
   (add (index <note-index-new>))
   (add (middle <note-middle-new>))
   (add (ring <note-ring-new>))
   (add (pinky <note-pinky-new>))

   (del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))

   (add (play-note <note-index-new> <N-played-new>)))))

; Jump to a new position with Middle playing the first note
(JUMP-MIDDLE
 (params (<note-middle-new> <C-new> <N-played-new>))
 (preconds
   (AND
   (is-more <N-played-new> <N-played-old> 1)
   (played-so-far <N-played-old>)
   (cost-so-far <C-old>)
   (is-more <C-new> <C-old> 9)

   (next-note <note-index-new> <note-middle-new>)
   (next-note <note-thumb-new> <note-index-new>)
   (next-note <note-middle-new> <note-ring-new>)
   (next-note <note-ring-new> <note-pinky-new>)
 ))
 (effects
  (
   (del (thumb <*note-thumb-old*>))
   (del (index <*note-index-old*>))
   (del (middle <*note-middle-old*>))
   (del (ring <*note-ring-ol*d>))
   (del (pinky <*note-pinky-old*>))
   (add (thumb <note-thumb-new>))
   (add (index <note-index-new>))
   (add (middle <note-middle-new>))
   (add (ring <note-ring-new>))
   (add (pinky <note-pinky-new>))

   (del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))

   (add (play-note <note-middle-new> <N-played-new>)))))

; Jump to a new position with Ring playing the first note
(JUMP-RING
 (params (<note-ring-new> <C-new> <N-played-new>))
 (preconds
   (AND
   (is-more <N-played-new> <N-played-old> 1)
   (played-so-far <N-played-old>)
   (cost-so-far <C-old>)
   (is-more <C-new> <C-old> 9)

   (next-note <note-ring-new> <note-pinky-new>)
   (next-note <note-thumb-new> <note-index-new>)
   (next-note <note-index-new> <note-middle-new>)
   (next-note <note-middle-new> <note-ring-new>)
 ))
 (effects
  (
   (del (thumb <*note-thumb-old*>))
   (del (index <*note-index-old*>))
   (del (middle <*note-middle-old*>))
   (del (ring <*note-ring-ol*d>))
   (del (pinky <*note-pinky-old*>))
   (add (thumb <note-thumb-new>))
   (add (index <note-index-new>))
   (add (middle <note-middle-new>))
   (add (ring <note-ring-new>))
   (add (pinky <note-pinky-new>))

   (del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))

   (add (play-note <note-ring-new> <N-played-new>)))))

; Jump to a new position with Pinky playing the first note
(JUMP-PINKY
 (params (<note-pinky-new> <C-new> <N-played-new>))
 (preconds
   (AND
   (is-more <N-played-new> <N-played-old> 1)
   (played-so-far <N-played-old>)
   (cost-so-far <C-old>)
   (is-more <C-new> <C-old> 9)

   (next-note <note-ring-new> <note-pinky-new>)
   (next-note <note-middle-new> <note-ring-new>)
   (next-note <note-index-new> <note-middle-new>)
   (next-note <note-thumb-new> <note-index-new>)
 ))
 (effects
  (
   (del (thumb <*note-thumb-old*>))
   (del (index <*note-index-old*>))
   (del (middle <*note-middle-old*>))
   (del (ring <*note-ring-ol*d>))
   (del (pinky <*note-pinky-old*>))
   (add (thumb <note-thumb-new>))
   (add (index <note-index-new>))
   (add (middle <note-middle-new>))
   (add (ring <note-ring-new>))
   (add (pinky <note-pinky-new>))

   (del (played-so-far <N-played-old>))
   (add (played-so-far <N-played-new>))
   (del (cost-so-far <C-old>))
   (add (cost-so-far <C-new>))

   (add (play-note <note-pinky-new> <N-played-new>)))))



))








