

(setq *SCR-NODE-SELECT-RULES* nil)

(setq *SCR-GOAL-SELECT-RULES* 
      '(
        (SELECT-FIRST-GOAL
          (lhs (and (current-node <node>)
                    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))))


(setq *SCR-OP-SELECT-RULES* nil)
(setq *SCR-BINDINGS-SELECT-RULES* nil)
(setq *SCR-NODE-REJECT-RULES*

;; SELECT-MEMORY-NO-SUBGOAL-MOTHERBOARD elimates useless node to be generated
;; by the static genrator (is-motherboard <obj> <price>), if a motherboard has
;; already been selected.
;; similar search control rules can be added to other nonstatic generators.

'((SELECT-MEMORY-NO-SUBGOAL-MOTHERBOARD
   (lhs (and
	 (candidate-node <n>)
	 (not-top-level-node <n>)
	 (known <n> (has-motherboard <obj>))
	 (current-op <n> SELECT-MEMORY)))
   (rhs (reject node <n>)))





;; SELECT-HARDDISK-NO-SUBGOAL-CONTROLLER elimates useless node to be 
;; generated by the static genrator (is-controller <obj> <price>), if a 
;; controller has already been selected.

 (SELECT-HARD-DISK-NO-SUBGOAL-CONTROLLER
   (lhs (and
	 (candidate-node <n>)
	 (not-top-level-node <n>)
	 (current-op <n> SELECT-HARD-DISK)
	 (current-goal <n> (has-controller <obj>))
	 (known <n> (~(has-controller <obj>)))))
   (rhs (reject node <n>)))






;; SELECT-POWERSUPPLY-NO-SUBGOAL-MOTHERBOARD elimates useless node to be 
;; generated by the static genrator (is-motherboard <obj> <price>), if a 
;; motherboard has already been selected.

 (SELECT-POWERSUPPLY-NO-SUBGOAL-MOTHERBOARD
   (lhs (and
	 (candidate-node <n>)
	 (not-top-level-node <n>)
	 (known <n> (has-motherboard <obj>))
	 (current-op <n> SELECT-POWERSUPPLY)))
   (rhs (reject node <n>)))))



(setq *SCR-GOAL-REJECT-RULES* nil) 
(setq *SCR-OP-REJECT-RULES* nil)
(setq *SCR-BINDINGS-REJECT-RULES*  nil)

;; The following search control rules compare the potential bindings of parts
;; and rejects the more expensive one.
;;
;; please note that if a particular part is specified in the goal state, this 
;; minimum cost search control rule need to be changed to prefer bindings
;; instead of reject bindings.
;;
;; Since less node expansion is desired for the problem set
;; that are tested, these control rules are commented out. They should be 
;; applied if minimum cost configuration is wanted.


;      '(

;	(REJECT-EXPENSIVE-FLOPPY-DISK
;	 (lhs (and
;	       (current-node <n>)
;	       (current-op <n> SELECT-FLOPPY-DISK)
;	       (candidate-bindings <n> (<obj1> <price1>))
;	       (candidate-bindings <n> (<obj2> <price2>))
;	       (less-than <price1> <price2>)))
;	 (rhs (reject bindings (<obj2> <price2>))))





;	(REJECT-EXPENSIVE-IO
;	 (lhs (and
;	       (current-node <n>)
;	       (current-op <n> SELECT-IO)
;	       (candidate-bindings <n> (<obj1> <price1>))
;	       (candidate-bindings <n> (<obj2> <price2>))
;	       (less-than <price1> <price2>)))
;	 (rhs (reject bindings (<obj2> <price2>))))





;	(REJECT-EXPENSIVE-KEYBOARD
;	 (lhs (and
;	       (current-node <n>)
;	       (current-op <n> SELECT-KEYBOARD)
;	       (candidate-bindings <n> (<obj1> <price1>))
;	       (candidate-bindings <n> (<obj2> <price2>))
;	       (less-than <price1> <price2>)))
;	 (rhs (reject bindings (<obj2> <price2>))))))




(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES*
      '(
	(PREFER-FIRST-GOAL
	 (PRIORITY 0)
	 (lhs (and (current-node <node>)
	           (candidate-goal <node> <goal>)
			   (not-equal <goal> (within-budget))  ;added by Etzioni.
			   ))
	 (rhs (prefer goal <goal> (within-budget))))
	))

(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)

;; The following search control rules compare the potential bindings of parts
;; and prefer the less expensive one.
;;
;; Please note that since less node expansion is desired for the problem set
;; that are tested, these control rules are commented out. They should be 
;; applied if minimum cost configuration is wanted.
;;
#|
     '(


	(PREFER-INEXPENSIVE-CASE
	 (lhs (and
	       (current-node <n>)
	       (current-op <n> SELECT-CASE)
	       (candidate-bindings <n> (<obj1> <price1>))
	       (candidate-bindings <n> (<obj2> <price2>))
	       (less-than <price1> <price2>)))
	 (rhs (prefer bindings (<obj1> <price2>)
                               (<obj2> <price2>))))




	(PREFER-INEXPENSIVE-MOTHERBOARD
	 (PRIORITY 0)
	 (lhs (and
	       (current-node <n>)
	       (current-op <n> SELECT-MOTHERBOARD)
	       (candidate-bindings <n> (<obj1> <price1>))
	       (candidate-bindings <n> (<obj2> <price2>))
	       (less-than <price1> <price2>)))
	 (rhs (prefer bindings (<obj1> <price1>)
	                       (<obj2> <price2>))))


	(PREFER-INEXPENSIVE-MEMORY
	 (PRIORITY 0)
	 (lhs (and
	       (current-node <n>)
	       (current-op <n> SELECT-MEMORY)
	       (candidate-bindings <n> (<obj1> <price1>))
	       (candidate-bindings <n> (<obj2> <price2>))
	       (less-than <price1> <price2>)))
	 (rhs (prefer bindings (<obj1> <price1>)
	                       (<obj2> <price2>))))




	(PREFER-INEXPENSIVE-CONTROLLER
	 (PRIORITY 0)
	 (lhs (and
	       (current-node <n>)
	       (current-op <n> SELECT-CONTROLLER)
	       (candidate-bindings <n> (<obj1> <price1>))
	       (candidate-bindings <n> (<obj2> <price2>))
	       (less-than <price1> <price2>)))
	 (rhs (prefer bindings (<obj1> <price1>)
	                       (<obj2> <price2>))))



	(PREFER-INEXPENSIVE-HARD-DISK
	 (PRIORITY 0)
	 (lhs (and
	       (current-node <n>)
	       (current-op <n> SELECT-HARD-DISK)
	       (candidate-bindings <n> (<obj1> <price1>))
	       (candidate-bindings <n> (<obj2> <price2>))
	       (less-than <price1> <price2>)))
	 (rhs (prefer bindings (<obj1> <price1>)
	                       (<obj2> <price2>))))




	(PREFER-INEXPENSIVE-VIDEO-BOARD
	 (PRIORITY 0)
	 (lhs (and
	       (current-node <n>)
	       (current-op <n> SELECT-VIDEO-BOARD)
	       (candidate-bindings <n> (<obj1> <price1>))
	       (candidate-bindings <n> (<obj2> <price2>))
	       (less-than <price1> <price2>)))
	 (rhs (prefer bindings (<obj1> <price1>)
	                       (<obj2> <price2>))))




	(PREFER-INEXPENSIVE-VIDEO-MONITOR
	 (PRIORITY 0)
	 (lhs (and
	       (current-node <n>)
	       (current-op <n> SELECT-VIDEO-MONITOR)
	       (candidate-bindings <n> (<obj1> <price1>))
	       (candidate-bindings <n> (<obj2> <price2>))
	       (less-than <price1> <price2>)))
	 (rhs (prefer bindings (<obj1> <price1>)
	                       (<obj2> <price2>))))))


|#












