;; These are functions for the pc_config domain:

;; The Compute cost functions are copied from Tad Orman's mail with minor 
;; modification.


;; The price of parts are of an increment of $25.
(setf price-list 
   '(50  75  100 125 150 175 200 225 250 275 
     300 325 350 375 400 425 450 475 500 525
     550 575 600 625 650 675 700 725 750 775 800))





(defun binding-list (var val-list)
  (cond ((null val-list) nil)
        ((null (car val-list)) (binding-list var (cdr val-list)))
        (t (append (list (list (list var (car val-list))))
                   (binding-list var (cdr val-list))))))



;; Compute-cost has three parameters: current-cost, new-cost, price.
;; The functions compute the value of the three parameters using the 
;; equation new-cost = current-cost + price. 

(defun Compute-cost ( budget current-cost new-cost price)

         ;;cannot compute value if all 3 paramters are variables.
  (cond ((and (is-variable current-cost) (is-variable new-cost) (is-variable price))
	  'no-match-attempted)

         ;;only price is constant, generate lists of possible current-cost and
	 ;;new-cost for binding.
	((and (is-variable current-cost) (is-variable new-cost))
	 (append
	  (binding-list current-cost        (generate-current-new-cost price))
	  (binding-list new-cost  (rest (generate-current-new-cost budget price)))))

	 ;;only new-cost is constant, generate lists of possible current-cost 
	 ;;and price for binding.
	((and (is-variable current-cost) (is-variable price))
	 (append
	  (binding-list price price-list)

	  (binding-list current  (generate-current-cost new-cost price-list))))

	 ;;only current-cost is constant, generate lists of possible new-cost 
	 ;;and price for binding.
	((and (is-variable new-cost) (is-variable price))
	 (append
	  (binding-list price price-list)
	  (binding-list new-cost  (generate-new-cost current-cost price-list))))

	 ;;bind current-cost = new-cost - price
	((is-variable current-cost)
	 (binding-list current-cost  (list (- new-cost price))))
 
 	 ;;bind new-cost = current-cost + price
	((is-variable new-cost)
	 (binding-list new-cost  (list (+ current-cost price))))

	 ;;bind price = new-cost - current-cost
	((is-variable price)
	 (binding-list price (list (- new-cost current-cost))))

	(t (= new-cost (+ current-cost price)))))





(defun generate-current-new-cost (budget price &optional (n 0))
   (cond 
     ((> n budget) nil)
     ((cons (+ price n) (generate-current-new-cost price (+ n price))))))



(defun generate-new-cost (current-cost price)
  (cond
    ((null price) nil)
    (t (cons (+ (first price) current-cost) 
       (generate-new-price current-cost (rest price))))))



(defun generate-current-cost (new price)
  (cond
    ((null price) nil)
    ((OR (plusp (- new (first price))) (zerop (- new (first price))))
     (cons (- new (first price)) (generate-current-cost new (rest price))))
    (t nil)))




(defun Equal-or-less-than (x y)
  (cond
    ((and (is-variable x) (is-variable y))
     'no-match-attempted)
    ((is-variable x)
     (binding-list x (generate-cost y)))
    ((is-variable y)
     'no-match-attempted)
    (t ( <= x y))))




;; generate possible cost for a complete configuration. assume right now
;; minimum cost is 1000.
(defun generate-cost (budget &optional (n 1000)) 
  (cond 
    ((= n budget) nil)
    (t (cons n  (generate-cost budget (+ n 25))))))






(defun equal-p (x y)
  "determine whether two things are equal. If one of the args is 
   a variable it will get bound to the other argument."
  (cond ((and (is-variable x) (is-variable y)) 'no-match-attempted)
	((is-variable x) `(((,x ,y))))
	((is-variable y) `(((,y ,x))))
	(t (equal x y))))





